/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.jdbc.dialect;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.connector.jdbc.internal.converter.JdbcRowConverter;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.inlong.sort.jdbc.converter.sqlserver.SqlServerRowConvert;
import org.apache.inlong.sort.jdbc.table.AbstractJdbcDialect;

public class SqlServerDialect
extends AbstractJdbcDialect {
    private static final long serialVersionUID = 5401176426209040158L;
    private static final int MAX_TIMESTAMP_PRECISION = 3;
    private static final int MIN_TIMESTAMP_PRECISION = 0;
    private static final int MAX_DECIMAL_PRECISION = 38;
    private static final int MIN_DECIMAL_PRECISION = 1;

    @Override
    public String dialectName() {
        return "SqlServer";
    }

    @Override
    public boolean canHandle(String url) {
        return url.startsWith("jdbc:sqlserver:");
    }

    @Override
    public JdbcRowConverter getRowConverter(RowType rowType) {
        return new SqlServerRowConvert(rowType);
    }

    @Override
    public String getLimitClause(long limit) {
        return "LIMIT " + limit;
    }

    @Override
    public int maxDecimalPrecision() {
        return 38;
    }

    @Override
    public int minDecimalPrecision() {
        return 1;
    }

    @Override
    public int maxTimestampPrecision() {
        return 3;
    }

    @Override
    public int minTimestampPrecision() {
        return 0;
    }

    @Override
    public List<LogicalTypeRoot> unsupportedTypes() {
        return Arrays.asList(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE, LogicalTypeRoot.INTERVAL_YEAR_MONTH, LogicalTypeRoot.INTERVAL_DAY_TIME, LogicalTypeRoot.ARRAY, LogicalTypeRoot.MULTISET, LogicalTypeRoot.MAP, LogicalTypeRoot.ROW, LogicalTypeRoot.DISTINCT_TYPE, LogicalTypeRoot.STRUCTURED_TYPE, LogicalTypeRoot.NULL, LogicalTypeRoot.RAW, LogicalTypeRoot.SYMBOL, LogicalTypeRoot.UNRESOLVED);
    }

    @Override
    public Optional<String> defaultDriverName() {
        return Optional.of("com.microsoft.sqlserver.jdbc.SQLServerDriver");
    }

    @Override
    public String quoteIdentifier(String identifier) {
        return identifier;
    }

    @Override
    public Optional<String> getUpsertStatement(String tableName, String[] fieldNames, String[] uniqueKeyFields) {
        StringBuilder sb = new StringBuilder();
        sb.append("MERGE INTO ").append(tableName).append(" T1 USING (").append(this.buildQueryStatement(fieldNames)).append(") T2 ON (").append(this.buildConditions(uniqueKeyFields)).append(") ");
        String updateSql = this.buildUpdateConnection(fieldNames, uniqueKeyFields);
        if (StringUtils.isNotEmpty(updateSql)) {
            sb.append(" WHEN MATCHED THEN UPDATE SET ").append(updateSql);
        }
        sb.append(" WHEN NOT MATCHED THEN INSERT (").append(Arrays.stream(fieldNames).map(this::quoteIdentifier).collect(Collectors.joining(","))).append(") VALUES (").append(Arrays.stream(fieldNames).map(col -> "T2." + this.quoteIdentifier((String)col)).collect(Collectors.joining(","))).append(");");
        return Optional.of(sb.toString());
    }

    private String buildQueryStatement(String[] column) {
        StringBuilder sb = new StringBuilder("SELECT ");
        String collect = Arrays.stream(column).map(col -> " :".concat((String)col).concat(" ") + this.quoteIdentifier((String)col)).collect(Collectors.joining(", "));
        sb.append(collect);
        return sb.toString();
    }

    private String buildConditions(String[] uniqueKeyFields) {
        return Arrays.stream(uniqueKeyFields).map(col -> "T1." + this.quoteIdentifier((String)col) + "=T2." + this.quoteIdentifier((String)col)).collect(Collectors.joining(","));
    }

    private String buildUpdateConnection(String[] fieldNames, String[] uniqueKeyFields) {
        List<String> uniqueKeyList = Arrays.asList(uniqueKeyFields);
        return Arrays.stream(fieldNames).filter(col -> !uniqueKeyList.contains(col)).map(col -> this.quoteIdentifier("T1") + "." + this.quoteIdentifier((String)col) + " =ISNULL(" + this.quoteIdentifier("T2") + "." + this.quoteIdentifier((String)col) + "," + this.quoteIdentifier("T1") + "." + this.quoteIdentifier((String)col) + ")").collect(Collectors.joining(","));
    }
}

