/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.jdbc.dialect;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.connector.jdbc.internal.converter.JdbcRowConverter;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.inlong.sort.jdbc.converter.oracle.OracleRowConverter;
import org.apache.inlong.sort.jdbc.table.AbstractJdbcDialect;

public class OracleDialect
extends AbstractJdbcDialect {
    private static final long serialVersionUID = 1L;
    private static final int MAX_TIMESTAMP_PRECISION = 9;
    private static final int MIN_TIMESTAMP_PRECISION = 1;
    private static final int MAX_DECIMAL_PRECISION = 38;
    private static final int MIN_DECIMAL_PRECISION = 1;

    @Override
    public JdbcRowConverter getRowConverter(RowType rowType) {
        return new OracleRowConverter(rowType);
    }

    @Override
    public String getLimitClause(long limit) {
        return "FETCH FIRST " + limit + " ROWS ONLY";
    }

    @Override
    public Optional<String> defaultDriverName() {
        return Optional.of("oracle.jdbc.OracleDriver");
    }

    @Override
    public String dialectName() {
        return "Oracle";
    }

    @Override
    public boolean canHandle(String url) {
        return url.startsWith("jdbc:oracle:");
    }

    @Override
    public String quoteIdentifier(String identifier) {
        return identifier;
    }

    @Override
    public Optional<String> getUpsertStatement(String tableName, String[] fieldNames, String[] uniqueKeyFields) {
        String sourceFields = Arrays.stream(fieldNames).map(f -> ":" + f + " " + this.quoteIdentifier((String)f)).collect(Collectors.joining(", "));
        String onClause = Arrays.stream(uniqueKeyFields).map(f -> "t." + this.quoteIdentifier((String)f) + "=s." + this.quoteIdentifier((String)f)).collect(Collectors.joining(" and "));
        Set uniqueKeyFieldsSet = Arrays.stream(uniqueKeyFields).collect(Collectors.toSet());
        String updateClause = Arrays.stream(fieldNames).filter(f -> !uniqueKeyFieldsSet.contains(f)).map(f -> "t." + this.quoteIdentifier((String)f) + "=s." + this.quoteIdentifier((String)f)).collect(Collectors.joining(", "));
        String insertFields = Arrays.stream(fieldNames).map(this::quoteIdentifier).collect(Collectors.joining(", "));
        String valuesClause = Arrays.stream(fieldNames).map(f -> "s." + this.quoteIdentifier((String)f)).collect(Collectors.joining(", "));
        String mergeQuery = " MERGE INTO " + tableName + " t  USING (SELECT " + sourceFields + " FROM DUAL) s  ON (" + onClause + ")  WHEN MATCHED THEN UPDATE SET " + updateClause + " WHEN NOT MATCHED THEN INSERT (" + insertFields + ") VALUES (" + valuesClause + ")";
        return Optional.of(mergeQuery);
    }

    @Override
    public int maxDecimalPrecision() {
        return 38;
    }

    @Override
    public int minDecimalPrecision() {
        return 1;
    }

    @Override
    public int maxTimestampPrecision() {
        return 9;
    }

    @Override
    public int minTimestampPrecision() {
        return 1;
    }

    @Override
    public List<LogicalTypeRoot> unsupportedTypes() {
        return Arrays.asList(LogicalTypeRoot.BINARY, LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE, LogicalTypeRoot.INTERVAL_YEAR_MONTH, LogicalTypeRoot.INTERVAL_DAY_TIME, LogicalTypeRoot.MULTISET, LogicalTypeRoot.MAP, LogicalTypeRoot.ROW, LogicalTypeRoot.DISTINCT_TYPE, LogicalTypeRoot.STRUCTURED_TYPE, LogicalTypeRoot.NULL, LogicalTypeRoot.RAW, LogicalTypeRoot.SYMBOL, LogicalTypeRoot.UNRESOLVED);
    }
}

