/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.jdbc.dialect;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.connector.jdbc.internal.converter.JdbcRowConverter;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.inlong.sort.jdbc.converter.clickhouse.ClickHouseRowConverter;
import org.apache.inlong.sort.jdbc.table.AbstractJdbcDialect;

public class ClickHouseDialect
extends AbstractJdbcDialect {
    private static final int MAX_TIMESTAMP_PRECISION = 8;
    private static final int MIN_TIMESTAMP_PRECISION = 0;
    private static final int MAX_DECIMAL_PRECISION = 128;
    private static final int MIN_DECIMAL_PRECISION = 32;

    @Override
    public String dialectName() {
        return "ClickHouse";
    }

    @Override
    public boolean canHandle(String url) {
        return url.startsWith("jdbc:clickhouse:");
    }

    @Override
    public JdbcRowConverter getRowConverter(RowType rowType) {
        return new ClickHouseRowConverter(rowType);
    }

    @Override
    public String getLimitClause(long limit) {
        return "LIMIT " + limit;
    }

    @Override
    public Optional<String> defaultDriverName() {
        return Optional.of("ru.yandex.clickhouse.ClickHouseDriver");
    }

    @Override
    public String quoteIdentifier(String identifier) {
        return "`" + identifier + "`";
    }

    @Override
    public int maxDecimalPrecision() {
        return 128;
    }

    @Override
    public int minDecimalPrecision() {
        return 32;
    }

    @Override
    public int maxTimestampPrecision() {
        return 8;
    }

    @Override
    public int minTimestampPrecision() {
        return 0;
    }

    @Override
    public List<LogicalTypeRoot> unsupportedTypes() {
        return Arrays.asList(LogicalTypeRoot.BINARY, LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE, LogicalTypeRoot.INTERVAL_YEAR_MONTH, LogicalTypeRoot.INTERVAL_DAY_TIME, LogicalTypeRoot.ARRAY, LogicalTypeRoot.MULTISET, LogicalTypeRoot.MAP, LogicalTypeRoot.ROW, LogicalTypeRoot.DISTINCT_TYPE, LogicalTypeRoot.STRUCTURED_TYPE, LogicalTypeRoot.NULL, LogicalTypeRoot.RAW, LogicalTypeRoot.SYMBOL, LogicalTypeRoot.UNRESOLVED);
    }

    @Override
    public String getUpdateStatement(String tableName, String[] fieldNames, String[] conditionFields) {
        String setClause = Arrays.stream(fieldNames).map(f -> String.format("%s = :%s", this.quoteIdentifier((String)f), f)).collect(Collectors.joining(", "));
        String conditionClause = Arrays.stream(conditionFields).map(f -> String.format("%s = :%s", this.quoteIdentifier((String)f), f)).collect(Collectors.joining(" AND "));
        return "ALTER TABLE " + this.quoteIdentifier(tableName) + " UPDATE " + setClause + " WHERE " + conditionClause;
    }

    @Override
    public String getDeleteStatement(String tableName, String[] conditionFields) {
        String conditionClause = Arrays.stream(conditionFields).map(f -> String.format("%s = :%s", this.quoteIdentifier((String)f), f)).collect(Collectors.joining(" AND "));
        return "ALTER TABLE " + this.quoteIdentifier(tableName) + " DELETE WHERE " + conditionClause;
    }
}

