/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.jdbc.converter.oracle;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import oracle.jdbc.internal.OracleBlob;
import oracle.jdbc.internal.OracleClob;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.CHAR;
import oracle.sql.DATE;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPTZ;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.inlong.sort.jdbc.converter.AbstractJdbcRowConverter;

public class OracleRowConverter
extends AbstractJdbcRowConverter {
    private static final long serialVersionUID = 1L;

    public OracleRowConverter(RowType rowType) {
        super(rowType);
    }

    @Override
    public AbstractJdbcRowConverter.JdbcDeserializationConverter createInternalConverter(LogicalType type) {
        switch (type.getTypeRoot()) {
            case NULL: {
                return val2 -> null;
            }
            case BOOLEAN: {
                return val2 -> val2 instanceof NUMBER ? Boolean.valueOf(((NUMBER)val2).booleanValue()) : val2;
            }
            case FLOAT: {
                return val2 -> val2 instanceof NUMBER ? Float.valueOf(((NUMBER)val2).floatValue()) : (val2 instanceof BINARY_FLOAT ? Float.valueOf(((BINARY_FLOAT)val2).floatValue()) : (val2 instanceof BigDecimal ? Float.valueOf(((BigDecimal)val2).floatValue()) : val2));
            }
            case DOUBLE: {
                return val2 -> val2 instanceof NUMBER ? Double.valueOf(((NUMBER)val2).doubleValue()) : (val2 instanceof BINARY_DOUBLE ? Double.valueOf(((BINARY_DOUBLE)val2).doubleValue()) : (val2 instanceof BigDecimal ? Double.valueOf(((BigDecimal)val2).doubleValue()) : val2));
            }
            case TINYINT: {
                return val2 -> val2 instanceof NUMBER ? Byte.valueOf(((NUMBER)val2).byteValue()) : (val2 instanceof BigDecimal ? Byte.valueOf(((BigDecimal)val2).byteValue()) : val2);
            }
            case SMALLINT: {
                return val2 -> val2 instanceof NUMBER ? Short.valueOf(((NUMBER)val2).shortValue()) : (val2 instanceof BigDecimal ? Short.valueOf(((BigDecimal)val2).shortValue()) : val2);
            }
            case INTEGER: {
                return val2 -> val2 instanceof NUMBER ? Integer.valueOf(((NUMBER)val2).intValue()) : (val2 instanceof BigDecimal ? Integer.valueOf(((BigDecimal)val2).intValue()) : val2);
            }
            case BIGINT: {
                return val2 -> val2 instanceof NUMBER ? Long.valueOf(((NUMBER)val2).longValue()) : (val2 instanceof BigDecimal ? Long.valueOf(((BigDecimal)val2).longValue()) : val2);
            }
            case DECIMAL: {
                int precision = ((DecimalType)type).getPrecision();
                int scale = ((DecimalType)type).getScale();
                return val2 -> val2 instanceof BigInteger ? DecimalData.fromBigDecimal((BigDecimal)new BigDecimal((BigInteger)val2, 0), (int)precision, (int)scale) : DecimalData.fromBigDecimal((BigDecimal)((BigDecimal)val2), (int)precision, (int)scale);
            }
            case CHAR: 
            case VARCHAR: {
                return val2 -> val2 instanceof CHAR ? StringData.fromString((String)((CHAR)val2).getString()) : (val2 instanceof OracleClob ? StringData.fromString((String)((OracleClob)val2).stringValue()) : StringData.fromString((String)((String)val2)));
            }
            case BINARY: 
            case VARBINARY: 
            case RAW: {
                return val2 -> val2 instanceof RAW ? ((RAW)val2).getBytes() : (val2 instanceof OracleBlob ? ((OracleBlob)val2).getBytes(1L, (int)((OracleBlob)val2).length()) : val2.toString().getBytes());
            }
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_DAY_TIME: {
                return val2 -> val2 instanceof NUMBER ? Integer.valueOf(((NUMBER)val2).intValue()) : val2;
            }
            case DATE: {
                return val2 -> val2 instanceof DATE ? (int)((DATE)val2).dateValue().toLocalDate().toEpochDay() : (val2 instanceof Timestamp ? (int)((Timestamp)val2).toLocalDateTime().toLocalDate().toEpochDay() : (int)((Date)val2).toLocalDate().toEpochDay());
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return val2 -> val2 instanceof DATE ? (int)(((DATE)val2).timeValue().toLocalTime().toNanoOfDay() / 1000000L) : (int)(((Time)val2).toLocalTime().toNanoOfDay() / 1000000L);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return val2 -> val2 instanceof TIMESTAMP ? TimestampData.fromTimestamp((Timestamp)((TIMESTAMP)val2).timestampValue()) : TimestampData.fromTimestamp((Timestamp)((Timestamp)val2));
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                return val2 -> {
                    if (val2 instanceof TIMESTAMPTZ) {
                        TIMESTAMPTZ ts = (TIMESTAMPTZ)val2;
                        ZonedDateTime zdt = ZonedDateTime.ofInstant(ts.timestampValue().toInstant(), ts.getTimeZone().toZoneId());
                        return TimestampData.fromLocalDateTime((LocalDateTime)zdt.toLocalDateTime());
                    }
                    return TimestampData.fromTimestamp((Timestamp)((Timestamp)val2));
                };
            }
        }
        return super.createInternalConverter(type);
    }

    @Override
    public String converterName() {
        return "Oracle";
    }
}

