/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.monitor;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.inlong.common.monitor.LogCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorIndex {
    private static final Logger logger = LoggerFactory.getLogger(MonitorIndex.class);
    private static final LogCounter logPrinter = new LogCounter(10, 100000, 60000);
    private IndexCollectThread indexCol;
    private String name;
    private ConcurrentHashMap<String, String> counterMap = new ConcurrentHashMap();
    private int intervalSec;
    private int maxCnt;

    public MonitorIndex(String name, int intervalSec, int maxCnt) {
        this.intervalSec = intervalSec;
        this.name = name;
        this.maxCnt = maxCnt;
        this.indexCol = new IndexCollectThread();
        this.indexCol.setDaemon(true);
        this.indexCol.setName("IndexCollectThread_MonitorIndex");
        this.indexCol.start();
    }

    public void addAndGet(String key, int cnt, int packcnt, long packsize, int failcnt) {
        block5: {
            try {
                if (this.counterMap.size() < this.maxCnt) {
                    this.counterMap.compute(key, (key1, value) -> {
                        if (value != null) {
                            String[] va = value.split("#");
                            value = Integer.parseInt(va[0]) + cnt + "#" + (Integer.parseInt(va[1]) + packcnt) + "#" + (Long.parseLong(va[2]) + packsize) + "#" + (Integer.parseInt(va[3]) + failcnt);
                        } else {
                            StringBuilder stringBuilder = new StringBuilder();
                            value = stringBuilder.append(cnt).append("#").append(packcnt).append("#").append(packsize).append("#").append(failcnt).toString();
                        }
                        return value;
                    });
                } else if (logPrinter.shouldPrint()) {
                    logger.error(this.name + "exceed monitor's max size");
                }
            }
            catch (Exception e) {
                if (!logPrinter.shouldPrint()) break block5;
                logger.error("monitor exception", e);
            }
        }
    }

    public void shutDown() {
        this.indexCol.shutDown();
    }

    public int getMaxCnt() {
        return this.maxCnt;
    }

    public void setMaxCnt(int maxCnt) {
        this.maxCnt = maxCnt;
    }

    private class IndexCollectThread
    extends Thread {
        private boolean bShutDown = false;

        public void shutDown() {
            this.bShutDown = true;
        }

        @Override
        public void run() {
            HashMap counterExt = new HashMap();
            while (!this.bShutDown) {
                try {
                    Thread.sleep((long)MonitorIndex.this.intervalSec * 1000L);
                    for (String string : MonitorIndex.this.counterMap.keySet()) {
                        MonitorIndex.this.counterMap.computeIfPresent(string, (s2, s22) -> {
                            counterExt.put(s2, s22);
                            return null;
                        });
                    }
                    for (Map.Entry entry : counterExt.entrySet()) {
                        logger.info("{}#{}#{}", MonitorIndex.this.name, entry.getKey(), entry.getValue());
                    }
                    counterExt.clear();
                }
                catch (Exception e) {
                    logger.warn("monitor interrupted");
                }
            }
        }
    }
}

