/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.serialization;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.serialization.EventSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderAndBodyTextEventSerializer
implements EventSerializer {
    private static final Logger logger = LoggerFactory.getLogger(HeaderAndBodyTextEventSerializer.class);
    private final String APPEND_NEWLINE = "appendNewline";
    private final boolean APPEND_NEWLINE_DFLT = true;
    private final OutputStream out;
    private final boolean appendNewline;

    private HeaderAndBodyTextEventSerializer(OutputStream out, Context ctx) {
        this.appendNewline = ctx.getBoolean("appendNewline", true);
        this.out = out;
    }

    @Override
    public boolean supportsReopen() {
        return true;
    }

    @Override
    public void afterCreate() {
    }

    @Override
    public void afterReopen() {
    }

    @Override
    public void beforeClose() {
    }

    @Override
    public void write(Event e) throws IOException {
        this.out.write((e.getHeaders() + " ").getBytes());
        this.out.write(e.getBody());
        if (this.appendNewline) {
            this.out.write(10);
        }
    }

    @Override
    public void flush() throws IOException {
    }

    public static class Builder
    implements EventSerializer.Builder {
        @Override
        public EventSerializer build(Context context, OutputStream out) {
            HeaderAndBodyTextEventSerializer s2 = new HeaderAndBodyTextEventSerializer(out, context);
            return s2;
        }
    }
}

