/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.interceptor;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.nio.charset.Charset;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.interceptor.Interceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchAndReplaceInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(SearchAndReplaceInterceptor.class);
    private final Pattern searchPattern;
    private final String replaceString;
    private final Charset charset;

    private SearchAndReplaceInterceptor(Pattern searchPattern, String replaceString, Charset charset) {
        this.searchPattern = searchPattern;
        this.replaceString = replaceString;
        this.charset = charset;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void close() {
    }

    @Override
    public Event intercept(Event event) {
        String origBody = new String(event.getBody(), this.charset);
        Matcher matcher = this.searchPattern.matcher(origBody);
        String newBody = matcher.replaceAll(this.replaceString);
        event.setBody(newBody.getBytes(this.charset));
        return event;
    }

    @Override
    public List<Event> intercept(List<Event> events) {
        for (Event event : events) {
            this.intercept(event);
        }
        return events;
    }

    public static class Builder
    implements Interceptor.Builder {
        private static final String SEARCH_PAT_KEY = "searchPattern";
        private static final String REPLACE_STRING_KEY = "replaceString";
        private static final String CHARSET_KEY = "charset";
        private Pattern searchRegex;
        private String replaceString;
        private Charset charset = Charsets.UTF_8;

        @Override
        public void configure(Context context) {
            String searchPattern = context.getString(SEARCH_PAT_KEY);
            Preconditions.checkArgument(!StringUtils.isEmpty(searchPattern), "Must supply a valid search pattern searchPattern (may not be empty)");
            this.replaceString = context.getString(REPLACE_STRING_KEY);
            if (this.replaceString == null) {
                this.replaceString = "";
            }
            this.searchRegex = Pattern.compile(searchPattern);
            if (context.containsKey(CHARSET_KEY)) {
                this.charset = Charset.forName(context.getString(CHARSET_KEY));
            }
        }

        @Override
        public Interceptor build() {
            Preconditions.checkNotNull(this.searchRegex, "Regular expression search pattern required");
            Preconditions.checkNotNull(this.replaceString, "Replacement string required");
            return new SearchAndReplaceInterceptor(this.searchRegex, this.replaceString, this.charset);
        }
    }
}

