/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.file.encryption;

import com.google.common.base.Preconditions;
import java.security.Key;

public abstract class CipherProvider {
    public abstract Encryptor.Builder<?> newEncryptorBuilder();

    public abstract Decryptor.Builder<?> newDecryptorBuilder();

    public static abstract class Decryptor {
        public abstract byte[] decrypt(byte[] var1);

        public abstract String getCodec();

        public static abstract class Builder<T extends Decryptor> {
            protected byte[] parameters;
            protected Key key;

            public Builder<T> setKey(Key key) {
                this.key = Preconditions.checkNotNull(key, "key cannot be null");
                return this;
            }

            public Builder<T> setParameters(byte[] parameters) {
                this.parameters = parameters;
                return this;
            }

            public abstract T build();
        }
    }

    public static abstract class Encryptor {
        public abstract byte[] encrypt(byte[] var1);

        public abstract byte[] getParameters();

        public abstract String getCodec();

        public static abstract class Builder<T extends Encryptor> {
            protected Key key;

            public Builder<T> setKey(Key key) {
                this.key = Preconditions.checkNotNull(key, "key cannot be null");
                return this;
            }

            public abstract T build();
        }
    }
}

