/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.file;

import com.google.common.base.Preconditions;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.Key;
import javax.annotation.Nullable;
import org.apache.flume.channel.file.LogFile;
import org.apache.flume.channel.file.LogFileV2;
import org.apache.flume.channel.file.LogFileV3;
import org.apache.flume.channel.file.Serialization;
import org.apache.flume.channel.file.encryption.KeyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LogFileFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogFileFactory.class);

    private LogFileFactory() {
    }

    static LogFile.MetaDataWriter getMetaDataWriter(File file, int logFileID) throws IOException {
        RandomAccessFile logFile = null;
        try {
            File metaDataFile = Serialization.getMetaDataFile(file);
            if (metaDataFile.exists()) {
                LogFileV3.MetaDataWriter metaDataWriter = new LogFileV3.MetaDataWriter(file, logFileID);
                return metaDataWriter;
            }
            logFile = new RandomAccessFile(file, "r");
            int version = logFile.readInt();
            if (2 == version) {
                LogFileV2.MetaDataWriter metaDataWriter = new LogFileV2.MetaDataWriter(file, logFileID);
                return metaDataWriter;
            }
            throw new IOException("File " + file + " has bad version " + Integer.toHexString(version));
        }
        finally {
            if (logFile != null) {
                try {
                    logFile.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Unable to close " + file, e);
                }
            }
        }
    }

    static LogFile.Writer getWriter(File file, int logFileID, long maxFileSize, @Nullable Key encryptionKey, @Nullable String encryptionKeyAlias, @Nullable String encryptionCipherProvider, long usableSpaceRefreshInterval, boolean fsyncPerTransaction, int fsyncInterval) throws IOException {
        Preconditions.checkState(!file.exists(), "File already exists " + file.getAbsolutePath());
        Preconditions.checkState(file.createNewFile(), "File could not be created " + file.getAbsolutePath());
        return new LogFileV3.Writer(file, logFileID, maxFileSize, encryptionKey, encryptionKeyAlias, encryptionCipherProvider, usableSpaceRefreshInterval, fsyncPerTransaction, fsyncInterval);
    }

    static LogFile.RandomReader getRandomReader(File file, @Nullable KeyProvider encryptionKeyProvider, boolean fsyncPerTransaction) throws IOException {
        RandomAccessFile logFile = new RandomAccessFile(file, "r");
        try {
            File metaDataFile = Serialization.getMetaDataFile(file);
            if (logFile.length() == 0L || metaDataFile.exists()) {
                LogFileV3.RandomReader randomReader = new LogFileV3.RandomReader(file, encryptionKeyProvider, fsyncPerTransaction);
                return randomReader;
            }
            int version = logFile.readInt();
            if (2 == version) {
                LogFileV2.RandomReader randomReader = new LogFileV2.RandomReader(file);
                return randomReader;
            }
            throw new IOException("File " + file + " has bad version " + Integer.toHexString(version));
        }
        finally {
            if (logFile != null) {
                try {
                    logFile.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Unable to close " + file, e);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static LogFile.SequentialReader getSequentialReader(File file, @Nullable KeyProvider encryptionKeyProvider, boolean fsyncPerTransaction) throws IOException {
        RandomAccessFile logFile = null;
        try {
            File metaDataFile = Serialization.getMetaDataFile(file);
            File oldMetadataFile = Serialization.getOldMetaDataFile(file);
            File tempMetadataFile = Serialization.getMetaDataTempFile(file);
            boolean hasMeta = false;
            if (metaDataFile.exists()) {
                hasMeta = true;
            } else if (tempMetadataFile.exists()) {
                if (!tempMetadataFile.renameTo(metaDataFile)) throw new IOException("Renaming of " + tempMetadataFile.getName() + " to " + metaDataFile.getName() + " failed");
                hasMeta = true;
            } else if (oldMetadataFile.exists()) {
                if (!oldMetadataFile.renameTo(metaDataFile)) throw new IOException("Renaming of " + oldMetadataFile.getName() + " to " + metaDataFile.getName() + " failed");
                hasMeta = true;
            }
            if (hasMeta) {
                if (oldMetadataFile.exists()) {
                    oldMetadataFile.delete();
                }
                if (tempMetadataFile.exists()) {
                    tempMetadataFile.delete();
                }
                if (metaDataFile.length() == 0L) {
                    if (file.length() == 0L) throw new EOFException(String.format("MetaData file %s is empty", metaDataFile));
                    String msg = String.format("MetaData file %s is empty, but log %s is of size %d", metaDataFile, file, file.length());
                    throw new IllegalStateException(msg);
                }
                LogFileV3.SequentialReader msg = new LogFileV3.SequentialReader(file, encryptionKeyProvider, fsyncPerTransaction);
                return msg;
            }
            logFile = new RandomAccessFile(file, "r");
            int version = logFile.readInt();
            if (2 != version) throw new IOException("File " + file + " has bad version " + Integer.toHexString(version));
            LogFileV2.SequentialReader sequentialReader = new LogFileV2.SequentialReader(file);
            return sequentialReader;
        }
        finally {
            if (logFile != null) {
                try {
                    logFile.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Unable to close " + file, e);
                }
            }
        }
    }
}

