/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.mysql.table;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.sort.cdc.mysql.table.StartupMode;

public final class StartupOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final StartupMode startupMode;
    public final String specificOffsetFile;
    public final Integer specificOffsetPos;
    public final Long startupTimestampMillis;

    public static StartupOptions initial() {
        return new StartupOptions(StartupMode.INITIAL, null, null, null);
    }

    public static StartupOptions earliest() {
        return new StartupOptions(StartupMode.EARLIEST_OFFSET, null, null, null);
    }

    public static StartupOptions latest() {
        return new StartupOptions(StartupMode.LATEST_OFFSET, null, null, null);
    }

    public static StartupOptions specificOffset(String specificOffsetFile, int specificOffsetPos) {
        return new StartupOptions(StartupMode.SPECIFIC_OFFSETS, specificOffsetFile, specificOffsetPos, null);
    }

    public static StartupOptions timestamp(long startupTimestampMillis) {
        return new StartupOptions(StartupMode.TIMESTAMP, null, null, startupTimestampMillis);
    }

    private StartupOptions(StartupMode startupMode, String specificOffsetFile, Integer specificOffsetPos, Long startupTimestampMillis) {
        this.startupMode = startupMode;
        this.specificOffsetFile = specificOffsetFile;
        this.specificOffsetPos = specificOffsetPos;
        this.startupTimestampMillis = startupTimestampMillis;
        switch (startupMode) {
            case INITIAL: 
            case EARLIEST_OFFSET: 
            case LATEST_OFFSET: {
                break;
            }
            case SPECIFIC_OFFSETS: {
                Preconditions.checkNotNull((Object)specificOffsetFile, (String)"specificOffsetFile shouldn't be null");
                Preconditions.checkNotNull((Object)specificOffsetPos, (String)"specificOffsetPos shouldn't be null");
                break;
            }
            case TIMESTAMP: {
                Preconditions.checkNotNull((Object)startupTimestampMillis, (String)"startupTimestampMillis shouldn't be null");
                break;
            }
            default: {
                throw new UnsupportedOperationException((Object)((Object)startupMode) + " mode is not supported.");
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StartupOptions that = (StartupOptions)o;
        return this.startupMode == that.startupMode && Objects.equals(this.specificOffsetFile, that.specificOffsetFile) && Objects.equals(this.specificOffsetPos, that.specificOffsetPos) && Objects.equals(this.startupTimestampMillis, that.startupTimestampMillis);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.startupMode, this.specificOffsetFile, this.specificOffsetPos, this.startupTimestampMillis});
    }
}

