/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.mysql.table;

import java.util.Map;
import java.util.Properties;

public class JdbcUrlUtils {
    public static final String PROPERTIES_PREFIX = "jdbc.properties.";

    public static Properties getJdbcProperties(Map<String, String> tableOptions) {
        Properties jdbcProperties = new Properties();
        if (JdbcUrlUtils.hasJdbcProperties(tableOptions)) {
            tableOptions.keySet().stream().filter(key -> key.startsWith(PROPERTIES_PREFIX)).forEach(key -> {
                String value = (String)tableOptions.get(key);
                String subKey = key.substring(PROPERTIES_PREFIX.length());
                jdbcProperties.put(subKey, value);
            });
        }
        return jdbcProperties;
    }

    private static boolean hasJdbcProperties(Map<String, String> tableOptions) {
        return tableOptions.keySet().stream().anyMatch(k -> k.startsWith(PROPERTIES_PREFIX));
    }
}

