/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.mysql.source.split;

import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.inlong.sort.cdc.mysql.source.offset.BinlogOffset;
import org.apache.inlong.sort.cdc.mysql.source.split.FinishedSnapshotSplitInfo;
import org.apache.inlong.sort.cdc.mysql.source.split.MySqlSplit;

public class MySqlBinlogSplit
extends MySqlSplit {
    private final BinlogOffset startingOffset;
    private final BinlogOffset endingOffset;
    private final List<FinishedSnapshotSplitInfo> finishedSnapshotSplitInfos;
    private final Map<TableId, TableChanges.TableChange> tableSchemas;
    private final int totalFinishedSplitSize;
    private final boolean isSuspended;
    @Nullable
    transient byte[] serializedFormCache;

    public MySqlBinlogSplit(String splitId, BinlogOffset startingOffset, BinlogOffset endingOffset, List<FinishedSnapshotSplitInfo> finishedSnapshotSplitInfos, Map<TableId, TableChanges.TableChange> tableSchemas, int totalFinishedSplitSize, boolean isSuspended) {
        super(splitId);
        this.startingOffset = startingOffset;
        this.endingOffset = endingOffset;
        this.finishedSnapshotSplitInfos = finishedSnapshotSplitInfos;
        this.tableSchemas = tableSchemas;
        this.totalFinishedSplitSize = totalFinishedSplitSize;
        this.isSuspended = isSuspended;
    }

    public MySqlBinlogSplit(String splitId, BinlogOffset startingOffset, BinlogOffset endingOffset, List<FinishedSnapshotSplitInfo> finishedSnapshotSplitInfos, Map<TableId, TableChanges.TableChange> tableSchemas, int totalFinishedSplitSize) {
        super(splitId);
        this.startingOffset = startingOffset;
        this.endingOffset = endingOffset;
        this.finishedSnapshotSplitInfos = finishedSnapshotSplitInfos;
        this.tableSchemas = tableSchemas;
        this.totalFinishedSplitSize = totalFinishedSplitSize;
        this.isSuspended = false;
    }

    public static MySqlBinlogSplit appendFinishedSplitInfos(MySqlBinlogSplit binlogSplit, List<FinishedSnapshotSplitInfo> splitInfos) {
        splitInfos.addAll(binlogSplit.getFinishedSnapshotSplitInfos());
        return new MySqlBinlogSplit(binlogSplit.splitId, binlogSplit.getStartingOffset(), binlogSplit.getEndingOffset(), splitInfos, binlogSplit.getTableSchemas(), binlogSplit.getTotalFinishedSplitSize(), binlogSplit.isSuspended());
    }

    public static MySqlBinlogSplit fillTableSchemas(MySqlBinlogSplit binlogSplit, Map<TableId, TableChanges.TableChange> tableSchemas) {
        tableSchemas.putAll(binlogSplit.getTableSchemas());
        return new MySqlBinlogSplit(binlogSplit.splitId, binlogSplit.getStartingOffset(), binlogSplit.getEndingOffset(), binlogSplit.getFinishedSnapshotSplitInfos(), tableSchemas, binlogSplit.getTotalFinishedSplitSize(), binlogSplit.isSuspended());
    }

    public static MySqlBinlogSplit toNormalBinlogSplit(MySqlBinlogSplit suspendedBinlogSplit, int totalFinishedSplitSize) {
        return new MySqlBinlogSplit(suspendedBinlogSplit.splitId, suspendedBinlogSplit.getStartingOffset(), suspendedBinlogSplit.getEndingOffset(), suspendedBinlogSplit.getFinishedSnapshotSplitInfos(), suspendedBinlogSplit.getTableSchemas(), totalFinishedSplitSize, false);
    }

    public static MySqlBinlogSplit toSuspendedBinlogSplit(MySqlBinlogSplit normalBinlogSplit) {
        return new MySqlBinlogSplit(normalBinlogSplit.splitId, normalBinlogSplit.getStartingOffset(), normalBinlogSplit.getEndingOffset(), new ArrayList<FinishedSnapshotSplitInfo>(), new HashMap<TableId, TableChanges.TableChange>(), normalBinlogSplit.getTotalFinishedSplitSize(), true);
    }

    public BinlogOffset getStartingOffset() {
        return this.startingOffset;
    }

    public BinlogOffset getEndingOffset() {
        return this.endingOffset;
    }

    public List<FinishedSnapshotSplitInfo> getFinishedSnapshotSplitInfos() {
        return this.finishedSnapshotSplitInfos;
    }

    @Override
    public Map<TableId, TableChanges.TableChange> getTableSchemas() {
        return this.tableSchemas;
    }

    public int getTotalFinishedSplitSize() {
        return this.totalFinishedSplitSize;
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public boolean isCompletedSplit() {
        return this.totalFinishedSplitSize == this.finishedSnapshotSplitInfos.size();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MySqlBinlogSplit)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MySqlBinlogSplit that = (MySqlBinlogSplit)o;
        return this.totalFinishedSplitSize == that.totalFinishedSplitSize && this.isSuspended == that.isSuspended && Objects.equals(this.startingOffset, that.startingOffset) && Objects.equals(this.endingOffset, that.endingOffset) && Objects.equals(this.finishedSnapshotSplitInfos, that.finishedSnapshotSplitInfos) && Objects.equals(this.tableSchemas, that.tableSchemas);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.startingOffset, this.endingOffset, this.finishedSnapshotSplitInfos, this.tableSchemas, this.totalFinishedSplitSize, this.isSuspended);
    }

    public String toString() {
        return "MySqlBinlogSplit{splitId='" + this.splitId + '\'' + ", offset=" + this.startingOffset + ", endOffset=" + this.endingOffset + ", isSuspended=" + this.isSuspended + '}';
    }
}

