/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.mysql.source.metrics;

import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MeterView;
import org.apache.flink.metrics.MetricGroup;
import org.apache.inlong.audit.AuditImp;
import org.apache.inlong.sort.cdc.mysql.shaded.org.apache.inlong.sort.base.Constants;

public class MySqlSourceReaderMetrics {
    private final MetricGroup metricGroup;
    private volatile long processTime = 0L;
    private volatile long fetchDelay = 0L;
    private volatile long emitDelay = 0L;
    private Counter numRecordsIn;
    private Counter numBytesIn;
    private Meter numRecordsInPerSecond;
    private Meter numBytesInPerSecond;
    private static Integer TIME_SPAN_IN_SECONDS = 60;
    private static String STREAM_ID = "streamId";
    private static String GROUP_ID = "groupId";
    private static String NODE_ID = "nodeId";
    private String inlongGroupId;
    private String inlongSteamId;
    private String nodeId;
    private AuditImp auditImp;

    public MySqlSourceReaderMetrics(MetricGroup metricGroup) {
        this.metricGroup = metricGroup;
    }

    public void registerMetrics() {
        this.metricGroup.gauge("currentFetchEventTimeLag", this::getFetchDelay);
        this.metricGroup.gauge("currentEmitEventTimeLag", this::getEmitDelay);
        this.metricGroup.gauge("sourceIdleTime", this::getIdleTime);
    }

    public void registerMetricsForNumRecordsIn(String metricName) {
        this.numRecordsIn = this.metricGroup.addGroup(GROUP_ID, this.inlongGroupId).addGroup(STREAM_ID, this.inlongSteamId).addGroup(NODE_ID, this.nodeId).counter(metricName);
    }

    public void registerMetricsForNumBytesIn(String metricName) {
        this.numBytesIn = this.metricGroup.addGroup(GROUP_ID, this.inlongGroupId).addGroup(STREAM_ID, this.inlongSteamId).addGroup(NODE_ID, this.nodeId).counter(metricName);
    }

    public void registerMetricsForNumRecordsInPerSecond(String metricName) {
        this.numRecordsInPerSecond = this.metricGroup.addGroup(GROUP_ID, this.inlongGroupId).addGroup(STREAM_ID, this.inlongSteamId).addGroup(NODE_ID, this.nodeId).meter(metricName, (Meter)new MeterView(this.numRecordsIn, TIME_SPAN_IN_SECONDS.intValue()));
    }

    public void registerMetricsForNumBytesInPerSecond(String metricName) {
        this.numBytesInPerSecond = this.metricGroup.addGroup(GROUP_ID, this.inlongGroupId).addGroup(STREAM_ID, this.inlongSteamId).addGroup(NODE_ID, this.nodeId).meter(metricName, (Meter)new MeterView(this.numBytesIn, TIME_SPAN_IN_SECONDS.intValue()));
    }

    public long getFetchDelay() {
        return this.fetchDelay;
    }

    public long getEmitDelay() {
        return this.emitDelay;
    }

    public long getIdleTime() {
        if (this.processTime == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.processTime;
    }

    public void recordProcessTime(long processTime) {
        this.processTime = processTime;
    }

    public void recordFetchDelay(long fetchDelay) {
        this.fetchDelay = fetchDelay;
    }

    public void recordEmitDelay(long emitDelay) {
        this.emitDelay = emitDelay;
    }

    public Counter getNumRecordsIn() {
        return this.numRecordsIn;
    }

    public Counter getNumBytesIn() {
        return this.numBytesIn;
    }

    public Meter getNumRecordsInPerSecond() {
        return this.numRecordsInPerSecond;
    }

    public Meter getNumBytesInPerSecond() {
        return this.numBytesInPerSecond;
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getInlongSteamId() {
        return this.inlongSteamId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setInlongSteamId(String inlongSteamId) {
        this.inlongSteamId = inlongSteamId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public AuditImp getAuditImp() {
        return this.auditImp;
    }

    public void setAuditImp(AuditImp auditImp) {
        this.auditImp = auditImp;
    }

    public void outputMetrics(long rowCountSize, long rowDataSize) {
        this.outputMetricForFlink(rowCountSize, rowDataSize);
        this.outputMetricForAudit(rowCountSize, rowDataSize);
    }

    public void outputMetricForAudit(long rowCountSize, long rowDataSize) {
        if (this.auditImp != null) {
            this.auditImp.add(Constants.AUDIT_SORT_INPUT, this.getInlongGroupId(), this.getInlongSteamId(), System.currentTimeMillis(), rowCountSize, rowDataSize);
        }
    }

    public void outputMetricForFlink(long rowCountSize, long rowDataSize) {
        if (this.numBytesIn != null) {
            this.numBytesIn.inc(rowDataSize);
        }
        if (this.numRecordsIn != null) {
            this.numRecordsIn.inc(rowCountSize);
        }
    }
}

