/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.mysql.source.enumerator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.SourceEvent;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.shaded.guava18.com.google.common.collect.Lists;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.inlong.sort.cdc.mysql.source.assigners.AssignerStatus;
import org.apache.inlong.sort.cdc.mysql.source.assigners.MySqlHybridSplitAssigner;
import org.apache.inlong.sort.cdc.mysql.source.assigners.MySqlSplitAssigner;
import org.apache.inlong.sort.cdc.mysql.source.assigners.state.PendingSplitsState;
import org.apache.inlong.sort.cdc.mysql.source.config.MySqlSourceConfig;
import org.apache.inlong.sort.cdc.mysql.source.events.BinlogSplitMetaEvent;
import org.apache.inlong.sort.cdc.mysql.source.events.BinlogSplitMetaRequestEvent;
import org.apache.inlong.sort.cdc.mysql.source.events.FinishedSnapshotSplitsAckEvent;
import org.apache.inlong.sort.cdc.mysql.source.events.FinishedSnapshotSplitsReportEvent;
import org.apache.inlong.sort.cdc.mysql.source.events.FinishedSnapshotSplitsRequestEvent;
import org.apache.inlong.sort.cdc.mysql.source.events.LatestFinishedSplitsSizeEvent;
import org.apache.inlong.sort.cdc.mysql.source.events.LatestFinishedSplitsSizeRequestEvent;
import org.apache.inlong.sort.cdc.mysql.source.events.SuspendBinlogReaderAckEvent;
import org.apache.inlong.sort.cdc.mysql.source.events.SuspendBinlogReaderEvent;
import org.apache.inlong.sort.cdc.mysql.source.events.WakeupReaderEvent;
import org.apache.inlong.sort.cdc.mysql.source.offset.BinlogOffset;
import org.apache.inlong.sort.cdc.mysql.source.split.FinishedSnapshotSplitInfo;
import org.apache.inlong.sort.cdc.mysql.source.split.MySqlSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class MySqlSourceEnumerator
implements SplitEnumerator<MySqlSplit, PendingSplitsState> {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlSourceEnumerator.class);
    private static final long CHECK_EVENT_INTERVAL = 30000L;
    private final SplitEnumeratorContext<MySqlSplit> context;
    private final MySqlSourceConfig sourceConfig;
    private final MySqlSplitAssigner splitAssigner;
    private final TreeSet<Integer> readersAwaitingSplit;
    private List<List<FinishedSnapshotSplitInfo>> binlogSplitMeta;
    private boolean binlogReaderIsSuspended = false;

    public MySqlSourceEnumerator(SplitEnumeratorContext<MySqlSplit> context, MySqlSourceConfig sourceConfig, MySqlSplitAssigner splitAssigner) {
        this.context = context;
        this.sourceConfig = sourceConfig;
        this.splitAssigner = splitAssigner;
        this.readersAwaitingSplit = new TreeSet();
        if (AssignerStatus.isAssigning(splitAssigner.getAssignerStatus()) || AssignerStatus.isAssigningFinished(splitAssigner.getAssignerStatus())) {
            this.binlogReaderIsSuspended = true;
        }
    }

    public void start() {
        this.splitAssigner.open();
        this.suspendBinlogReaderIfNeed();
        this.wakeupBinlogReaderIfNeed();
        this.context.callAsync(this::getRegisteredReader, this::syncWithReaders, 30000L, 30000L);
    }

    public void handleSplitRequest(int subtaskId, @Nullable String requesterHostname) {
        if (!this.context.registeredReaders().containsKey(subtaskId)) {
            return;
        }
        this.readersAwaitingSplit.add(subtaskId);
        this.assignSplits();
    }

    public void addSplitsBack(List<MySqlSplit> splits, int subtaskId) {
        LOG.debug("MySQL Source Enumerator adds splits back: {}", splits);
        this.splitAssigner.addSplits(splits);
    }

    public void addReader(int subtaskId) {
        if (AssignerStatus.isSuspended(this.splitAssigner.getAssignerStatus())) {
            this.context.sendEventToSourceReader(subtaskId, (SourceEvent)new SuspendBinlogReaderEvent());
        }
    }

    public void handleSourceEvent(int subtaskId, SourceEvent sourceEvent) {
        if (sourceEvent instanceof FinishedSnapshotSplitsReportEvent) {
            LOG.info("The enumerator receives finished split offsets {} from subtask {}.", (Object)sourceEvent, (Object)subtaskId);
            FinishedSnapshotSplitsReportEvent reportEvent = (FinishedSnapshotSplitsReportEvent)sourceEvent;
            Map<String, BinlogOffset> finishedOffsets = reportEvent.getFinishedOffsets();
            this.splitAssigner.onFinishedSplits(finishedOffsets);
            this.wakeupBinlogReaderIfNeed();
            FinishedSnapshotSplitsAckEvent ackEvent = new FinishedSnapshotSplitsAckEvent(new ArrayList<String>(finishedOffsets.keySet()));
            this.context.sendEventToSourceReader(subtaskId, (SourceEvent)ackEvent);
        } else if (sourceEvent instanceof BinlogSplitMetaRequestEvent) {
            LOG.debug("The enumerator receives request for binlog split meta from subtask {}.", (Object)subtaskId);
            this.sendBinlogMeta(subtaskId, (BinlogSplitMetaRequestEvent)sourceEvent);
        } else if (sourceEvent instanceof SuspendBinlogReaderAckEvent) {
            LOG.info("The enumerator receives event that the binlog split reader has been suspended from subtask {}. ", (Object)subtaskId);
            this.handleSuspendBinlogReaderAckEvent(subtaskId);
        } else if (sourceEvent instanceof LatestFinishedSplitsSizeRequestEvent) {
            this.handleLatestFinishedSplitSizeRequest(subtaskId);
        }
    }

    public PendingSplitsState snapshotState(long checkpointId) {
        return this.splitAssigner.snapshotState(checkpointId);
    }

    public void notifyCheckpointComplete(long checkpointId) {
        this.splitAssigner.notifyCheckpointComplete(checkpointId);
        this.assignSplits();
    }

    public void close() {
        LOG.info("Closing enumerator...");
        this.splitAssigner.close();
    }

    private void assignSplits() {
        Iterator<Integer> awaitingReader = this.readersAwaitingSplit.iterator();
        while (awaitingReader.hasNext()) {
            int nextAwaiting = awaitingReader.next();
            if (!this.context.registeredReaders().containsKey(nextAwaiting)) {
                awaitingReader.remove();
                continue;
            }
            Optional<MySqlSplit> split = this.splitAssigner.getNext();
            if (split.isPresent()) {
                MySqlSplit mySqlSplit = split.get();
                this.context.assignSplit((SourceSplit)mySqlSplit, nextAwaiting);
                awaitingReader.remove();
                LOG.info("Assign split {} to subtask {}", (Object)mySqlSplit, (Object)nextAwaiting);
                continue;
            }
            this.wakeupBinlogReaderIfNeed();
            break;
        }
    }

    private int[] getRegisteredReader() {
        return this.context.registeredReaders().keySet().stream().mapToInt(Integer::intValue).toArray();
    }

    private void syncWithReaders(int[] subtaskIds, Throwable t) {
        if (t != null) {
            throw new FlinkRuntimeException("Failed to list obtain registered readers due to:", t);
        }
        if (this.splitAssigner.waitingForFinishedSplits()) {
            for (int subtaskId : subtaskIds) {
                this.context.sendEventToSourceReader(subtaskId, (SourceEvent)new FinishedSnapshotSplitsRequestEvent());
            }
        }
        this.suspendBinlogReaderIfNeed();
        this.wakeupBinlogReaderIfNeed();
    }

    private void suspendBinlogReaderIfNeed() {
        if (AssignerStatus.isSuspended(this.splitAssigner.getAssignerStatus())) {
            for (int subtaskId : this.getRegisteredReader()) {
                this.context.sendEventToSourceReader(subtaskId, (SourceEvent)new SuspendBinlogReaderEvent());
            }
            this.binlogReaderIsSuspended = true;
        }
    }

    private void wakeupBinlogReaderIfNeed() {
        if (AssignerStatus.isAssigningFinished(this.splitAssigner.getAssignerStatus()) && this.binlogReaderIsSuspended) {
            for (int subtaskId : this.getRegisteredReader()) {
                this.context.sendEventToSourceReader(subtaskId, (SourceEvent)new WakeupReaderEvent(WakeupReaderEvent.WakeUpTarget.BINLOG_READER));
            }
            this.binlogReaderIsSuspended = false;
        }
    }

    private void sendBinlogMeta(int subTask, BinlogSplitMetaRequestEvent requestEvent) {
        if (this.binlogSplitMeta == null) {
            List<FinishedSnapshotSplitInfo> finishedSnapshotSplitInfos = this.splitAssigner.getFinishedSplitInfos();
            if (finishedSnapshotSplitInfos.isEmpty()) {
                LOG.error("The assigner offer empty finished split information, this should not happen");
                throw new FlinkRuntimeException("The assigner offer empty finished split information, this should not happen");
            }
            this.binlogSplitMeta = Lists.partition(finishedSnapshotSplitInfos, this.sourceConfig.getSplitMetaGroupSize());
        }
        int requestMetaGroupId = requestEvent.getRequestMetaGroupId();
        if (this.binlogSplitMeta.size() > requestMetaGroupId) {
            List<FinishedSnapshotSplitInfo> metaToSend = this.binlogSplitMeta.get(requestMetaGroupId);
            BinlogSplitMetaEvent metadataEvent = new BinlogSplitMetaEvent(requestEvent.getSplitId(), requestMetaGroupId, metaToSend.stream().map(FinishedSnapshotSplitInfo::serialize).collect(Collectors.toList()));
            this.context.sendEventToSourceReader(subTask, (SourceEvent)metadataEvent);
        } else {
            LOG.error("Received invalid request meta group id {}, the invalid meta group id range is [0, {}]", (Object)requestMetaGroupId, (Object)(this.binlogSplitMeta.size() - 1));
        }
    }

    private void handleSuspendBinlogReaderAckEvent(int subTask) {
        LOG.info("Received event that the binlog split reader has been suspended from subtask {}. ", (Object)subTask);
        this.splitAssigner.wakeup();
        if (this.splitAssigner instanceof MySqlHybridSplitAssigner) {
            for (int subtaskId : this.getRegisteredReader()) {
                this.context.sendEventToSourceReader(subtaskId, (SourceEvent)new WakeupReaderEvent(WakeupReaderEvent.WakeUpTarget.SNAPSHOT_READER));
            }
        }
    }

    private void handleLatestFinishedSplitSizeRequest(int subTask) {
        if (this.splitAssigner instanceof MySqlHybridSplitAssigner) {
            this.context.sendEventToSourceReader(subTask, (SourceEvent)new LatestFinishedSplitsSizeEvent(this.splitAssigner.getFinishedSplitInfos().size()));
        }
    }
}

