/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.mysql.source.config;

import java.time.Duration;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;

public class MySqlSourceOptions {
    public static final ConfigOption<String> HOSTNAME = ConfigOptions.key((String)"hostname").stringType().noDefaultValue().withDescription("IP address or hostname of the MySQL database server.");
    public static final ConfigOption<Integer> PORT = ConfigOptions.key((String)"port").intType().defaultValue((Object)3306).withDescription("Integer port number of the MySQL database server.");
    public static final ConfigOption<String> USERNAME = ConfigOptions.key((String)"username").stringType().noDefaultValue().withDescription("Name of the MySQL database to use when connecting to the MySQL database server.");
    public static final ConfigOption<String> PASSWORD = ConfigOptions.key((String)"password").stringType().noDefaultValue().withDescription("Password to use when connecting to the MySQL database server.");
    public static final ConfigOption<String> DATABASE_NAME = ConfigOptions.key((String)"database-name").stringType().noDefaultValue().withDescription("Database name of the MySQL server to monitor.");
    public static final ConfigOption<String> TABLE_NAME = ConfigOptions.key((String)"table-name").stringType().noDefaultValue().withDescription("Table name of the MySQL database to monitor.");
    public static final ConfigOption<String> SERVER_TIME_ZONE = ConfigOptions.key((String)"server-time-zone").stringType().defaultValue((Object)"UTC").withDescription("The session time zone in database server.");
    public static final ConfigOption<String> SERVER_ID = ConfigOptions.key((String)"server-id").stringType().noDefaultValue().withDescription("A numeric ID or a numeric ID range of this database client, The numeric ID syntax is like '5400', the numeric ID range syntax is like '5400-5408', The numeric ID range syntax is recommended when 'scan.incremental.snapshot.enabled' enabled. Every ID must be unique across all currently-running database processes in the MySQL cluster. This connector joins the MySQL  cluster as another server (with this unique ID) so it can read the binlog. By default, a random number is generated between 5400 and 6400, though we recommend setting an explicit value.");
    public static final ConfigOption<Boolean> SCAN_INCREMENTAL_SNAPSHOT_ENABLED = ConfigOptions.key((String)"scan.incremental.snapshot.enabled").booleanType().defaultValue((Object)true).withDescription("Incremental snapshot is a new mechanism to read snapshot of a table. Compared to the old snapshot mechanism, the incremental snapshot has many advantages, including:\n(1) source can be parallel during snapshot reading, \n(2) source can perform checkpoints in the chunk granularity during snapshot reading, \n(3) source doesn't need to acquire global read lock (FLUSH TABLES WITH READ LOCK) before snapshot reading.\nIf you would like the source run in parallel, each parallel reader should have an unique server id, so the 'server-id' must be a range like '5400-6400', and the range must be larger than the parallelism.");
    public static final ConfigOption<Integer> SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE = ConfigOptions.key((String)"scan.incremental.snapshot.chunk.size").intType().defaultValue((Object)8096).withDescription("The chunk size (number of rows) of table snapshot, captured tables are split into multiple chunks when read the snapshot of table.");
    public static final ConfigOption<Integer> SCAN_SNAPSHOT_FETCH_SIZE = ConfigOptions.key((String)"scan.snapshot.fetch.size").intType().defaultValue((Object)1024).withDescription("The maximum fetch size for per poll when read table snapshot.");
    public static final ConfigOption<Duration> CONNECT_TIMEOUT = ConfigOptions.key((String)"connect.timeout").durationType().defaultValue((Object)Duration.ofSeconds(30L)).withDescription("The maximum time that the connector should wait after trying to connect to the MySQL database server before timing out.");
    public static final ConfigOption<Integer> CONNECTION_POOL_SIZE = ConfigOptions.key((String)"connection.pool.size").intType().defaultValue((Object)20).withDescription("The connection pool size.");
    public static final ConfigOption<Integer> CONNECT_MAX_RETRIES = ConfigOptions.key((String)"connect.max-retries").intType().defaultValue((Object)3).withDescription("The max retry times that the connector should retry to build MySQL database server connection.");
    public static final ConfigOption<String> SCAN_STARTUP_MODE = ConfigOptions.key((String)"scan.startup.mode").stringType().defaultValue((Object)"initial").withDescription("Optional startup mode for MySQL CDC consumer, valid enumerations are \"initial\", \"earliest-offset\", \"latest-offset\", \"timestamp\"\nor \"specific-offset\"");
    public static final ConfigOption<String> SCAN_STARTUP_SPECIFIC_OFFSET_FILE = ConfigOptions.key((String)"scan.startup.specific-offset.file").stringType().noDefaultValue().withDescription("Optional offsets used in case of \"specific-offset\" startup mode");
    public static final ConfigOption<Integer> SCAN_STARTUP_SPECIFIC_OFFSET_POS = ConfigOptions.key((String)"scan.startup.specific-offset.pos").intType().noDefaultValue().withDescription("Optional offsets used in case of \"specific-offset\" startup mode");
    public static final ConfigOption<Long> SCAN_STARTUP_TIMESTAMP_MILLIS = ConfigOptions.key((String)"scan.startup.timestamp-millis").longType().noDefaultValue().withDescription("Optional timestamp used in case of \"timestamp\" startup mode");
    public static final ConfigOption<Duration> HEARTBEAT_INTERVAL = ConfigOptions.key((String)"heartbeat.interval").durationType().defaultValue((Object)Duration.ofSeconds(30L)).withDescription("Optional interval of sending heartbeat event for tracing the latest available binlog offsets");
    public static final ConfigOption<Boolean> APPEND_MODE = ConfigOptions.key((String)"append-mode").booleanType().defaultValue((Object)false).withDescription("Whether works as append source.");
    public static final ConfigOption<Boolean> MIGRATE_ALL = ConfigOptions.key((String)"migrate-all").booleanType().defaultValue((Object)false).withDescription("Whether migrate all databases");
    @Experimental
    public static final ConfigOption<Integer> CHUNK_META_GROUP_SIZE = ConfigOptions.key((String)"chunk-meta.group.size").intType().defaultValue((Object)1000).withDescription("The group size of chunk meta, if the meta size exceeds the group size, the meta will be will be divided into multiple groups.");
    @Experimental
    public static final ConfigOption<Double> SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND = ConfigOptions.key((String)"split-key.even-distribution.factor.upper-bound").doubleType().defaultValue((Object)1000.0).withDescription("The upper bound of split key distribution factor. The distribution factor is used to determine whether the table is evenly distribution or not. The table chunks would use evenly calculation optimization when the data distribution is even, and the query MySQL for splitting would happen when it is uneven. The distribution factor could be calculated by (MAX(id) - MIN(id) + 1) / rowCount.");
    @Experimental
    public static final ConfigOption<Double> SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND = ConfigOptions.key((String)"split-key.even-distribution.factor.lower-bound").doubleType().defaultValue((Object)0.05).withDescription("The lower bound of split key distribution factor. The distribution factor is used to determine whether the table is evenly distribution or not. The table chunks would use evenly calculation optimization when the data distribution is even, and the query MySQL for splitting would happen when it is uneven. The distribution factor could be calculated by (MAX(id) - MIN(id) + 1) / rowCount.");
    @Experimental
    public static final ConfigOption<Boolean> SCAN_NEWLY_ADDED_TABLE_ENABLED = ConfigOptions.key((String)"scan.newly-added-table.enabled").booleanType().defaultValue((Object)false).withDescription("Whether capture the scan the newly added tables or not, by default is false.");
}

