/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.mysql.source.config;

import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.sort.cdc.mysql.debezium.EmbeddedFlinkDatabaseHistory;
import org.apache.inlong.sort.cdc.mysql.source.config.MySqlSourceConfig;
import org.apache.inlong.sort.cdc.mysql.source.config.MySqlSourceOptions;
import org.apache.inlong.sort.cdc.mysql.source.config.ServerIdRange;
import org.apache.inlong.sort.cdc.mysql.table.StartupOptions;

@Internal
public class MySqlSourceConfigFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int port = 3306;
    private String hostname;
    private String username;
    private String password;
    private ServerIdRange serverIdRange;
    private List<String> databaseList;
    private List<String> tableList;
    private String serverTimeZone = (String)MySqlSourceOptions.SERVER_TIME_ZONE.defaultValue();
    private StartupOptions startupOptions = StartupOptions.initial();
    private int splitSize = (Integer)MySqlSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE.defaultValue();
    private int splitMetaGroupSize = (Integer)MySqlSourceOptions.CHUNK_META_GROUP_SIZE.defaultValue();
    private int fetchSize = (Integer)MySqlSourceOptions.SCAN_SNAPSHOT_FETCH_SIZE.defaultValue();
    private Duration connectTimeout = (Duration)MySqlSourceOptions.CONNECT_TIMEOUT.defaultValue();
    private int connectMaxRetries = (Integer)MySqlSourceOptions.CONNECT_MAX_RETRIES.defaultValue();
    private int connectionPoolSize = (Integer)MySqlSourceOptions.CONNECTION_POOL_SIZE.defaultValue();
    private double distributionFactorUpper = (Double)MySqlSourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND.defaultValue();
    private double distributionFactorLower = (Double)MySqlSourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND.defaultValue();
    private boolean includeSchemaChanges = false;
    private boolean scanNewlyAddedTableEnabled = false;
    private Properties jdbcProperties;
    private Duration heartbeatInterval = (Duration)MySqlSourceOptions.HEARTBEAT_INTERVAL.defaultValue();
    private Properties dbzProperties;
    private String inlongMetric;
    private String inlongAudit;

    public MySqlSourceConfigFactory inlongMetric(String inlongMetric) {
        this.inlongMetric = inlongMetric;
        return this;
    }

    public MySqlSourceConfigFactory inlongAudit(String inlongAudit) {
        this.inlongAudit = inlongAudit;
        return this;
    }

    public MySqlSourceConfigFactory hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public MySqlSourceConfigFactory port(int port) {
        this.port = port;
        return this;
    }

    public MySqlSourceConfigFactory databaseList(String ... databaseList) {
        this.databaseList = Arrays.asList(databaseList);
        return this;
    }

    public MySqlSourceConfigFactory tableList(String ... tableList) {
        this.tableList = Arrays.asList(tableList);
        return this;
    }

    public MySqlSourceConfigFactory username(String username) {
        this.username = username;
        return this;
    }

    public MySqlSourceConfigFactory password(String password) {
        this.password = password;
        return this;
    }

    public MySqlSourceConfigFactory serverId(String serverId) {
        this.serverIdRange = ServerIdRange.from(serverId);
        return this;
    }

    public MySqlSourceConfigFactory serverTimeZone(String timeZone) {
        this.serverTimeZone = timeZone;
        return this;
    }

    public MySqlSourceConfigFactory splitSize(int splitSize) {
        this.splitSize = splitSize;
        return this;
    }

    public MySqlSourceConfigFactory splitMetaGroupSize(int splitMetaGroupSize) {
        this.splitMetaGroupSize = splitMetaGroupSize;
        return this;
    }

    public MySqlSourceConfigFactory distributionFactorUpper(double distributionFactorUpper) {
        this.distributionFactorUpper = distributionFactorUpper;
        return this;
    }

    public MySqlSourceConfigFactory distributionFactorLower(double distributionFactorLower) {
        this.distributionFactorLower = distributionFactorLower;
        return this;
    }

    public MySqlSourceConfigFactory fetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public MySqlSourceConfigFactory connectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public MySqlSourceConfigFactory connectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
        return this;
    }

    public MySqlSourceConfigFactory connectMaxRetries(int connectMaxRetries) {
        this.connectMaxRetries = connectMaxRetries;
        return this;
    }

    public MySqlSourceConfigFactory includeSchemaChanges(boolean includeSchemaChanges) {
        this.includeSchemaChanges = includeSchemaChanges;
        return this;
    }

    public MySqlSourceConfigFactory scanNewlyAddedTableEnabled(boolean scanNewlyAddedTableEnabled) {
        this.scanNewlyAddedTableEnabled = scanNewlyAddedTableEnabled;
        return this;
    }

    public MySqlSourceConfigFactory jdbcProperties(Properties jdbcProperties) {
        this.jdbcProperties = jdbcProperties;
        return this;
    }

    public MySqlSourceConfigFactory startupOptions(StartupOptions startupOptions) {
        switch (startupOptions.startupMode) {
            case INITIAL: 
            case LATEST_OFFSET: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported startup mode: " + (Object)((Object)startupOptions.startupMode));
            }
        }
        this.startupOptions = startupOptions;
        return this;
    }

    public MySqlSourceConfigFactory heartbeatInterval(Duration heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
        return this;
    }

    public MySqlSourceConfigFactory debeziumProperties(Properties properties) {
        this.dbzProperties = properties;
        return this;
    }

    public MySqlSourceConfig createConfig(int subtaskId) {
        Properties props = new Properties();
        props.setProperty("database.server.name", "mysql_binlog_source");
        props.setProperty("database.hostname", (String)Preconditions.checkNotNull((Object)this.hostname));
        props.setProperty("database.user", (String)Preconditions.checkNotNull((Object)this.username));
        props.setProperty("database.password", (String)Preconditions.checkNotNull((Object)this.password));
        props.setProperty("database.port", String.valueOf(this.port));
        props.setProperty("database.fetchSize", String.valueOf(this.fetchSize));
        props.setProperty("database.responseBuffering", "adaptive");
        props.setProperty("database.serverTimezone", this.serverTimeZone);
        props.setProperty("database.history", EmbeddedFlinkDatabaseHistory.class.getCanonicalName());
        props.setProperty("database.history.instance.name", UUID.randomUUID().toString() + "_" + subtaskId);
        props.setProperty("database.history.skip.unparseable.ddl", String.valueOf(true));
        props.setProperty("database.history.refer.ddl", String.valueOf(true));
        props.setProperty("connect.timeout.ms", String.valueOf(this.connectTimeout.toMillis()));
        props.setProperty("include.schema.changes", String.valueOf(true));
        props.setProperty("offset.flush.interval.ms", String.valueOf(Long.MAX_VALUE));
        props.setProperty("tombstones.on.delete", String.valueOf(false));
        props.setProperty("heartbeat.interval.ms", String.valueOf(this.heartbeatInterval.toMillis()));
        props.put("bigint.unsigned.handling.mode", "precise");
        if (this.serverIdRange != null) {
            int serverId = this.serverIdRange.getServerId(subtaskId);
            props.setProperty("database.server.id", String.valueOf(serverId));
        }
        if (this.databaseList != null) {
            props.setProperty("database.include.list", String.join((CharSequence)",", this.databaseList));
        }
        if (this.tableList != null) {
            props.setProperty("table.include.list", String.join((CharSequence)",", this.tableList));
        }
        if (this.serverTimeZone != null) {
            props.setProperty("database.serverTimezone", this.serverTimeZone);
        }
        if (this.dbzProperties != null) {
            props.putAll((Map<?, ?>)this.dbzProperties);
        }
        if (this.jdbcProperties == null) {
            this.jdbcProperties = new Properties();
        }
        return new MySqlSourceConfig(this.hostname, this.port, this.username, this.password, this.databaseList, this.tableList, this.serverIdRange, this.startupOptions, this.splitSize, this.splitMetaGroupSize, this.fetchSize, this.serverTimeZone, this.connectTimeout, this.connectMaxRetries, this.connectionPoolSize, this.distributionFactorUpper, this.distributionFactorLower, this.includeSchemaChanges, this.scanNewlyAddedTableEnabled, props, this.jdbcProperties, this.inlongMetric, this.inlongAudit);
    }
}

