/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.mysql.source.assigners;

import com.ververica.cdc.connectors.mysql.source.utils.TableDiscoveryUtils;
import io.debezium.connector.mysql.MySqlConnection;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.RelationalTableFilters;
import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.inlong.sort.cdc.mysql.debezium.DebeziumUtils;
import org.apache.inlong.sort.cdc.mysql.schema.MySqlSchema;
import org.apache.inlong.sort.cdc.mysql.source.assigners.AssignerStatus;
import org.apache.inlong.sort.cdc.mysql.source.assigners.MySqlSplitAssigner;
import org.apache.inlong.sort.cdc.mysql.source.assigners.state.BinlogPendingSplitsState;
import org.apache.inlong.sort.cdc.mysql.source.assigners.state.PendingSplitsState;
import org.apache.inlong.sort.cdc.mysql.source.config.MySqlSourceConfig;
import org.apache.inlong.sort.cdc.mysql.source.config.MySqlSourceOptions;
import org.apache.inlong.sort.cdc.mysql.source.offset.BinlogOffset;
import org.apache.inlong.sort.cdc.mysql.source.split.FinishedSnapshotSplitInfo;
import org.apache.inlong.sort.cdc.mysql.source.split.MySqlBinlogSplit;
import org.apache.inlong.sort.cdc.mysql.source.split.MySqlSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlBinlogSplitAssigner
implements MySqlSplitAssigner {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlBinlogSplitAssigner.class);
    private static final String BINLOG_SPLIT_ID = "binlog-split";
    private final MySqlSourceConfig sourceConfig;
    private final RelationalTableFilters tableFilters;
    private MySqlConnection jdbc;
    private boolean isBinlogSplitAssigned;

    public MySqlBinlogSplitAssigner(MySqlSourceConfig sourceConfig) {
        this(sourceConfig, false);
    }

    public MySqlBinlogSplitAssigner(MySqlSourceConfig sourceConfig, BinlogPendingSplitsState checkpoint) {
        this(sourceConfig, checkpoint.isBinlogSplitAssigned());
    }

    private MySqlBinlogSplitAssigner(MySqlSourceConfig sourceConfig, boolean isBinlogSplitAssigned) {
        this.sourceConfig = sourceConfig;
        this.tableFilters = DebeziumUtils.createTableFilters(sourceConfig);
        this.isBinlogSplitAssigned = isBinlogSplitAssigned;
    }

    @Override
    public void open() {
        this.jdbc = DebeziumUtils.createMySqlConnection(this.sourceConfig);
    }

    @Override
    public Optional<MySqlSplit> getNext() {
        if (this.isBinlogSplitAssigned) {
            return Optional.empty();
        }
        this.isBinlogSplitAssigned = true;
        return Optional.of(this.createBinlogSplit());
    }

    @Override
    public boolean waitingForFinishedSplits() {
        return false;
    }

    @Override
    public List<FinishedSnapshotSplitInfo> getFinishedSplitInfos() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public void onFinishedSplits(Map<String, BinlogOffset> splitFinishedOffsets) {
    }

    @Override
    public void addSplits(Collection<MySqlSplit> splits) {
        this.isBinlogSplitAssigned = false;
    }

    @Override
    public PendingSplitsState snapshotState(long checkpointId) {
        return new BinlogPendingSplitsState(this.isBinlogSplitAssigned);
    }

    @Override
    public void notifyCheckpointComplete(long checkpointId) {
    }

    @Override
    public AssignerStatus getAssignerStatus() {
        return AssignerStatus.INITIAL_ASSIGNING_FINISHED;
    }

    @Override
    public void suspend() {
    }

    @Override
    public void wakeup() {
    }

    @Override
    public void close() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MySqlBinlogSplit createBinlogSplit() {
        Map<TableId, TableChanges.TableChange> tableSchemas = this.discoverCapturedTableSchemas();
        try (JdbcConnection jdbc = DebeziumUtils.openJdbcConnection(this.sourceConfig);){
            MySqlBinlogSplit mySqlBinlogSplit = new MySqlBinlogSplit(BINLOG_SPLIT_ID, DebeziumUtils.currentBinlogOffset(jdbc), BinlogOffset.NO_STOPPING_OFFSET, new ArrayList<FinishedSnapshotSplitInfo>(), tableSchemas, 0);
            return mySqlBinlogSplit;
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Read the binlog offset error", (Throwable)e);
        }
    }

    private Map<TableId, TableChanges.TableChange> discoverCapturedTableSchemas() {
        List<TableId> capturedTableIds;
        try {
            capturedTableIds = TableDiscoveryUtils.listTables(this.jdbc, this.tableFilters);
        }
        catch (SQLException e) {
            throw new FlinkRuntimeException("Failed to discover captured tables", (Throwable)e);
        }
        if (capturedTableIds.isEmpty()) {
            throw new IllegalArgumentException(String.format("Can't find any matched tables, please check your configured database-name: %s and table-name: %s", this.sourceConfig.getDbzConfiguration().getString(MySqlSourceOptions.DATABASE_NAME.key()), this.sourceConfig.getDbzConfiguration().getString(MySqlSourceOptions.TABLE_NAME.key())));
        }
        MySqlSchema mySqlSchema = new MySqlSchema(this.sourceConfig, false);
        HashMap<TableId, TableChanges.TableChange> tableSchemas = new HashMap<TableId, TableChanges.TableChange>();
        for (TableId tableId : capturedTableIds) {
            TableChanges.TableChange tableSchema = mySqlSchema.getTableSchema(this.jdbc, tableId);
            tableSchemas.put(tableId, tableSchema);
        }
        return tableSchemas;
    }
}

