/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.mysql.debezium.dispatcher;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaBuilder;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.document.DocumentWriter;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.ChangeEventCreator;
import io.debezium.pipeline.spi.SchemaChangeEventEmitter;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.schema.DataCollectionFilters;
import io.debezium.schema.DataCollectionId;
import io.debezium.schema.DatabaseSchema;
import io.debezium.schema.HistorizedDatabaseSchema;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.schema.TopicSelector;
import io.debezium.util.SchemaNameAdjuster;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDispatcherImpl<T extends DataCollectionId>
extends EventDispatcher<T> {
    public static final String HISTORY_RECORD_FIELD = "historyRecord";
    private static final Logger LOG = LoggerFactory.getLogger(EventDispatcherImpl.class);
    private static final DocumentWriter DOCUMENT_WRITER = DocumentWriter.defaultWriter();
    private final ChangeEventQueue<DataChangeEvent> queue;
    private final HistorizedDatabaseSchema historizedSchema;
    private final DataCollectionFilters.DataCollectionFilter<T> filter;
    private final CommonConnectorConfig connectorConfig;
    private final TopicSelector<T> topicSelector;
    private final Schema schemaChangeKeySchema;
    private final Schema schemaChangeValueSchema;

    public EventDispatcherImpl(CommonConnectorConfig connectorConfig, TopicSelector<T> topicSelector, DatabaseSchema<T> schema, ChangeEventQueue<DataChangeEvent> queue, DataCollectionFilters.DataCollectionFilter<T> filter, ChangeEventCreator changeEventCreator, EventMetadataProvider metadataProvider, SchemaNameAdjuster schemaNameAdjuster) {
        super(connectorConfig, topicSelector, schema, queue, filter, changeEventCreator, metadataProvider, schemaNameAdjuster);
        this.historizedSchema = schema instanceof HistorizedDatabaseSchema ? (HistorizedDatabaseSchema)schema : null;
        this.filter = filter;
        this.queue = queue;
        this.connectorConfig = connectorConfig;
        this.topicSelector = topicSelector;
        this.schemaChangeKeySchema = SchemaBuilder.struct().name(schemaNameAdjuster.adjust("io.debezium.connector." + connectorConfig.getConnectorName() + ".SchemaChangeKey")).field("databaseName", Schema.STRING_SCHEMA).build();
        this.schemaChangeValueSchema = SchemaBuilder.struct().name(schemaNameAdjuster.adjust("io.debezium.connector." + connectorConfig.getConnectorName() + ".SchemaChangeValue")).field("source", connectorConfig.getSourceInfoStructMaker().schema()).field(HISTORY_RECORD_FIELD, Schema.OPTIONAL_STRING_SCHEMA).build();
    }

    public ChangeEventQueue<DataChangeEvent> getQueue() {
        return this.queue;
    }

    @Override
    public void dispatchSchemaChangeEvent(T dataCollectionId, SchemaChangeEventEmitter schemaChangeEventEmitter) throws InterruptedException {
        if (dataCollectionId != null && !this.filter.isIncluded(dataCollectionId) && (this.historizedSchema == null || this.historizedSchema.storeOnlyMonitoredTables())) {
            LOG.trace("Filtering schema change event for {}", dataCollectionId);
            return;
        }
        schemaChangeEventEmitter.emitSchemaChangeEvent(new SchemaChangeEventReceiver());
    }

    @Override
    public void dispatchSchemaChangeEvent(Collection<T> dataCollectionIds, SchemaChangeEventEmitter schemaChangeEventEmitter) throws InterruptedException {
        boolean anyNonfilteredEvent = false;
        if (dataCollectionIds == null || dataCollectionIds.isEmpty()) {
            anyNonfilteredEvent = true;
        } else {
            for (DataCollectionId dataCollectionId : dataCollectionIds) {
                if (!this.filter.isIncluded(dataCollectionId)) continue;
                anyNonfilteredEvent = true;
                break;
            }
        }
        if (!anyNonfilteredEvent && (this.historizedSchema == null || this.historizedSchema.storeOnlyMonitoredTables())) {
            LOG.trace("Filtering schema change event for {}", dataCollectionIds);
            return;
        }
        schemaChangeEventEmitter.emitSchemaChangeEvent(new SchemaChangeEventReceiver());
    }

    private final class SchemaChangeEventReceiver
    implements SchemaChangeEventEmitter.Receiver {
        private SchemaChangeEventReceiver() {
        }

        private Struct schemaChangeRecordKey(SchemaChangeEvent event) {
            Struct result = new Struct(EventDispatcherImpl.this.schemaChangeKeySchema);
            result.put("databaseName", (Object)event.getDatabase());
            return result;
        }

        private Struct schemaChangeRecordValue(SchemaChangeEvent event) throws IOException {
            Struct sourceInfo = event.getSource();
            HashMap<String, Object> source = new HashMap<String, Object>();
            String fileName = sourceInfo.getString("file");
            Long pos = sourceInfo.getInt64("pos");
            Long serverId = sourceInfo.getInt64("server_id");
            source.put("server_id", serverId);
            source.put("file", fileName);
            source.put("pos", pos);
            HistoryRecord historyRecord = new HistoryRecord(source, event.getOffset(), event.getDatabase(), null, event.getDdl(), event.getTableChanges());
            String historyStr = DOCUMENT_WRITER.write(historyRecord.document());
            Struct value = new Struct(EventDispatcherImpl.this.schemaChangeValueSchema);
            value.put("source", (Object)event.getSource());
            value.put(EventDispatcherImpl.HISTORY_RECORD_FIELD, (Object)historyStr);
            return value;
        }

        @Override
        public void schemaChangeEvent(SchemaChangeEvent event) throws InterruptedException {
            EventDispatcherImpl.this.historizedSchema.applySchemaChange(event);
            if (EventDispatcherImpl.this.connectorConfig.isSchemaChangesHistoryEnabled()) {
                try {
                    String topicName = EventDispatcherImpl.this.topicSelector.getPrimaryTopic();
                    Integer partition = 0;
                    Struct key = this.schemaChangeRecordKey(event);
                    Struct value = this.schemaChangeRecordValue(event);
                    SourceRecord record = new SourceRecord(event.getPartition(), event.getOffset(), topicName, partition, EventDispatcherImpl.this.schemaChangeKeySchema, (Object)key, EventDispatcherImpl.this.schemaChangeValueSchema, value);
                    EventDispatcherImpl.this.queue.enqueue(new DataChangeEvent(record));
                }
                catch (IOException e) {
                    throw new IllegalStateException(String.format("dispatch schema change event %s error ", event), e);
                }
            }
        }
    }
}

