/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.enums;

import java.util.Locale;

public enum DataTypeEnum {
    CSV("csv"),
    AVRO("avro"),
    JSON("json"),
    CANAL("canal"),
    DEBEZIUM_JSON("debezium_json"),
    RAW("raw");

    private final String name;

    private DataTypeEnum(String name) {
        this.name = name;
    }

    public static DataTypeEnum forName(String name) {
        for (DataTypeEnum dataType : DataTypeEnum.values()) {
            if (!dataType.getName().equals(name.toLowerCase(Locale.ROOT))) continue;
            return dataType;
        }
        throw new IllegalArgumentException(String.format("Unsupport dataType for Inlong:%s", name));
    }

    public String getName() {
        return this.name;
    }
}

