/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.common.BaseSourceInfo;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.document.Document;
import io.debezium.relational.TableId;
import java.time.Instant;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@NotThreadSafe
final class SourceInfo
extends BaseSourceInfo {
    public static final String SERVER_ID_KEY = "server_id";
    public static final String GTID_KEY = "gtid";
    public static final String BINLOG_FILENAME_OFFSET_KEY = "file";
    public static final String BINLOG_POSITION_OFFSET_KEY = "pos";
    public static final String BINLOG_ROW_IN_EVENT_OFFSET_KEY = "row";
    public static final String THREAD_KEY = "thread";
    public static final String QUERY_KEY = "query";
    private String currentGtid;
    private String currentBinlogFilename;
    private long currentBinlogPosition = 0L;
    private int currentRowNumber = 0;
    private long serverId = 0L;
    private Instant sourceTime = null;
    private long threadId = -1L;
    private String currentQuery = null;
    private Set<TableId> tableIds = new HashSet<TableId>();
    private String databaseName;

    public SourceInfo(MySqlConnectorConfig connectorConfig) {
        super(connectorConfig);
    }

    public void setQuery(String query) {
        this.currentQuery = query;
    }

    public String getQuery() {
        return this.currentQuery;
    }

    public void setBinlogPosition(String binlogFilename, long positionOfFirstEvent) {
        if (binlogFilename != null) {
            this.currentBinlogFilename = binlogFilename;
        }
        assert (positionOfFirstEvent >= 0L);
        this.currentBinlogPosition = positionOfFirstEvent;
        this.currentRowNumber = 0;
    }

    public void setEventPosition(long positionOfCurrentEvent) {
        this.currentBinlogPosition = positionOfCurrentEvent;
    }

    public void setRowNumber(int eventRowNumber) {
        this.currentRowNumber = eventRowNumber;
    }

    public void databaseEvent(String databaseName) {
        this.databaseName = databaseName;
    }

    public void tableEvent(Set<TableId> tableIds) {
        this.tableIds = new HashSet<TableId>(tableIds);
    }

    public void tableEvent(TableId tableId) {
        this.tableIds = Collections.singleton(tableId);
    }

    public void startGtid(String gtid) {
        this.currentGtid = gtid;
    }

    public void setBinlogServerId(long serverId) {
        this.serverId = serverId;
    }

    public void setBinlogTimestampSeconds(long timestampInSeconds) {
        this.sourceTime = Instant.ofEpochSecond(timestampInSeconds);
    }

    public void setSourceTime(Instant timestamp) {
        this.sourceTime = timestamp;
    }

    public void setBinlogThread(long threadId) {
        this.threadId = threadId;
    }

    public String binlogFilename() {
        return this.currentBinlogFilename;
    }

    public long binlogPosition() {
        return this.currentBinlogPosition;
    }

    long getServerId() {
        return this.serverId;
    }

    long getThreadId() {
        return this.threadId;
    }

    String table() {
        return this.tableIds.isEmpty() ? null : this.tableIds.stream().filter(x -> x != null).map(TableId::table).collect(Collectors.joining(","));
    }

    String getCurrentGtid() {
        return this.currentGtid;
    }

    String getCurrentBinlogFilename() {
        return this.currentBinlogFilename;
    }

    long getCurrentBinlogPosition() {
        return this.currentBinlogPosition;
    }

    long getBinlogTimestampSeconds() {
        return this.sourceTime == null ? 0L : this.sourceTime.getEpochSecond();
    }

    int getCurrentRowNumber() {
        return this.currentRowNumber;
    }

    public String toString() {
        return "SourceInfo [currentGtid=" + this.currentGtid + ", currentBinlogFilename=" + this.currentBinlogFilename + ", currentBinlogPosition=" + this.currentBinlogPosition + ", currentRowNumber=" + this.currentRowNumber + ", serverId=" + this.serverId + ", sourceTime=" + this.sourceTime + ", threadId=" + this.threadId + ", currentQuery=" + this.currentQuery + ", tableIds=" + this.tableIds + ", databaseName=" + this.databaseName + "]";
    }

    public static Document createDocumentFromOffset(Map<String, ?> offset) {
        Document offsetDocument = Document.create();
        for (Map.Entry<String, ?> entry : offset.entrySet()) {
            offsetDocument.set(entry.getKey(), entry.getValue());
        }
        return offsetDocument;
    }

    @Override
    protected Instant timestamp() {
        return this.sourceTime;
    }

    @Override
    protected String database() {
        if (this.tableIds == null || this.tableIds.isEmpty()) {
            return this.databaseName;
        }
        TableId tableId = this.tableIds.iterator().next();
        if (tableId == null) {
            return this.databaseName;
        }
        return tableId.catalog();
    }

    @Deprecated
    public boolean isLastSnapshot() {
        return this.snapshot() == SnapshotRecord.LAST;
    }
}

