/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigDef;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Utils;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.connector.ConnectRecord;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.ConnectException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.Transformation;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.predicates.Predicate;
import java.util.Map;

class PredicatedTransformation<R extends ConnectRecord<R>>
implements Transformation<R> {
    static final String PREDICATE_CONFIG = "predicate";
    static final String NEGATE_CONFIG = "negate";
    Predicate<R> predicate;
    Transformation<R> delegate;
    boolean negate;

    PredicatedTransformation(Predicate<R> predicate, boolean negate, Transformation<R> delegate) {
        this.predicate = predicate;
        this.negate = negate;
        this.delegate = delegate;
    }

    @Override
    public void configure(Map<String, ?> configs) {
        throw new ConnectException(PredicatedTransformation.class.getName() + ".configure() should never be called directly.");
    }

    @Override
    public R apply(R record) {
        if (this.negate ^ this.predicate.test(record)) {
            return this.delegate.apply(record);
        }
        return record;
    }

    @Override
    public ConfigDef config() {
        throw new ConnectException(PredicatedTransformation.class.getName() + ".config() should never be called directly.");
    }

    @Override
    public void close() {
        Utils.closeQuietly(this.delegate, "predicated");
        Utils.closeQuietly(this.predicate, PREDICATE_CONFIG);
    }

    public String toString() {
        return "PredicatedTransformation{predicate=" + this.predicate + ", delegate=" + this.delegate + ", negate=" + this.negate + '}';
    }
}

