/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigResource;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.AlterConfigsRequestData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.AlterConfigsResponseData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractRequest;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractResponse;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AlterConfigsResponse;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.ApiError;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class AlterConfigsRequest
extends AbstractRequest {
    private final AlterConfigsRequestData data;

    public AlterConfigsRequest(AlterConfigsRequestData data, short version) {
        super(ApiKeys.ALTER_CONFIGS, version);
        this.data = data;
    }

    public AlterConfigsRequest(Struct struct, short version) {
        super(ApiKeys.ALTER_CONFIGS, version);
        this.data = new AlterConfigsRequestData(struct, version);
    }

    public Map<ConfigResource, Config> configs() {
        return this.data.resources().stream().collect(Collectors.toMap(resource -> new ConfigResource(ConfigResource.Type.forId(resource.resourceType()), resource.resourceName()), resource -> new Config(resource.configs().stream().map(entry -> new ConfigEntry(entry.name(), entry.value())).collect(Collectors.toList()))));
    }

    public boolean validateOnly() {
        return this.data.validateOnly();
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ApiError error = ApiError.fromThrowable(e);
        AlterConfigsResponseData data = new AlterConfigsResponseData().setThrottleTimeMs(throttleTimeMs);
        for (AlterConfigsRequestData.AlterConfigsResource resource : this.data.resources()) {
            data.responses().add(new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceType(resource.resourceType()).setResourceName(resource.resourceName()).setErrorMessage(error.message()).setErrorCode(error.error().code()));
        }
        return new AlterConfigsResponse(data);
    }

    public static AlterConfigsRequest parse(ByteBuffer buffer, short version) {
        return new AlterConfigsRequest(ApiKeys.ALTER_CONFIGS.parseRequest(version, buffer), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<AlterConfigsRequest> {
        private final AlterConfigsRequestData data = new AlterConfigsRequestData();

        public Builder(Map<ConfigResource, Config> configs, boolean validateOnly) {
            super(ApiKeys.ALTER_CONFIGS);
            Objects.requireNonNull(configs, "configs");
            for (Map.Entry<ConfigResource, Config> entry : configs.entrySet()) {
                AlterConfigsRequestData.AlterConfigsResource resource = new AlterConfigsRequestData.AlterConfigsResource().setResourceName(entry.getKey().name()).setResourceType(entry.getKey().type().id());
                for (ConfigEntry x : entry.getValue().entries) {
                    resource.configs().add(new AlterConfigsRequestData.AlterableConfig().setName(x.name()).setValue(x.value()));
                }
                this.data.resources().add(resource);
            }
            this.data.setValidateOnly(validateOnly);
        }

        @Override
        public AlterConfigsRequest build(short version) {
            return new AlterConfigsRequest(this.data, version);
        }
    }

    public static class ConfigEntry {
        private final String name;
        private final String value;

        public ConfigEntry(String name, String value) {
            this.name = Objects.requireNonNull(name, "name");
            this.value = Objects.requireNonNull(value, "value");
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }
    }

    public static class Config {
        private final Collection<ConfigEntry> entries;

        public Config(Collection<ConfigEntry> entries) {
            this.entries = Objects.requireNonNull(entries, "entries");
        }

        public Collection<ConfigEntry> entries() {
            return this.entries;
        }
    }
}

