/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.source.split;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;

public final class MySqlRecords
implements RecordsWithSplitIds<SourceRecord> {
    @Nullable
    private String splitId;
    @Nullable
    private Iterator<SourceRecord> recordsForCurrentSplit;
    @Nullable
    private final Iterator<SourceRecord> recordsForSplit;
    private final Set<String> finishedSnapshotSplits;

    public MySqlRecords(@Nullable String splitId, @Nullable Iterator recordsForSplit, Set<String> finishedSnapshotSplits) {
        this.splitId = splitId;
        this.recordsForSplit = recordsForSplit;
        this.finishedSnapshotSplits = finishedSnapshotSplits;
    }

    @Nullable
    public String nextSplit() {
        String nextSplit = this.splitId;
        this.splitId = null;
        this.recordsForCurrentSplit = nextSplit != null ? this.recordsForSplit : null;
        return nextSplit;
    }

    @Nullable
    public SourceRecord nextRecordFromSplit() {
        Iterator<SourceRecord> recordsForSplit = this.recordsForCurrentSplit;
        if (recordsForSplit != null) {
            if (recordsForSplit.hasNext()) {
                return recordsForSplit.next();
            }
            return null;
        }
        throw new IllegalStateException();
    }

    public Set<String> finishedSplits() {
        return this.finishedSnapshotSplits;
    }

    public static MySqlRecords forRecords(String splitId, Iterator<SourceRecord> recordsForSplit) {
        return new MySqlRecords(splitId, recordsForSplit, Collections.emptySet());
    }

    public static MySqlRecords forFinishedSplit(String splitId) {
        return new MySqlRecords(null, null, Collections.singleton(splitId));
    }
}

