/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.debezium.task;

import com.ververica.cdc.connectors.mysql.debezium.DebeziumUtils;
import com.ververica.cdc.connectors.mysql.debezium.dispatcher.EventDispatcherImpl;
import com.ververica.cdc.connectors.mysql.debezium.dispatcher.SignalEventDispatcher;
import com.ververica.cdc.connectors.mysql.debezium.reader.SnapshotSplitReader;
import com.ververica.cdc.connectors.mysql.source.offset.BinlogOffset;
import com.ververica.cdc.connectors.mysql.source.split.MySqlSnapshotSplit;
import com.ververica.cdc.connectors.mysql.source.utils.StatementUtils;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.ConnectException;
import io.debezium.DebeziumException;
import io.debezium.connector.mysql.MySqlConnection;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlDatabaseSchema;
import io.debezium.connector.mysql.MySqlOffsetContext;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.AbstractSnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.SnapshotResult;
import io.debezium.relational.Column;
import io.debezium.relational.RelationalSnapshotChangeEventSource;
import io.debezium.relational.SnapshotChangeRecordEmitter;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.schema.TopicSelector;
import io.debezium.util.Clock;
import io.debezium.util.ColumnUtils;
import io.debezium.util.Strings;
import io.debezium.util.Threads;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlSnapshotSplitReadTask
extends AbstractSnapshotChangeEventSource {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlSnapshotSplitReadTask.class);
    private static final Duration LOG_INTERVAL = Duration.ofMillis(10000L);
    private final MySqlConnectorConfig connectorConfig;
    private final MySqlDatabaseSchema databaseSchema;
    private final MySqlConnection jdbcConnection;
    private final EventDispatcherImpl<TableId> dispatcher;
    private final Clock clock;
    private final MySqlSnapshotSplit snapshotSplit;
    private final MySqlOffsetContext offsetContext;
    private final TopicSelector<TableId> topicSelector;
    private final SnapshotProgressListener snapshotProgressListener;

    public MySqlSnapshotSplitReadTask(MySqlConnectorConfig connectorConfig, MySqlOffsetContext previousOffset, SnapshotProgressListener snapshotProgressListener, MySqlDatabaseSchema databaseSchema, MySqlConnection jdbcConnection, EventDispatcherImpl<TableId> dispatcher, TopicSelector<TableId> topicSelector, Clock clock, MySqlSnapshotSplit snapshotSplit) {
        super(connectorConfig, previousOffset, snapshotProgressListener);
        this.offsetContext = previousOffset;
        this.connectorConfig = connectorConfig;
        this.databaseSchema = databaseSchema;
        this.jdbcConnection = jdbcConnection;
        this.dispatcher = dispatcher;
        this.clock = clock;
        this.snapshotSplit = snapshotSplit;
        this.topicSelector = topicSelector;
        this.snapshotProgressListener = snapshotProgressListener;
    }

    @Override
    public SnapshotResult execute(ChangeEventSource.ChangeEventSourceContext context) throws InterruptedException {
        AbstractSnapshotChangeEventSource.SnapshotContext ctx;
        AbstractSnapshotChangeEventSource.SnapshottingTask snapshottingTask = this.getSnapshottingTask(this.previousOffset);
        try {
            ctx = this.prepare(context);
        }
        catch (Exception e) {
            LOG.error("Failed to initialize snapshot context.", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            return this.doExecute(context, ctx, snapshottingTask);
        }
        catch (InterruptedException e) {
            LOG.warn("Snapshot was interrupted before completion");
            throw e;
        }
        catch (Exception t) {
            throw new DebeziumException(t);
        }
    }

    @Override
    protected SnapshotResult doExecute(ChangeEventSource.ChangeEventSourceContext context, AbstractSnapshotChangeEventSource.SnapshotContext snapshotContext, AbstractSnapshotChangeEventSource.SnapshottingTask snapshottingTask) throws Exception {
        RelationalSnapshotChangeEventSource.RelationalSnapshotContext ctx = (RelationalSnapshotChangeEventSource.RelationalSnapshotContext)snapshotContext;
        ctx.offset = this.offsetContext;
        SignalEventDispatcher signalEventDispatcher = new SignalEventDispatcher(this.offsetContext.getPartition(), this.topicSelector.topicNameFor(this.snapshotSplit.getTableId()), this.dispatcher.getQueue());
        BinlogOffset lowWatermark = DebeziumUtils.currentBinlogOffset(this.jdbcConnection);
        LOG.info("Snapshot step 1 - Determining low watermark {} for split {}", (Object)lowWatermark, (Object)this.snapshotSplit);
        ((SnapshotSplitReader.SnapshotSplitChangeEventSourceContextImpl)context).setLowWatermark(lowWatermark);
        signalEventDispatcher.dispatchWatermarkEvent(this.snapshotSplit, lowWatermark, SignalEventDispatcher.WatermarkKind.LOW);
        LOG.info("Snapshot step 2 - Snapshotting data");
        this.createDataEvents(ctx, this.snapshotSplit.getTableId());
        BinlogOffset highWatermark = DebeziumUtils.currentBinlogOffset(this.jdbcConnection);
        LOG.info("Snapshot step 3 - Determining high watermark {} for split {}", (Object)highWatermark, (Object)this.snapshotSplit);
        signalEventDispatcher.dispatchWatermarkEvent(this.snapshotSplit, highWatermark, SignalEventDispatcher.WatermarkKind.HIGH);
        ((SnapshotSplitReader.SnapshotSplitChangeEventSourceContextImpl)context).setHighWatermark(highWatermark);
        return SnapshotResult.completed(ctx.offset);
    }

    @Override
    protected AbstractSnapshotChangeEventSource.SnapshottingTask getSnapshottingTask(OffsetContext previousOffset) {
        return new AbstractSnapshotChangeEventSource.SnapshottingTask(false, true);
    }

    @Override
    protected AbstractSnapshotChangeEventSource.SnapshotContext prepare(ChangeEventSource.ChangeEventSourceContext changeEventSourceContext) throws Exception {
        return new MySqlSnapshotContext();
    }

    private void createDataEvents(RelationalSnapshotChangeEventSource.RelationalSnapshotContext snapshotContext, TableId tableId) throws Exception {
        EventDispatcher.SnapshotReceiver snapshotReceiver = this.dispatcher.getSnapshotChangeEventReceiver();
        LOG.debug("Snapshotting table {}", (Object)tableId);
        this.createDataEventsForTable(snapshotContext, snapshotReceiver, this.databaseSchema.tableFor(tableId));
        snapshotReceiver.completeSnapshot();
    }

    private void createDataEventsForTable(RelationalSnapshotChangeEventSource.RelationalSnapshotContext snapshotContext, EventDispatcher.SnapshotReceiver snapshotReceiver, Table table) throws InterruptedException {
        long exportStart = this.clock.currentTimeInMillis();
        LOG.info("Exporting data from split '{}' of table {}", (Object)this.snapshotSplit.splitId(), (Object)table.id());
        String selectSql = StatementUtils.buildSplitScanQuery(this.snapshotSplit.getTableId(), this.snapshotSplit.getSplitKeyType(), this.snapshotSplit.getSplitStart() == null, this.snapshotSplit.getSplitEnd() == null);
        LOG.info("For split '{}' of table {} using select statement: '{}'", new Object[]{this.snapshotSplit.splitId(), table.id(), selectSql});
        try (PreparedStatement selectStatement = StatementUtils.readTableSplitDataStatement(this.jdbcConnection, selectSql, this.snapshotSplit.getSplitStart() == null, this.snapshotSplit.getSplitEnd() == null, this.snapshotSplit.getSplitStart(), this.snapshotSplit.getSplitEnd(), this.snapshotSplit.getSplitKeyType().getFieldCount(), this.connectorConfig.getQueryFetchSize());
             ResultSet rs = selectStatement.executeQuery();){
            ColumnUtils.ColumnArray columnArray = ColumnUtils.toArray(rs, table);
            long rows = 0L;
            Threads.Timer logTimer = this.getTableScanLogTimer();
            while (rs.next()) {
                ++rows;
                Object[] row = new Object[columnArray.getGreatestColumnPosition()];
                for (int i = 0; i < columnArray.getColumns().length; ++i) {
                    Column actualColumn = table.columns().get(i);
                    row[columnArray.getColumns()[i].position() - 1] = this.readField(rs, i + 1, actualColumn, table);
                }
                if (logTimer.expired()) {
                    long stop = this.clock.currentTimeInMillis();
                    LOG.info("Exported {} records for split '{}' after {}", new Object[]{rows, this.snapshotSplit.splitId(), Strings.duration(stop - exportStart)});
                    this.snapshotProgressListener.rowsScanned(table.id(), rows);
                    logTimer = this.getTableScanLogTimer();
                }
                this.dispatcher.dispatchSnapshotEvent(table.id(), this.getChangeRecordEmitter(snapshotContext, table.id(), row), snapshotReceiver);
            }
            LOG.info("Finished exporting {} records for split '{}', total duration '{}'", new Object[]{rows, this.snapshotSplit.splitId(), Strings.duration(this.clock.currentTimeInMillis() - exportStart)});
        }
        catch (SQLException e) {
            throw new ConnectException("Snapshotting of table " + table.id() + " failed", e);
        }
    }

    protected ChangeRecordEmitter getChangeRecordEmitter(AbstractSnapshotChangeEventSource.SnapshotContext snapshotContext, TableId tableId, Object[] row) {
        snapshotContext.offset.event(tableId, this.clock.currentTime());
        return new SnapshotChangeRecordEmitter(snapshotContext.offset, row, this.clock);
    }

    private Threads.Timer getTableScanLogTimer() {
        return Threads.timer(this.clock, LOG_INTERVAL);
    }

    private Object readField(ResultSet rs, int fieldNo, Column actualColumn, Table actualTable) throws SQLException {
        if (actualColumn.jdbcType() == 92) {
            return this.readTimeField(rs, fieldNo);
        }
        if (actualColumn.jdbcType() == 91) {
            return this.readDateField(rs, fieldNo, actualColumn, actualTable);
        }
        if (actualColumn.jdbcType() == 93) {
            return this.readTimestampField(rs, fieldNo, actualColumn, actualTable);
        }
        if (actualColumn.jdbcType() == -6 || actualColumn.jdbcType() == 5) {
            return rs.getObject(fieldNo) == null ? null : Integer.valueOf(rs.getInt(fieldNo));
        }
        if ("CHAR".equals(actualColumn.typeName()) || "VARCHAR".equals(actualColumn.typeName()) || "TEXT".equals(actualColumn.typeName())) {
            return rs.getBytes(fieldNo);
        }
        return rs.getObject(fieldNo);
    }

    private Object readTimeField(ResultSet rs, int fieldNo) throws SQLException {
        Blob b = rs.getBlob(fieldNo);
        if (b == null) {
            return null;
        }
        try {
            return MySqlValueConverters.stringToDuration(new String(b.getBytes(1L, (int)b.length()), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Could not read MySQL TIME value as UTF-8");
            throw new RuntimeException(e);
        }
    }

    private Object readDateField(ResultSet rs, int fieldNo, Column column, Table table) throws SQLException {
        Blob b = rs.getBlob(fieldNo);
        if (b == null) {
            return null;
        }
        try {
            return MySqlValueConverters.stringToLocalDate(new String(b.getBytes(1L, (int)b.length()), "UTF-8"), column, table);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Could not read MySQL TIME value as UTF-8");
            throw new RuntimeException(e);
        }
    }

    private Object readTimestampField(ResultSet rs, int fieldNo, Column column, Table table) throws SQLException {
        Blob b = rs.getBlob(fieldNo);
        if (b == null) {
            return null;
        }
        try {
            return MySqlValueConverters.containsZeroValuesInDatePart(new String(b.getBytes(1L, (int)b.length()), "UTF-8"), column, table) ? null : rs.getTimestamp(fieldNo, Calendar.getInstance());
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Could not read MySQL TIME value as UTF-8");
            throw new RuntimeException(e);
        }
    }

    private static class MySqlSnapshotContext
    extends RelationalSnapshotChangeEventSource.RelationalSnapshotContext {
        public MySqlSnapshotContext() throws SQLException {
            super("");
        }
    }
}

