/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.mongodb.table;

import com.mongodb.MongoNamespace;
import com.ververica.cdc.connectors.mongodb.table.MongoDBConnectorDeserializationSchema;
import com.ververica.cdc.connectors.mongodb.table.MongoDBReadableMetadata;
import com.ververica.cdc.connectors.mongodb.utils.CollectionDiscoveryUtils;
import com.ververica.cdc.debezium.table.MetadataConverter;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.connector.source.abilities.SupportsReadingMetadata;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.sort.cdc.mongodb.DebeziumSourceFunction;
import org.apache.inlong.sort.cdc.mongodb.MongoDBSource;

public class MongoDBTableSource
implements ScanTableSource,
SupportsReadingMetadata {
    private final ResolvedSchema physicalSchema;
    private final String hosts;
    private final String connectionOptions;
    private final String username;
    private final String password;
    private final String database;
    private final String collection;
    private final Boolean errorsLogEnable;
    private final String errorsTolerance;
    private final Boolean copyExisting;
    private final String copyExistingPipeline;
    private final Integer copyExistingMaxThreads;
    private final Integer copyExistingQueueSize;
    private final Integer pollMaxBatchSize;
    private final Integer pollAwaitTimeMillis;
    private final Integer heartbeatIntervalMillis;
    private final ZoneId localTimeZone;
    private final String inlongMetric;
    private final String inlongAudit;
    protected DataType producedDataType;
    protected List<String> metadataKeys;

    public MongoDBTableSource(ResolvedSchema physicalSchema, String hosts, @Nullable String username, @Nullable String password, @Nullable String database, @Nullable String collection, @Nullable String connectionOptions, @Nullable String errorsTolerance, @Nullable Boolean errorsLogEnable, @Nullable Boolean copyExisting, @Nullable String copyExistingPipeline, @Nullable Integer copyExistingMaxThreads, @Nullable Integer copyExistingQueueSize, @Nullable Integer pollMaxBatchSize, @Nullable Integer pollAwaitTimeMillis, @Nullable Integer heartbeatIntervalMillis, ZoneId localTimeZone, String inlongMetric, String inlongAudit) {
        this.physicalSchema = physicalSchema;
        this.hosts = (String)Preconditions.checkNotNull((Object)hosts);
        this.username = username;
        this.password = password;
        this.database = database;
        this.collection = collection;
        this.connectionOptions = connectionOptions;
        this.errorsTolerance = errorsTolerance;
        this.errorsLogEnable = errorsLogEnable;
        this.copyExisting = copyExisting;
        this.copyExistingPipeline = copyExistingPipeline;
        this.copyExistingMaxThreads = copyExistingMaxThreads;
        this.copyExistingQueueSize = copyExistingQueueSize;
        this.pollMaxBatchSize = pollMaxBatchSize;
        this.pollAwaitTimeMillis = pollAwaitTimeMillis;
        this.heartbeatIntervalMillis = heartbeatIntervalMillis;
        this.localTimeZone = localTimeZone;
        this.producedDataType = physicalSchema.toPhysicalRowDataType();
        this.metadataKeys = Collections.emptyList();
        this.inlongMetric = inlongMetric;
        this.inlongAudit = inlongAudit;
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext scanContext) {
        RowType physicalDataType = (RowType)this.physicalSchema.toPhysicalRowDataType().getLogicalType();
        MetadataConverter[] metadataConverters = this.getMetadataConverters();
        TypeInformation typeInfo = scanContext.createTypeInformation(this.producedDataType);
        MongoDBConnectorDeserializationSchema deserializer = new MongoDBConnectorDeserializationSchema(physicalDataType, metadataConverters, (TypeInformation<RowData>)typeInfo, this.localTimeZone);
        MongoDBSource.Builder<RowData> builder = MongoDBSource.builder().hosts(this.hosts).deserializer(deserializer);
        if (StringUtils.isNotEmpty((CharSequence)this.database) && StringUtils.isNotEmpty((CharSequence)this.collection)) {
            if (!CollectionDiscoveryUtils.containsRegexMetaCharacters(this.database) && !CollectionDiscoveryUtils.containsRegexMetaCharacters(this.collection)) {
                MongoNamespace.checkDatabaseNameValidity(this.database);
                MongoNamespace.checkCollectionNameValidity(this.collection);
                builder.databaseList(this.database);
                builder.collectionList(this.database + "." + this.collection);
            } else {
                builder.databaseList(this.database);
                builder.collectionList(this.collection);
            }
        } else if (StringUtils.isNotEmpty((CharSequence)this.database)) {
            builder.databaseList(this.database);
        } else if (StringUtils.isNotEmpty((CharSequence)this.collection)) {
            builder.collectionList(this.collection);
        }
        Optional.ofNullable(this.username).ifPresent(builder::username);
        Optional.ofNullable(this.password).ifPresent(builder::password);
        Optional.ofNullable(this.connectionOptions).ifPresent(builder::connectionOptions);
        Optional.ofNullable(this.errorsLogEnable).ifPresent(builder::errorsLogEnable);
        Optional.ofNullable(this.errorsTolerance).ifPresent(builder::errorsTolerance);
        Optional.ofNullable(this.copyExisting).ifPresent(builder::copyExisting);
        Optional.ofNullable(this.copyExistingPipeline).ifPresent(builder::copyExistingPipeline);
        Optional.ofNullable(this.copyExistingMaxThreads).ifPresent(builder::copyExistingMaxThreads);
        Optional.ofNullable(this.copyExistingQueueSize).ifPresent(builder::copyExistingQueueSize);
        Optional.ofNullable(this.pollMaxBatchSize).ifPresent(builder::pollMaxBatchSize);
        Optional.ofNullable(this.pollAwaitTimeMillis).ifPresent(builder::pollAwaitTimeMillis);
        Optional.ofNullable(this.heartbeatIntervalMillis).ifPresent(builder::heartbeatIntervalMillis);
        Optional.ofNullable(this.inlongMetric).ifPresent(builder::inlongMetric);
        Optional.ofNullable(this.inlongAudit).ifPresent(builder::inlongAudit);
        DebeziumSourceFunction<RowData> sourceFunction = builder.build();
        return SourceFunctionProvider.of(sourceFunction, (boolean)false);
    }

    protected MetadataConverter[] getMetadataConverters() {
        if (this.metadataKeys.isEmpty()) {
            return new MetadataConverter[0];
        }
        return (MetadataConverter[])this.metadataKeys.stream().map(key -> Stream.of(MongoDBReadableMetadata.values()).filter(m -> m.getKey().equals(key)).findFirst().orElseThrow(IllegalStateException::new)).map(MongoDBReadableMetadata::getConverter).toArray(MetadataConverter[]::new);
    }

    public Map<String, DataType> listReadableMetadata() {
        return Stream.of(MongoDBReadableMetadata.values()).collect(Collectors.toMap(MongoDBReadableMetadata::getKey, MongoDBReadableMetadata::getDataType));
    }

    public void applyReadableMetadata(List<String> metadataKeys, DataType producedDataType) {
        this.metadataKeys = metadataKeys;
        this.producedDataType = producedDataType;
    }

    public DynamicTableSource copy() {
        MongoDBTableSource source = new MongoDBTableSource(this.physicalSchema, this.hosts, this.username, this.password, this.database, this.collection, this.connectionOptions, this.errorsTolerance, this.errorsLogEnable, this.copyExisting, this.copyExistingPipeline, this.copyExistingMaxThreads, this.copyExistingQueueSize, this.pollMaxBatchSize, this.pollAwaitTimeMillis, this.heartbeatIntervalMillis, this.localTimeZone, this.inlongMetric, this.inlongAudit);
        source.metadataKeys = this.metadataKeys;
        source.producedDataType = this.producedDataType;
        return source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoDBTableSource that = (MongoDBTableSource)o;
        return Objects.equals(this.physicalSchema, that.physicalSchema) && Objects.equals(this.hosts, that.hosts) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.database, that.database) && Objects.equals(this.collection, that.collection) && Objects.equals(this.connectionOptions, that.connectionOptions) && Objects.equals(this.errorsTolerance, that.errorsTolerance) && Objects.equals(this.errorsLogEnable, that.errorsLogEnable) && Objects.equals(this.copyExisting, that.copyExisting) && Objects.equals(this.copyExistingPipeline, that.copyExistingPipeline) && Objects.equals(this.copyExistingMaxThreads, that.copyExistingMaxThreads) && Objects.equals(this.copyExistingQueueSize, that.copyExistingQueueSize) && Objects.equals(this.pollMaxBatchSize, that.pollMaxBatchSize) && Objects.equals(this.pollAwaitTimeMillis, that.pollAwaitTimeMillis) && Objects.equals(this.heartbeatIntervalMillis, that.heartbeatIntervalMillis) && Objects.equals(this.localTimeZone, that.localTimeZone) && Objects.equals(this.producedDataType, that.producedDataType) && Objects.equals(this.metadataKeys, that.metadataKeys) && Objects.equals(this.inlongMetric, that.inlongMetric) && Objects.equals(this.inlongAudit, that.inlongAudit);
    }

    public int hashCode() {
        return Objects.hash(this.physicalSchema, this.hosts, this.username, this.password, this.database, this.collection, this.connectionOptions, this.errorsTolerance, this.errorsLogEnable, this.copyExisting, this.copyExistingPipeline, this.copyExistingMaxThreads, this.copyExistingQueueSize, this.pollMaxBatchSize, this.pollAwaitTimeMillis, this.heartbeatIntervalMillis, this.localTimeZone, this.producedDataType, this.metadataKeys, this.inlongMetric, this.inlongAudit);
    }

    public String asSummaryString() {
        return "MongoDB-CDC";
    }
}

