/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.mongodb;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import com.ververica.cdc.debezium.DebeziumDeserializationSchema;
import com.ververica.cdc.debezium.Validator;
import com.ververica.cdc.debezium.internal.DebeziumChangeConsumer;
import com.ververica.cdc.debezium.internal.DebeziumChangeFetcher;
import com.ververica.cdc.debezium.internal.DebeziumOffset;
import com.ververica.cdc.debezium.internal.DebeziumOffsetSerializer;
import com.ververica.cdc.debezium.internal.FlinkDatabaseHistory;
import com.ververica.cdc.debezium.internal.FlinkDatabaseSchemaHistory;
import com.ververica.cdc.debezium.internal.FlinkOffsetBackingStore;
import com.ververica.cdc.debezium.internal.Handover;
import com.ververica.cdc.debezium.internal.SchemaRecord;
import com.ververica.cdc.debezium.utils.DatabaseHistoryUtil;
import io.debezium.document.DocumentReader;
import io.debezium.document.DocumentWriter;
import io.debezium.embedded.Connect;
import io.debezium.engine.DebeziumEngine;
import io.debezium.engine.spi.OffsetCommitPolicy;
import io.debezium.heartbeat.Heartbeat;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.state.CheckpointListener;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.OperatorStateStore;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.shaded.guava18.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.flink.streaming.api.checkpoint.CheckpointedFunction;
import org.apache.flink.streaming.api.functions.source.RichSourceFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.util.Collector;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.inlong.audit.AuditImp;
import org.apache.inlong.sort.cdc.mongodb.shaded.org.apache.inlong.sort.base.metric.SourceMetricData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public class DebeziumSourceFunction<T>
extends RichSourceFunction<T>
implements CheckpointedFunction,
CheckpointListener,
ResultTypeQueryable<T> {
    public static final String OFFSETS_STATE_NAME = "offset-states";
    public static final String HISTORY_RECORDS_STATE_NAME = "history-records-states";
    public static final int MAX_NUM_PENDING_CHECKPOINTS = 100;
    public static final String LEGACY_IMPLEMENTATION_KEY = "internal.implementation";
    public static final String LEGACY_IMPLEMENTATION_VALUE = "legacy";
    protected static final Logger LOG = LoggerFactory.getLogger(DebeziumSourceFunction.class);
    private static final long serialVersionUID = -5808108641062931623L;
    private final DebeziumDeserializationSchema<T> deserializer;
    private final Properties properties;
    @Nullable
    private final DebeziumOffset specificOffset;
    private final LinkedMap pendingOffsetsToCommit = new LinkedMap();
    private final Validator validator;
    private volatile boolean debeziumStarted = false;
    private volatile transient String restoredOffsetState;
    private transient ListState<byte[]> offsetState;
    private transient ListState<String> schemaRecordsState;
    private transient ExecutorService executor;
    private transient DebeziumEngine<?> engine;
    private transient String engineInstanceName;
    private transient DebeziumChangeConsumer changeConsumer;
    private transient DebeziumChangeFetcher<T> debeziumChangeFetcher;
    private transient Handover handover;
    private String inlongMetric;
    private String inlongAudit;
    private SourceMetricData metricData;

    public DebeziumSourceFunction(DebeziumDeserializationSchema<T> deserializer, Properties properties, @Nullable DebeziumOffset specificOffset, Validator validator, String inlongMetric, String inlongAudit) {
        this.deserializer = deserializer;
        this.properties = properties;
        this.specificOffset = specificOffset;
        this.validator = validator;
        this.inlongMetric = inlongMetric;
        this.inlongAudit = inlongAudit;
    }

    public void open(Configuration parameters) throws Exception {
        this.validator.validate();
        super.open(parameters);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("debezium-engine").build();
        this.executor = Executors.newSingleThreadExecutor(threadFactory);
        this.handover = new Handover();
        this.changeConsumer = new DebeziumChangeConsumer(this.handover);
    }

    public void initializeState(FunctionInitializationContext context) throws Exception {
        OperatorStateStore stateStore = context.getOperatorStateStore();
        this.offsetState = stateStore.getUnionListState(new ListStateDescriptor(OFFSETS_STATE_NAME, (TypeInformation)PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO));
        this.schemaRecordsState = stateStore.getUnionListState(new ListStateDescriptor(HISTORY_RECORDS_STATE_NAME, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO));
        if (context.isRestored()) {
            this.restoreOffsetState();
            this.restoreHistoryRecordsState();
        } else if (this.specificOffset != null) {
            byte[] serializedOffset = DebeziumOffsetSerializer.INSTANCE.serialize(this.specificOffset);
            this.restoredOffsetState = new String(serializedOffset, StandardCharsets.UTF_8);
            LOG.info("Consumer subtask {} starts to read from specified offset {}.", (Object)this.getRuntimeContext().getIndexOfThisSubtask(), (Object)this.restoredOffsetState);
        } else {
            LOG.info("Consumer subtask {} has no restore state.", (Object)this.getRuntimeContext().getIndexOfThisSubtask());
        }
    }

    private void restoreOffsetState() throws Exception {
        for (byte[] serializedOffset : (Iterable)this.offsetState.get()) {
            if (this.restoredOffsetState == null) {
                this.restoredOffsetState = new String(serializedOffset, StandardCharsets.UTF_8);
                continue;
            }
            throw new RuntimeException("Debezium Source only support single task, however, this is restored from multiple tasks.");
        }
        LOG.info("Consumer subtask {} restored offset state: {}.", (Object)this.getRuntimeContext().getIndexOfThisSubtask(), (Object)this.restoredOffsetState);
    }

    private void restoreHistoryRecordsState() throws Exception {
        DocumentReader reader = DocumentReader.defaultReader();
        ConcurrentLinkedQueue<SchemaRecord> historyRecords = new ConcurrentLinkedQueue<SchemaRecord>();
        int recordsCount = 0;
        boolean firstEntry = true;
        for (String record : (Iterable)this.schemaRecordsState.get()) {
            if (firstEntry) {
                this.engineInstanceName = record;
                firstEntry = false;
                continue;
            }
            historyRecords.add(new SchemaRecord(reader.read(record)));
            ++recordsCount;
        }
        if (this.engineInstanceName != null) {
            DatabaseHistoryUtil.registerHistory(this.engineInstanceName, historyRecords);
        }
        LOG.info("Consumer subtask {} restored history records state: {} with {} records.", new Object[]{this.getRuntimeContext().getIndexOfThisSubtask(), this.engineInstanceName, recordsCount});
    }

    public void snapshotState(FunctionSnapshotContext functionSnapshotContext) throws Exception {
        if (this.handover.hasError()) {
            LOG.debug("snapshotState() called on closed source");
            throw new FlinkRuntimeException("Call snapshotState() on closed source, checkpoint failed.");
        }
        this.snapshotOffsetState(functionSnapshotContext.getCheckpointId());
        this.snapshotHistoryRecordsState();
    }

    private void snapshotOffsetState(long checkpointId) throws Exception {
        this.offsetState.clear();
        DebeziumChangeFetcher<T> fetcher = this.debeziumChangeFetcher;
        byte[] serializedOffset = null;
        if (fetcher == null) {
            if (this.restoredOffsetState != null) {
                serializedOffset = this.restoredOffsetState.getBytes(StandardCharsets.UTF_8);
            }
        } else {
            byte[] currentState = fetcher.snapshotCurrentState();
            serializedOffset = currentState == null && this.restoredOffsetState != null ? this.restoredOffsetState.getBytes(StandardCharsets.UTF_8) : currentState;
        }
        if (serializedOffset != null) {
            this.offsetState.add((Object)serializedOffset);
            this.pendingOffsetsToCommit.put((Object)checkpointId, (Object)serializedOffset);
            while (this.pendingOffsetsToCommit.size() > 100) {
                this.pendingOffsetsToCommit.remove(0);
            }
        }
    }

    private void snapshotHistoryRecordsState() throws Exception {
        this.schemaRecordsState.clear();
        if (this.engineInstanceName != null) {
            this.schemaRecordsState.add((Object)this.engineInstanceName);
            Collection<SchemaRecord> records = DatabaseHistoryUtil.retrieveHistory(this.engineInstanceName);
            DocumentWriter writer = DocumentWriter.defaultWriter();
            for (SchemaRecord record : records) {
                this.schemaRecordsState.add((Object)writer.write(record.toDocument()));
            }
        }
    }

    public void run(SourceFunction.SourceContext<T> sourceContext) throws Exception {
        Method getMetricGroupMethod = this.getRuntimeContext().getClass().getMethod("getMetricGroup", new Class[0]);
        getMetricGroupMethod.setAccessible(true);
        MetricGroup metricGroup = (MetricGroup)getMetricGroupMethod.invoke((Object)this.getRuntimeContext(), new Object[0]);
        metricGroup.gauge("currentFetchEventTimeLag", () -> this.debeziumChangeFetcher.getFetchDelay());
        metricGroup.gauge("currentEmitEventTimeLag", () -> this.debeziumChangeFetcher.getEmitDelay());
        metricGroup.gauge("sourceIdleTime", () -> this.debeziumChangeFetcher.getIdleTime());
        if (StringUtils.isNotEmpty((CharSequence)this.inlongMetric)) {
            String[] inlongMetricArray = this.inlongMetric.split("&");
            String groupId = inlongMetricArray[0];
            String streamId = inlongMetricArray[1];
            String nodeId = inlongMetricArray[2];
            AuditImp auditImp = null;
            if (this.inlongAudit != null) {
                AuditImp.getInstance().setAuditProxy(new HashSet<String>(Arrays.asList(this.inlongAudit.split("&"))));
                auditImp = AuditImp.getInstance();
            }
            this.metricData = new SourceMetricData(groupId, streamId, nodeId, metricGroup, auditImp);
            this.metricData.registerMetricsForNumRecordsIn();
            this.metricData.registerMetricsForNumBytesIn();
            this.metricData.registerMetricsForNumBytesInPerSecond();
            this.metricData.registerMetricsForNumRecordsInPerSecond();
        }
        this.properties.setProperty("name", "engine");
        this.properties.setProperty("offset.storage", FlinkOffsetBackingStore.class.getCanonicalName());
        if (this.restoredOffsetState != null) {
            this.properties.setProperty("offset.storage.flink.state.value", this.restoredOffsetState);
        }
        this.properties.setProperty("include.schema.changes", "false");
        this.properties.setProperty("offset.flush.interval.ms", String.valueOf(Long.MAX_VALUE));
        this.properties.setProperty("tombstones.on.delete", "false");
        if (this.engineInstanceName == null) {
            this.engineInstanceName = UUID.randomUUID().toString();
        }
        this.properties.setProperty("database.history.instance.name", this.engineInstanceName);
        this.properties.setProperty("database.history", this.determineDatabase().getCanonicalName());
        String dbzHeartbeatPrefix = this.properties.getProperty(Heartbeat.HEARTBEAT_TOPICS_PREFIX.name(), Heartbeat.HEARTBEAT_TOPICS_PREFIX.defaultValueAsString());
        this.debeziumChangeFetcher = new DebeziumChangeFetcher<T>(sourceContext, new DebeziumDeserializationSchema<T>(){

            @Override
            public void deserialize(SourceRecord record, Collector<T> out) throws Exception {
                if (DebeziumSourceFunction.this.metricData != null) {
                    DebeziumSourceFunction.this.metricData.outputMetrics(1L, record.value().toString().getBytes(StandardCharsets.UTF_8).length);
                }
                DebeziumSourceFunction.this.deserializer.deserialize(record, out);
            }

            public TypeInformation<T> getProducedType() {
                return DebeziumSourceFunction.this.deserializer.getProducedType();
            }
        }, this.restoredOffsetState == null, dbzHeartbeatPrefix, this.handover);
        this.engine = DebeziumEngine.create(Connect.class).using(this.properties).notifying(this.changeConsumer).using(OffsetCommitPolicy.always()).using((success, message, error) -> {
            if (success) {
                this.handover.close();
            } else {
                this.handover.reportError(error);
            }
        }).build();
        this.executor.execute(this.engine);
        this.debeziumStarted = true;
        this.debeziumChangeFetcher.runFetchLoop();
    }

    public void notifyCheckpointComplete(long checkpointId) {
        if (!this.debeziumStarted) {
            LOG.debug("notifyCheckpointComplete() called when engine is not started.");
            return;
        }
        DebeziumChangeFetcher<T> fetcher = this.debeziumChangeFetcher;
        if (fetcher == null) {
            LOG.debug("notifyCheckpointComplete() called on uninitialized source");
            return;
        }
        try {
            int posInMap = this.pendingOffsetsToCommit.indexOf((Object)checkpointId);
            if (posInMap == -1) {
                LOG.warn("Consumer subtask {} received confirmation for unknown checkpoint id {}", (Object)this.getRuntimeContext().getIndexOfThisSubtask(), (Object)checkpointId);
                return;
            }
            byte[] serializedOffsets = (byte[])this.pendingOffsetsToCommit.remove(posInMap);
            for (int i = 0; i < posInMap; ++i) {
                this.pendingOffsetsToCommit.remove(0);
            }
            if (serializedOffsets == null || serializedOffsets.length == 0) {
                LOG.debug("Consumer subtask {} has empty checkpoint state.", (Object)this.getRuntimeContext().getIndexOfThisSubtask());
                return;
            }
            DebeziumOffset offset = DebeziumOffsetSerializer.INSTANCE.deserialize(serializedOffsets);
            this.changeConsumer.commitOffset(offset);
        }
        catch (Exception e) {
            LOG.warn("Ignore error when committing offset to database.", (Throwable)e);
        }
    }

    public void cancel() {
        this.shutdownEngine();
        if (this.debeziumChangeFetcher != null) {
            this.debeziumChangeFetcher.close();
        }
    }

    public void close() throws Exception {
        this.cancel();
        if (this.executor != null) {
            this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        super.close();
    }

    private void shutdownEngine() {
        try {
            if (this.engine != null) {
                this.engine.close();
            }
        }
        catch (IOException e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
        finally {
            if (this.executor != null) {
                this.executor.shutdownNow();
            }
            this.debeziumStarted = false;
            if (this.handover != null) {
                this.handover.close();
            }
        }
    }

    public TypeInformation<T> getProducedType() {
        return this.deserializer.getProducedType();
    }

    @VisibleForTesting
    public LinkedMap getPendingOffsetsToCommit() {
        return this.pendingOffsetsToCommit;
    }

    @VisibleForTesting
    public boolean getDebeziumStarted() {
        return this.debeziumStarted;
    }

    private Class<?> determineDatabase() {
        boolean isCompatibleWithLegacy = FlinkDatabaseHistory.isCompatible(DatabaseHistoryUtil.retrieveHistory(this.engineInstanceName));
        if (LEGACY_IMPLEMENTATION_VALUE.equals(this.properties.get(LEGACY_IMPLEMENTATION_KEY))) {
            if (isCompatibleWithLegacy) {
                return FlinkDatabaseHistory.class;
            }
            throw new IllegalStateException("The configured option 'debezium.internal.implementation' is 'legacy', but the state of source is incompatible with this implementation, you should remove the the option.");
        }
        if (FlinkDatabaseSchemaHistory.isCompatible(DatabaseHistoryUtil.retrieveHistory(this.engineInstanceName))) {
            return FlinkDatabaseSchemaHistory.class;
        }
        if (isCompatibleWithLegacy) {
            return FlinkDatabaseHistory.class;
        }
        throw new IllegalStateException("Can't determine which DatabaseHistory to use.");
    }

    @VisibleForTesting
    public String getEngineInstanceName() {
        return this.engineInstanceName;
    }

    public SourceMetricData getMetricData() {
        return this.metricData;
    }
}

