/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.util;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.inlong.audit.protocol.AuditApi;

public class AuditData
implements Serializable {
    public static int HEAD_LENGTH = 4;
    private final long sdkTime;
    private final AuditApi.BaseCommand content;
    private AtomicInteger resendTimes = new AtomicInteger(0);

    public AuditData(long sdkTime, AuditApi.BaseCommand content) {
        this.sdkTime = sdkTime;
        this.content = content;
    }

    public int increaseResendTimes() {
        return this.resendTimes.incrementAndGet();
    }

    public byte[] getDataByte() {
        return this.addBytes(ByteBuffer.allocate(HEAD_LENGTH).putInt(this.content.toByteArray().length).array(), this.content.toByteArray());
    }

    public byte[] addBytes(byte[] data1, byte[] data2) {
        byte[] data3 = new byte[data1.length + data2.length];
        System.arraycopy(data1, 0, data3, 0, data1.length);
        System.arraycopy(data2, 0, data3, data1.length, data2.length);
        return data3;
    }
}

