/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.acl;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.acl.AccessControlEntry;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.acl.AccessControlEntryData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.acl.AclOperation;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.acl.AclPermissionType;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.annotation.InterfaceStability;
import java.util.Objects;

@InterfaceStability.Evolving
public class AccessControlEntryFilter {
    private final AccessControlEntryData data;
    public static final AccessControlEntryFilter ANY = new AccessControlEntryFilter(null, null, AclOperation.ANY, AclPermissionType.ANY);

    public AccessControlEntryFilter(String principal, String host, AclOperation operation, AclPermissionType permissionType) {
        Objects.requireNonNull(operation);
        Objects.requireNonNull(permissionType);
        this.data = new AccessControlEntryData(principal, host, operation, permissionType);
    }

    AccessControlEntryFilter(AccessControlEntryData data) {
        this.data = data;
    }

    public String principal() {
        return this.data.principal();
    }

    public String host() {
        return this.data.host();
    }

    public AclOperation operation() {
        return this.data.operation();
    }

    public AclPermissionType permissionType() {
        return this.data.permissionType();
    }

    public String toString() {
        return this.data.toString();
    }

    public boolean isUnknown() {
        return this.data.isUnknown();
    }

    public boolean matches(AccessControlEntry other) {
        if (this.principal() != null && !this.data.principal().equals(other.principal())) {
            return false;
        }
        if (this.host() != null && !this.host().equals(other.host())) {
            return false;
        }
        if (this.operation() != AclOperation.ANY && !this.operation().equals((Object)other.operation())) {
            return false;
        }
        return this.permissionType() == AclPermissionType.ANY || this.permissionType().equals((Object)other.permissionType());
    }

    public boolean matchesAtMostOne() {
        return this.findIndefiniteField() == null;
    }

    public String findIndefiniteField() {
        return this.data.findIndefiniteField();
    }

    public boolean equals(Object o) {
        if (!(o instanceof AccessControlEntryFilter)) {
            return false;
        }
        AccessControlEntryFilter other = (AccessControlEntryFilter)o;
        return this.data.equals(other.data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }
}

