/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mongodb.table;

import com.mongodb.client.model.changestream.OperationType;
import com.mongodb.internal.HexUtils;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import com.ververica.cdc.debezium.DebeziumDeserializationSchema;
import com.ververica.cdc.debezium.table.AppendMetadataCollector;
import com.ververica.cdc.debezium.table.MetadataConverter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeUtils;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonDateTime;
import org.bson.BsonDocument;
import org.bson.BsonMaxKey;
import org.bson.BsonMinKey;
import org.bson.BsonRegularExpression;
import org.bson.BsonTimestamp;
import org.bson.BsonUndefined;
import org.bson.BsonValue;
import org.bson.types.Decimal128;

public class MongoDBConnectorDeserializationSchema
implements DebeziumDeserializationSchema<RowData> {
    private static final long serialVersionUID = 1750787080613035184L;
    private final TypeInformation<RowData> resultTypeInfo;
    private final ZoneId localTimeZone;
    protected final DeserializationRuntimeConverter physicalConverter;
    protected final boolean hasMetadata;
    private final AppendMetadataCollector appendMetadataCollector;

    public MongoDBConnectorDeserializationSchema(RowType physicalDataType, MetadataConverter[] metadataConverters, TypeInformation<RowData> resultTypeInfo, ZoneId localTimeZone) {
        this.hasMetadata = ((MetadataConverter[])Preconditions.checkNotNull((Object)metadataConverters)).length > 0;
        this.appendMetadataCollector = new AppendMetadataCollector(metadataConverters);
        this.physicalConverter = this.createConverter((LogicalType)physicalDataType);
        this.resultTypeInfo = resultTypeInfo;
        this.localTimeZone = localTimeZone;
    }

    @Override
    public void deserialize(SourceRecord record, Collector<RowData> out) throws Exception {
        Struct value = (Struct)record.value();
        Schema valueSchema = record.valueSchema();
        OperationType op = this.operationTypeFor(record);
        BsonDocument documentKey = (BsonDocument)Preconditions.checkNotNull((Object)this.extractBsonDocument(value, valueSchema, "documentKey"));
        BsonDocument fullDocument = this.extractBsonDocument(value, valueSchema, "fullDocument");
        switch (op) {
            case INSERT: {
                GenericRowData insert = this.extractRowData(fullDocument);
                insert.setRowKind(RowKind.INSERT);
                this.emit(record, (RowData)insert, out);
                break;
            }
            case DELETE: {
                GenericRowData delete = this.extractRowData(documentKey);
                delete.setRowKind(RowKind.DELETE);
                this.emit(record, (RowData)delete, out);
                break;
            }
            case UPDATE: {
                if (fullDocument == null) break;
                GenericRowData updateAfter = this.extractRowData(fullDocument);
                updateAfter.setRowKind(RowKind.UPDATE_AFTER);
                this.emit(record, (RowData)updateAfter, out);
                break;
            }
            case REPLACE: {
                GenericRowData replaceAfter = this.extractRowData(fullDocument);
                replaceAfter.setRowKind(RowKind.UPDATE_AFTER);
                this.emit(record, (RowData)replaceAfter, out);
                break;
            }
        }
    }

    private GenericRowData extractRowData(BsonDocument document) throws Exception {
        Preconditions.checkNotNull((Object)document);
        return (GenericRowData)this.physicalConverter.convert(document);
    }

    private BsonDocument extractBsonDocument(Struct value, Schema valueSchema, String fieldName) {
        String docString;
        if (valueSchema.field(fieldName) != null && (docString = value.getString(fieldName)) != null) {
            return BsonDocument.parse(value.getString(fieldName));
        }
        return null;
    }

    public TypeInformation<RowData> getProducedType() {
        return this.resultTypeInfo;
    }

    private OperationType operationTypeFor(SourceRecord record) {
        Struct value = (Struct)record.value();
        return OperationType.fromString(value.getString("operationType"));
    }

    private void emit(SourceRecord inRecord, RowData physicalRow, Collector<RowData> collector) {
        if (!this.hasMetadata) {
            collector.collect((Object)physicalRow);
            return;
        }
        this.appendMetadataCollector.inputRecord = inRecord;
        this.appendMetadataCollector.outputCollector = collector;
        this.appendMetadataCollector.collect(physicalRow);
    }

    private DeserializationRuntimeConverter createConverter(LogicalType type) {
        return this.wrapIntoNullableConverter(this.createNotNullConverter(type));
    }

    private DeserializationRuntimeConverter createNotNullConverter(LogicalType type) {
        switch (type.getTypeRoot()) {
            case NULL: {
                return docObj -> null;
            }
            case BOOLEAN: {
                return this::convertToBoolean;
            }
            case TINYINT: {
                return this::convertToTinyInt;
            }
            case SMALLINT: {
                return this::convertToSmallInt;
            }
            case INTEGER: 
            case INTERVAL_YEAR_MONTH: {
                return this::convertToInt;
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                return this::convertToLong;
            }
            case DATE: {
                return this::convertToDate;
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return this::convertToTime;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return this::convertToTimestamp;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return this::convertToLocalTimeZoneTimestamp;
            }
            case FLOAT: {
                return this::convertToFloat;
            }
            case DOUBLE: {
                return this::convertToDouble;
            }
            case CHAR: 
            case VARCHAR: {
                return this::convertToString;
            }
            case BINARY: 
            case VARBINARY: {
                return this::convertToBinary;
            }
            case DECIMAL: {
                return this.createDecimalConverter((DecimalType)type);
            }
            case ROW: {
                return this.createRowConverter((RowType)type);
            }
            case ARRAY: {
                return this.createArrayConverter((ArrayType)type);
            }
            case MAP: {
                return this.createMapConverter((MapType)type);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    private boolean convertToBoolean(BsonValue docObj) {
        if (docObj.isBoolean()) {
            return docObj.asBoolean().getValue();
        }
        if (docObj.isInt32()) {
            return docObj.asInt32().getValue() == 1;
        }
        if (docObj.isInt64()) {
            return docObj.asInt64().getValue() == 1L;
        }
        if (docObj.isString()) {
            return Boolean.parseBoolean(docObj.asString().getValue());
        }
        throw new IllegalArgumentException("Unable to convert to boolean from unexpected value '" + docObj + "' of type " + (Object)((Object)docObj.getBsonType()));
    }

    private byte convertToTinyInt(BsonValue docObj) {
        if (docObj.isBoolean()) {
            return docObj.asBoolean().getValue() ? (byte)1 : 0;
        }
        if (docObj.isInt32()) {
            return (byte)docObj.asInt32().getValue();
        }
        if (docObj.isInt64()) {
            return (byte)docObj.asInt64().getValue();
        }
        if (docObj.isString()) {
            return Byte.parseByte(docObj.asString().getValue());
        }
        throw new IllegalArgumentException("Unable to convert to tinyint from unexpected value '" + docObj + "' of type " + (Object)((Object)docObj.getBsonType()));
    }

    private short convertToSmallInt(BsonValue docObj) {
        if (docObj.isBoolean()) {
            return docObj.asBoolean().getValue() ? (short)1 : 0;
        }
        if (docObj.isInt32()) {
            return (short)docObj.asInt32().getValue();
        }
        if (docObj.isInt64()) {
            return (short)docObj.asInt64().getValue();
        }
        if (docObj.isString()) {
            return Short.parseShort(docObj.asString().getValue());
        }
        throw new IllegalArgumentException("Unable to convert to smallint from unexpected value '" + docObj + "' of type " + (Object)((Object)docObj.getBsonType()));
    }

    private int convertToInt(BsonValue docObj) {
        if (docObj.isNumber()) {
            return docObj.asNumber().intValue();
        }
        if (docObj.isDecimal128()) {
            Decimal128 decimal128Value = docObj.asDecimal128().decimal128Value();
            if (decimal128Value.isFinite()) {
                return decimal128Value.intValue();
            }
            if (decimal128Value.isNegative()) {
                return Integer.MIN_VALUE;
            }
            return Integer.MAX_VALUE;
        }
        if (docObj.isBoolean()) {
            return docObj.asBoolean().getValue() ? 1 : 0;
        }
        if (docObj.isDateTime()) {
            return Math.toIntExact(docObj.asDateTime().getValue() / 1000L);
        }
        if (docObj.isTimestamp()) {
            return docObj.asTimestamp().getTime();
        }
        if (docObj.isString()) {
            return Integer.parseInt(docObj.asString().getValue());
        }
        throw new IllegalArgumentException("Unable to convert to integer from unexpected value '" + docObj + "' of type " + (Object)((Object)docObj.getBsonType()));
    }

    private long convertToLong(BsonValue docObj) {
        if (docObj.isNumber()) {
            return docObj.asNumber().longValue();
        }
        if (docObj.isDecimal128()) {
            Decimal128 decimal128Value = docObj.asDecimal128().decimal128Value();
            if (decimal128Value.isFinite()) {
                return decimal128Value.longValue();
            }
            if (decimal128Value.isNegative()) {
                return Long.MIN_VALUE;
            }
            return Long.MAX_VALUE;
        }
        if (docObj.isBoolean()) {
            return docObj.asBoolean().getValue() ? 1L : 0L;
        }
        if (docObj.isDateTime()) {
            return docObj.asDateTime().getValue();
        }
        if (docObj.isTimestamp()) {
            return (long)docObj.asTimestamp().getTime() * 1000L;
        }
        if (docObj.isString()) {
            return Long.parseLong(docObj.asString().getValue());
        }
        throw new IllegalArgumentException("Unable to convert to long from unexpected value '" + docObj + "' of type " + (Object)((Object)docObj.getBsonType()));
    }

    private double convertToDouble(BsonValue docObj) {
        if (docObj.isNumber()) {
            return docObj.asNumber().doubleValue();
        }
        if (docObj.isDecimal128()) {
            Decimal128 decimal128Value = docObj.asDecimal128().decimal128Value();
            if (decimal128Value.isFinite()) {
                return decimal128Value.doubleValue();
            }
            if (decimal128Value.isNegative()) {
                return -1.7976931348623157E308;
            }
            return Double.MAX_VALUE;
        }
        if (docObj.isBoolean()) {
            return docObj.asBoolean().getValue() ? 1.0 : 0.0;
        }
        if (docObj.isString()) {
            return Double.parseDouble(docObj.asString().getValue());
        }
        throw new IllegalArgumentException("Unable to convert to double from unexpected value '" + docObj + "' of type " + (Object)((Object)docObj.getBsonType()));
    }

    private float convertToFloat(BsonValue docObj) {
        if (docObj.isInt32()) {
            return docObj.asInt32().getValue();
        }
        if (docObj.isInt64()) {
            return docObj.asInt64().getValue();
        }
        if (docObj.isDouble()) {
            return Double.valueOf(docObj.asDouble().getValue()).floatValue();
        }
        if (docObj.isDecimal128()) {
            Decimal128 decimal128Value = docObj.asDecimal128().decimal128Value();
            if (decimal128Value.isFinite()) {
                return decimal128Value.floatValue();
            }
            if (decimal128Value.isNegative()) {
                return -3.4028235E38f;
            }
            return Float.MAX_VALUE;
        }
        if (docObj.isBoolean()) {
            return docObj.asBoolean().getValue() ? 1.0f : 0.0f;
        }
        if (docObj.isString()) {
            return Float.parseFloat(docObj.asString().getValue());
        }
        throw new IllegalArgumentException("Unable to convert to float from unexpected value '" + docObj + "' of type " + (Object)((Object)docObj.getBsonType()));
    }

    private LocalDate convertInstantToLocalDate(Instant instant) {
        return this.convertInstantToLocalDateTime(instant).toLocalDate();
    }

    private LocalTime convertInstantToLocalTime(Instant instant) {
        return this.convertInstantToLocalDateTime(instant).toLocalTime();
    }

    private LocalDateTime convertInstantToLocalDateTime(Instant instant) {
        return LocalDateTime.ofInstant(instant, this.localTimeZone);
    }

    private Instant convertToInstant(BsonTimestamp bsonTimestamp) {
        return Instant.ofEpochSecond(bsonTimestamp.getTime());
    }

    private Instant convertToInstant(BsonDateTime bsonDateTime) {
        return Instant.ofEpochMilli(bsonDateTime.getValue());
    }

    private int convertToDate(BsonValue docObj) {
        if (docObj.isDateTime()) {
            Instant instant = this.convertToInstant(docObj.asDateTime());
            return (int)this.convertInstantToLocalDate(instant).toEpochDay();
        }
        if (docObj.isTimestamp()) {
            Instant instant = this.convertToInstant(docObj.asTimestamp());
            return (int)this.convertInstantToLocalDate(instant).toEpochDay();
        }
        throw new IllegalArgumentException("Unable to convert to date from unexpected value '" + docObj + "' of type " + (Object)((Object)docObj.getBsonType()));
    }

    private int convertToTime(BsonValue docObj) {
        if (docObj.isDateTime()) {
            Instant instant = this.convertToInstant(docObj.asDateTime());
            return this.convertInstantToLocalTime(instant).toSecondOfDay() * 1000;
        }
        if (docObj.isTimestamp()) {
            Instant instant = this.convertToInstant(docObj.asTimestamp());
            return this.convertInstantToLocalTime(instant).toSecondOfDay() * 1000;
        }
        throw new IllegalArgumentException("Unable to convert to time from unexpected value '" + docObj + "' of type " + (Object)((Object)docObj.getBsonType()));
    }

    private TimestampData convertToTimestamp(BsonValue docObj) {
        if (docObj.isDateTime()) {
            return TimestampData.fromLocalDateTime((LocalDateTime)this.convertInstantToLocalDateTime(this.convertToInstant(docObj.asDateTime())));
        }
        if (docObj.isTimestamp()) {
            return TimestampData.fromLocalDateTime((LocalDateTime)this.convertInstantToLocalDateTime(this.convertToInstant(docObj.asTimestamp())));
        }
        throw new IllegalArgumentException("Unable to convert to timestamp from unexpected value '" + docObj + "' of type " + (Object)((Object)docObj.getBsonType()));
    }

    private TimestampData convertToLocalTimeZoneTimestamp(BsonValue docObj) {
        if (docObj.isDateTime()) {
            return TimestampData.fromEpochMillis((long)docObj.asDateTime().getValue());
        }
        if (docObj.isTimestamp()) {
            return TimestampData.fromEpochMillis((long)((long)docObj.asTimestamp().getTime() * 1000L));
        }
        throw new IllegalArgumentException("Unable to convert to timestamp with local timezone from unexpected value '" + docObj + "' of type " + (Object)((Object)docObj.getBsonType()));
    }

    private byte[] convertToBinary(BsonValue docObj) {
        if (docObj.isBinary()) {
            return docObj.asBinary().getData();
        }
        throw new UnsupportedOperationException("Unsupported BYTES value type: " + docObj.getClass().getSimpleName());
    }

    private StringData convertToString(BsonValue docObj) {
        if (docObj.isString()) {
            return StringData.fromString((String)docObj.asString().getValue());
        }
        if (docObj.isBinary()) {
            BsonBinary bsonBinary = docObj.asBinary();
            if (BsonBinarySubType.isUuid(bsonBinary.getType())) {
                return StringData.fromString((String)bsonBinary.asUuid().toString());
            }
            return StringData.fromString((String)HexUtils.toHex(bsonBinary.getData()));
        }
        if (docObj.isObjectId()) {
            return StringData.fromString((String)docObj.asObjectId().getValue().toHexString());
        }
        if (docObj.isInt32()) {
            return StringData.fromString((String)String.valueOf(docObj.asInt32().getValue()));
        }
        if (docObj.isInt64()) {
            return StringData.fromString((String)String.valueOf(docObj.asInt64().getValue()));
        }
        if (docObj.isDouble()) {
            return StringData.fromString((String)String.valueOf(docObj.asDouble().getValue()));
        }
        if (docObj.isDecimal128()) {
            return StringData.fromString((String)docObj.asDecimal128().getValue().toString());
        }
        if (docObj.isBoolean()) {
            return StringData.fromString((String)String.valueOf(docObj.asBoolean().getValue()));
        }
        if (docObj.isDateTime()) {
            Instant instant = this.convertToInstant(docObj.asDateTime());
            return StringData.fromString((String)this.convertInstantToLocalDateTime(instant).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }
        if (docObj.isTimestamp()) {
            Instant instant = this.convertToInstant(docObj.asTimestamp());
            return StringData.fromString((String)this.convertInstantToLocalDateTime(instant).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }
        if (docObj.isRegularExpression()) {
            BsonRegularExpression regex = docObj.asRegularExpression();
            return StringData.fromString((String)String.format("/%s/%s", regex.getPattern(), regex.getOptions()));
        }
        if (docObj.isJavaScript()) {
            return StringData.fromString((String)docObj.asJavaScript().getCode());
        }
        if (docObj.isJavaScriptWithScope()) {
            return StringData.fromString((String)docObj.asJavaScriptWithScope().getCode());
        }
        if (docObj.isSymbol()) {
            return StringData.fromString((String)docObj.asSymbol().getSymbol());
        }
        if (docObj.isDBPointer()) {
            return StringData.fromString((String)docObj.asDBPointer().getId().toHexString());
        }
        if (docObj instanceof BsonMinKey || docObj instanceof BsonMaxKey) {
            return StringData.fromString((String)docObj.getBsonType().name());
        }
        throw new IllegalArgumentException("Unable to convert to string from unexpected value '" + docObj + "' of type " + (Object)((Object)docObj.getBsonType()));
    }

    private DeserializationRuntimeConverter createDecimalConverter(DecimalType decimalType) {
        int precision = decimalType.getPrecision();
        int scale = decimalType.getScale();
        return docObj -> {
            BigDecimal bigDecimal;
            if (docObj.isString()) {
                bigDecimal = new BigDecimal(docObj.asString().getValue());
            } else if (docObj.isDecimal128()) {
                Decimal128 decimal128Value = docObj.asDecimal128().decimal128Value();
                bigDecimal = decimal128Value.isFinite() ? docObj.asDecimal128().decimal128Value().bigDecimalValue() : (decimal128Value.isNegative() ? BigDecimal.valueOf(-1.7976931348623157E308) : BigDecimal.valueOf(Double.MAX_VALUE));
            } else if (docObj.isDouble()) {
                bigDecimal = BigDecimal.valueOf(docObj.asDouble().doubleValue());
            } else if (docObj.isInt32()) {
                bigDecimal = BigDecimal.valueOf(docObj.asInt32().getValue());
            } else if (docObj.isInt64()) {
                bigDecimal = BigDecimal.valueOf(docObj.asInt64().getValue());
            } else {
                throw new IllegalArgumentException("Unable to convert to decimal from unexpected value '" + docObj + "' of type " + (Object)((Object)docObj.getBsonType()));
            }
            return DecimalData.fromBigDecimal((BigDecimal)bigDecimal, (int)precision, (int)scale);
        };
    }

    private DeserializationRuntimeConverter createRowConverter(RowType rowType) {
        DeserializationRuntimeConverter[] fieldConverters = (DeserializationRuntimeConverter[])rowType.getFields().stream().map(RowType.RowField::getType).map(this::createConverter).toArray(DeserializationRuntimeConverter[]::new);
        String[] fieldNames = rowType.getFieldNames().toArray(new String[0]);
        return docObj -> {
            if (!docObj.isDocument()) {
                throw new IllegalArgumentException("Unable to convert to rowType from unexpected value '" + docObj + "' of type " + (Object)((Object)docObj.getBsonType()));
            }
            BsonDocument document = docObj.asDocument();
            int arity = fieldNames.length;
            GenericRowData row = new GenericRowData(arity);
            for (int i = 0; i < arity; ++i) {
                String fieldName = fieldNames[i];
                BsonValue fieldValue = document.get(fieldName);
                Object convertedField = this.convertField(fieldConverters[i], fieldValue);
                row.setField(i, convertedField);
            }
            return row;
        };
    }

    private DeserializationRuntimeConverter createArrayConverter(ArrayType arrayType) {
        Class elementClass = LogicalTypeUtils.toInternalConversionClass((LogicalType)arrayType.getElementType());
        DeserializationRuntimeConverter elementConverter = this.createConverter(arrayType.getElementType());
        return docObj -> {
            if (!docObj.isArray()) {
                throw new IllegalArgumentException("Unable to convert to arrayType from unexpected value '" + docObj + "' of type " + (Object)((Object)docObj.getBsonType()));
            }
            BsonArray in = docObj.asArray();
            Object[] elementArray = (Object[])Array.newInstance(elementClass, in.size());
            for (int i = 0; i < in.size(); ++i) {
                elementArray[i] = elementConverter.convert((BsonValue)in.get(i));
            }
            return new GenericArrayData(elementArray);
        };
    }

    private DeserializationRuntimeConverter createMapConverter(MapType mapType) {
        LogicalType keyType = mapType.getKeyType();
        Preconditions.checkArgument((boolean)keyType.supportsInputConversion(String.class));
        LogicalType valueType = mapType.getValueType();
        DeserializationRuntimeConverter valueConverter = this.createConverter(valueType);
        return docObj -> {
            if (!docObj.isDocument()) {
                throw new IllegalArgumentException("Unable to convert to rowType from unexpected value '" + docObj + "' of type " + (Object)((Object)docObj.getBsonType()));
            }
            BsonDocument document = docObj.asDocument();
            HashMap<StringData, Object> map = new HashMap<StringData, Object>();
            for (String key : document.keySet()) {
                map.put(StringData.fromString((String)key), this.convertField(valueConverter, document.get(key)));
            }
            return new GenericMapData(map);
        };
    }

    private Object convertField(DeserializationRuntimeConverter fieldConverter, BsonValue fieldValue) throws Exception {
        if (fieldValue == null) {
            return null;
        }
        return fieldConverter.convert(fieldValue);
    }

    private DeserializationRuntimeConverter wrapIntoNullableConverter(DeserializationRuntimeConverter converter) {
        return docObj -> {
            if (docObj == null || docObj.isNull() || docObj instanceof BsonUndefined) {
                return null;
            }
            if (docObj.isDecimal128() && docObj.asDecimal128().getValue().isNaN()) {
                return null;
            }
            return converter.convert(docObj);
        };
    }

    @FunctionalInterface
    private static interface DeserializationRuntimeConverter
    extends Serializable {
        public Object convert(BsonValue var1) throws Exception;
    }
}

