/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.util;

import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.util.ConnectConfigException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigDef;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;

public final class Validators {
    public static ValidatorWithOperators emptyString() {
        return Validators.withStringDef("An empty string", (name, value) -> {
            if (!((String)value).isEmpty()) {
                throw new ConfigException(name, value, "Not empty");
            }
        });
    }

    public static ValidatorWithOperators matching(Pattern pattern) {
        return Validators.withStringDef(String.format("A string matching `%s`", pattern), (name, value) -> Validators.matchPattern(pattern, name, (String)value));
    }

    public static ValidatorWithOperators listMatchingPattern(Pattern pattern) {
        return Validators.withStringDef(String.format("A list matching: `%s`", pattern), (name, value) -> {
            try {
                ((List)value).forEach(v -> Validators.matchPattern(pattern, name, (String)v));
            }
            catch (ConnectConfigException e) {
                throw new ConfigException(name, value, e.getOriginalMessage());
            }
        });
    }

    private static void matchPattern(Pattern pattern, String name, String value) {
        if (!pattern.matcher(value).matches()) {
            String message = "Does not match: " + pattern.pattern();
            if (pattern.equals(MongoSinkTopicConfig.FULLY_QUALIFIED_CLASS_NAME)) {
                message = "Does not match expected class pattern.";
            }
            throw new ConnectConfigException(name, value, message);
        }
    }

    public static ValidatorWithOperators isAValidRegex() {
        return Validators.withStringDef("A valid regex", (name, value) -> {
            try {
                Pattern.compile((String)value);
            }
            catch (Exception e) {
                throw new ConfigException(name, value, "Invalid regex: " + e.getMessage());
            }
        });
    }

    public static ValidatorWithOperators topicOverrideValidator() {
        return Validators.withStringDef("Topic override", (name, value) -> {
            if (!((String)value).isEmpty()) {
                throw new ConfigException(name, value, "This configuration shouldn't be set directly. See the documentation about how to configure topic based overrides.\nThe overrides configuration allows for per topic customization of configuration. The customized overrides are merged with the default configuration, to create the specific configuration for a topic.\nFor example, ``topic.override.foo.collection=bar`` will store data from the ``foo`` topic into the ``bar`` collection.\nNote: All configuration options apart from 'connection.uri' and 'topics' are overridable.");
            }
        });
    }

    public static ValidatorWithOperators errorCheckingValueValidator(String validValuesString, Consumer<String> consumer) {
        return Validators.withStringDef(validValuesString, (name, value) -> {
            try {
                consumer.accept((String)value);
            }
            catch (Exception e) {
                throw new ConfigException(name, value, e.getMessage());
            }
        });
    }

    public static ValidatorWithOperators withStringDef(final String validatorString, final ConfigDef.Validator validator) {
        return new ValidatorWithOperators(){

            @Override
            public void ensureValid(String name, Object value) {
                validator.ensureValid(name, value);
            }

            public String toString() {
                return validatorString;
            }
        };
    }

    private Validators() {
    }

    public static final class EnumValidatorAndRecommender
    implements ValidatorWithOperators,
    ConfigDef.Recommender {
        private final List<String> values;

        private EnumValidatorAndRecommender(List<String> values) {
            this.values = values;
        }

        public static <E> EnumValidatorAndRecommender in(E[] enumerators) {
            return EnumValidatorAndRecommender.in(enumerators, Object::toString);
        }

        public static <E> EnumValidatorAndRecommender in(E[] enumerators, Function<E, String> mapper) {
            ArrayList<String> values = new ArrayList<String>(enumerators.length);
            for (E e : enumerators) {
                values.add(mapper.apply(e).toLowerCase(Locale.ROOT));
            }
            return new EnumValidatorAndRecommender(values);
        }

        @Override
        public void ensureValid(String key, Object value) {
            String enumValue = (String)value;
            if (!this.values.contains(enumValue.toLowerCase(Locale.ROOT))) {
                throw new ConfigException(key, value, String.format("Invalid enumerator value. Should be one of: %s", this.values));
            }
        }

        public String toString() {
            return this.values.toString();
        }

        @Override
        public List<Object> validValues(String name, Map<String, Object> parsedConfig) {
            return new ArrayList<Object>(this.values);
        }

        @Override
        public boolean visible(String name, Map<String, Object> parsedConfig) {
            return true;
        }
    }

    public static interface ValidatorWithOperators
    extends ConfigDef.Validator {
        default public ValidatorWithOperators or(ValidatorWithOperators other) {
            return Validators.withStringDef(String.format("%s OR %s", this.toString(), other.toString()), (name, value) -> {
                try {
                    this.ensureValid(name, value);
                }
                catch (ConfigException e) {
                    other.ensureValid(name, value);
                }
            });
        }
    }
}

