/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.writemodel.strategy;

import com.mongodb.client.model.WriteModel;
import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDocument;

public final class WriteModelStrategyHelper {
    public static WriteModel<BsonDocument> createWriteModel(MongoSinkTopicConfig config, SinkDocument document) {
        if (document.getValueDoc().isPresent()) {
            return WriteModelStrategyHelper.createValueWriteModel(config, document);
        }
        if (document.getKeyDoc().isPresent()) {
            return WriteModelStrategyHelper.createKeyDeleteOneModel(config, document);
        }
        throw new DataException("Invalid Sink Record neither key doc nor value doc were present");
    }

    static WriteModel<BsonDocument> createValueWriteModel(MongoSinkTopicConfig config, SinkDocument sinkDocument) {
        try {
            return config.getWriteModelStrategy().createWriteModel(sinkDocument);
        }
        catch (Exception e) {
            if (e instanceof DataException) {
                throw e;
            }
            throw new DataException("Could not build the WriteModel.", e);
        }
    }

    static WriteModel<BsonDocument> createKeyDeleteOneModel(MongoSinkTopicConfig config, SinkDocument sinkDocument) {
        try {
            return config.getDeleteOneWriteModelStrategy().map(s -> s.createWriteModel(sinkDocument)).orElseThrow(() -> new DataException("Could not create write model"));
        }
        catch (Exception e) {
            throw new DataException("Could not create write model", e);
        }
    }

    private WriteModelStrategyHelper() {
    }
}

