/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.writemodel.strategy;

import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.kafka.connect.sink.Configurable;
import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import com.mongodb.kafka.connect.sink.processor.id.strategy.IdStrategy;
import com.mongodb.kafka.connect.sink.processor.id.strategy.PartialKeyStrategy;
import com.mongodb.kafka.connect.sink.processor.id.strategy.PartialValueStrategy;
import com.mongodb.kafka.connect.sink.writemodel.strategy.WriteModelHelper;
import com.mongodb.kafka.connect.sink.writemodel.strategy.WriteModelStrategy;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDateTime;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

public class UpdateOneBusinessKeyTimestampStrategy
implements WriteModelStrategy,
Configurable {
    private static final UpdateOptions UPDATE_OPTIONS = new UpdateOptions().upsert(true);
    static final String FIELD_NAME_MODIFIED_TS = "_modifiedTS";
    static final String FIELD_NAME_INSERTED_TS = "_insertedTS";
    private boolean isPartialId = false;

    @Override
    public WriteModel<BsonDocument> createWriteModel(SinkDocument document) {
        BsonDocument vd = document.getValueDoc().orElseThrow(() -> new DataException("Could not build the WriteModel,the value document was missing unexpectedly"));
        BsonValue idValue = vd.get("_id");
        if (idValue == null || !idValue.isDocument()) {
            throw new DataException("Could not build the WriteModel,the value document does not contain an _id field of type BsonDocument which holds the business key fields.\n\n If you are including an existing `_id` value in the business key then ensure `document.id.strategy.overwrite.existing=true`.");
        }
        BsonDateTime dateTime = new BsonDateTime(System.currentTimeMillis());
        BsonDocument businessKey = idValue.asDocument();
        vd.remove("_id");
        if (this.isPartialId) {
            businessKey = WriteModelHelper.flattenKeys(businessKey);
        }
        return new UpdateOneModel<BsonDocument>((Bson)businessKey, new BsonDocument("$set", vd.append(FIELD_NAME_MODIFIED_TS, dateTime)).append("$setOnInsert", new BsonDocument(FIELD_NAME_INSERTED_TS, dateTime)), UPDATE_OPTIONS);
    }

    @Override
    public void configure(MongoSinkTopicConfig configuration) {
        IdStrategy idStrategy = configuration.getIdStrategy();
        this.isPartialId = idStrategy instanceof PartialKeyStrategy || idStrategy instanceof PartialValueStrategy;
    }
}

