/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.hbase.sink;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.hbase.sink.HBaseMutationConverter;
import org.apache.flink.connector.hbase.util.HBaseConfigurationUtil;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.TableName;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Connection;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.runtime.util.ExecutorThreadFactory;
import org.apache.flink.streaming.api.checkpoint.CheckpointedFunction;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.util.StringUtils;
import org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.metric.SinkMetricData;
import org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.metric.ThreadSafeCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class HBaseSinkFunction<T>
extends RichSinkFunction<T>
implements CheckpointedFunction,
BufferedMutator.ExceptionListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(HBaseSinkFunction.class);
    private final String hTableName;
    private final byte[] serializedConfig;
    private final long bufferFlushMaxSizeInBytes;
    private final long bufferFlushMaxMutations;
    private final long bufferFlushIntervalMillis;
    private final HBaseMutationConverter<T> mutationConverter;
    private final String inlongMetric;
    private final String inlongAudit;
    private final AtomicReference<Throwable> failureThrowable = new AtomicReference();
    private transient Connection connection;
    private transient BufferedMutator mutator;
    private transient ScheduledExecutorService executor;
    private transient ScheduledFuture scheduledFuture;
    private transient AtomicLong numPendingRequests;
    private transient RuntimeContext runtimeContext;
    private volatile transient boolean closed = false;
    private SinkMetricData sinkMetricData;
    private Long dataSize = 0L;
    private Long rowSize = 0L;

    public HBaseSinkFunction(String hTableName, org.apache.hadoop.conf.Configuration conf, HBaseMutationConverter<T> mutationConverter, long bufferFlushMaxSizeInBytes, long bufferFlushMaxMutations, long bufferFlushIntervalMillis, String inlongMetric, String inlongAudit) {
        this.hTableName = hTableName;
        this.serializedConfig = HBaseConfigurationUtil.serializeConfiguration(conf);
        this.mutationConverter = mutationConverter;
        this.bufferFlushMaxSizeInBytes = bufferFlushMaxSizeInBytes;
        this.bufferFlushMaxMutations = bufferFlushMaxMutations;
        this.bufferFlushIntervalMillis = bufferFlushIntervalMillis;
        this.inlongMetric = inlongMetric;
        this.inlongAudit = inlongAudit;
    }

    public void open(Configuration parameters) throws Exception {
        LOG.info("start open ...");
        org.apache.hadoop.conf.Configuration config = this.prepareRuntimeConfiguration();
        try {
            this.runtimeContext = this.getRuntimeContext();
            if (this.inlongMetric != null && !this.inlongMetric.isEmpty()) {
                String[] inlongMetricArray = this.inlongMetric.split("&");
                String groupId = inlongMetricArray[0];
                String streamId = inlongMetricArray[1];
                String nodeId = inlongMetricArray[2];
                this.sinkMetricData = new SinkMetricData(groupId, streamId, nodeId, this.runtimeContext.getMetricGroup(), this.inlongAudit);
                this.sinkMetricData.registerMetricsForDirtyBytes(new ThreadSafeCounter());
                this.sinkMetricData.registerMetricsForDirtyRecords(new ThreadSafeCounter());
                this.sinkMetricData.registerMetricsForNumBytesOut(new ThreadSafeCounter());
                this.sinkMetricData.registerMetricsForNumRecordsOut(new ThreadSafeCounter());
                this.sinkMetricData.registerMetricsForNumBytesOutPerSecond();
                this.sinkMetricData.registerMetricsForNumRecordsOutPerSecond();
            }
            this.mutationConverter.open();
            this.numPendingRequests = new AtomicLong(0L);
            if (null == this.connection) {
                this.connection = ConnectionFactory.createConnection(config);
            }
            BufferedMutatorParams params = new BufferedMutatorParams(TableName.valueOf(this.hTableName)).listener(this);
            if (this.bufferFlushMaxSizeInBytes > 0L) {
                params.writeBufferSize(this.bufferFlushMaxSizeInBytes);
            }
            this.mutator = this.connection.getBufferedMutator(params);
            if (this.bufferFlushIntervalMillis > 0L && this.bufferFlushMaxMutations != 1L) {
                this.executor = Executors.newScheduledThreadPool(1, (ThreadFactory)new ExecutorThreadFactory("hbase-upsert-sink-flusher"));
                this.scheduledFuture = this.executor.scheduleWithFixedDelay(() -> {
                    if (this.closed) {
                        return;
                    }
                    try {
                        this.flush();
                        this.sinkMetricData.invoke(this.rowSize, this.dataSize);
                        this.resetStateAfterFlush();
                    }
                    catch (Exception e) {
                        if (this.sinkMetricData.getDirtyRecords() != null) {
                            this.sinkMetricData.getDirtyRecords().inc(this.rowSize.longValue());
                        }
                        if (this.sinkMetricData.getDirtyBytes() != null) {
                            this.sinkMetricData.getDirtyBytes().inc(this.dataSize.longValue());
                        }
                        this.resetStateAfterFlush();
                        this.failureThrowable.compareAndSet(null, e);
                    }
                }, this.bufferFlushIntervalMillis, this.bufferFlushIntervalMillis, TimeUnit.MILLISECONDS);
            }
        }
        catch (TableNotFoundException tnfe) {
            LOG.error("The table " + this.hTableName + " not found ", (Throwable)tnfe);
            throw new RuntimeException("HBase table '" + this.hTableName + "' not found.", tnfe);
        }
        catch (IOException ioe) {
            LOG.error("Exception while creating connection to HBase.", (Throwable)ioe);
            throw new RuntimeException("Cannot create connection to HBase.", ioe);
        }
        LOG.info("end open.");
    }

    private org.apache.hadoop.conf.Configuration prepareRuntimeConfiguration() throws IOException {
        org.apache.hadoop.conf.Configuration runtimeConfig = HBaseConfigurationUtil.deserializeConfiguration(this.serializedConfig, HBaseConfigurationUtil.getHBaseConfiguration());
        if (StringUtils.isNullOrWhitespaceOnly((String)runtimeConfig.get("hbase.zookeeper.quorum"))) {
            LOG.error("Can not connect to HBase without {} configuration", (Object)"hbase.zookeeper.quorum");
            throw new IOException("Check HBase configuration failed, lost: 'hbase.zookeeper.quorum'!");
        }
        return runtimeConfig;
    }

    private void checkErrorAndRethrow() {
        Throwable cause = this.failureThrowable.get();
        if (cause != null) {
            throw new RuntimeException("An error occurred in HBaseSink.", cause);
        }
    }

    public void invoke(T value, SinkFunction.Context context) throws Exception {
        this.checkErrorAndRethrow();
        this.mutator.mutate(this.mutationConverter.convertToMutation(value));
        Long l = this.rowSize;
        Long l2 = this.rowSize = Long.valueOf(this.rowSize + 1L);
        this.dataSize = this.dataSize + (long)value.toString().getBytes(StandardCharsets.UTF_8).length;
        if (this.bufferFlushMaxMutations > 0L && this.numPendingRequests.incrementAndGet() >= this.bufferFlushMaxMutations) {
            try {
                this.flush();
                this.sinkMetricData.invoke(this.rowSize, this.dataSize);
                this.resetStateAfterFlush();
            }
            catch (Exception e) {
                if (this.sinkMetricData.getDirtyRecords() != null) {
                    this.sinkMetricData.getDirtyRecords().inc(this.rowSize.longValue());
                }
                if (this.sinkMetricData.getDirtyBytes() != null) {
                    this.sinkMetricData.getDirtyBytes().inc(this.dataSize.longValue());
                }
                this.resetStateAfterFlush();
                throw e;
            }
        }
    }

    private void resetStateAfterFlush() {
        this.dataSize = 0L;
        this.rowSize = 0L;
    }

    private void flush() throws IOException {
        this.mutator.flush();
        this.numPendingRequests.set(0L);
        this.checkErrorAndRethrow();
    }

    public void close() throws Exception {
        this.closed = true;
        if (this.mutator != null) {
            try {
                this.mutator.close();
            }
            catch (IOException e) {
                LOG.warn("Exception occurs while closing HBase BufferedMutator.", (Throwable)e);
            }
            this.mutator = null;
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException e) {
                LOG.warn("Exception occurs while closing HBase Connection.", (Throwable)e);
            }
            this.connection = null;
        }
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
            if (this.executor != null) {
                this.executor.shutdownNow();
            }
        }
    }

    public void snapshotState(FunctionSnapshotContext context) throws Exception {
        while (this.numPendingRequests.get() != 0L) {
            this.flush();
        }
    }

    public void initializeState(FunctionInitializationContext context) throws Exception {
    }

    @Override
    public void onException(RetriesExhaustedWithDetailsException exception, BufferedMutator mutator) throws RetriesExhaustedWithDetailsException {
        this.failureThrowable.compareAndSet(null, exception);
    }
}

