/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.metric;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nullable;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.inlong.audit.AuditImp;
import org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.Constants;
import org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.metric.MetricData;

public class SinkMetricData
implements MetricData {
    private final MetricGroup metricGroup;
    private final String groupId;
    private final String streamId;
    private final String nodeId;
    private AuditImp auditImp;
    private Counter numRecordsOut;
    private Counter numBytesOut;
    private Counter dirtyRecords;
    private Counter dirtyBytes;
    private Meter numRecordsOutPerSecond;
    private Meter numBytesOutPerSecond;

    public SinkMetricData(String groupId, String streamId, String nodeId, MetricGroup metricGroup) {
        this.metricGroup = metricGroup;
        this.groupId = groupId;
        this.streamId = streamId;
        this.nodeId = nodeId;
    }

    public SinkMetricData(String groupId, String streamId, String nodeId, MetricGroup metricGroup, @Nullable String auditHostAndPorts) {
        this.metricGroup = metricGroup;
        this.groupId = groupId;
        this.streamId = streamId;
        this.nodeId = nodeId;
        if (auditHostAndPorts != null) {
            AuditImp.getInstance().setAuditProxy(new HashSet<String>(Arrays.asList(auditHostAndPorts.split("&"))));
            this.auditImp = AuditImp.getInstance();
        }
    }

    public void registerMetricsForNumRecordsOut() {
        this.registerMetricsForNumRecordsOut((Counter)new SimpleCounter());
    }

    public void registerMetricsForNumRecordsOut(Counter counter) {
        this.numRecordsOut = this.registerCounter("numRecordsOut", counter);
    }

    public void registerMetricsForNumBytesOut() {
        this.registerMetricsForNumBytesOut((Counter)new SimpleCounter());
    }

    public void registerMetricsForNumBytesOut(Counter counter) {
        this.numBytesOut = this.registerCounter("numBytesOut", counter);
    }

    public void registerMetricsForNumRecordsOutPerSecond() {
        this.numRecordsOutPerSecond = this.registerMeter("numRecordsOutPerSecond", this.numRecordsOut);
    }

    public void registerMetricsForNumBytesOutPerSecond() {
        this.numBytesOutPerSecond = this.registerMeter("numBytesOutPerSecond", this.numBytesOut);
    }

    public void registerMetricsForDirtyRecords() {
        this.registerMetricsForDirtyRecords((Counter)new SimpleCounter());
    }

    public void registerMetricsForDirtyRecords(Counter counter) {
        this.dirtyRecords = this.registerCounter("dirtyRecords", counter);
    }

    public void registerMetricsForDirtyBytes() {
        this.registerMetricsForDirtyBytes((Counter)new SimpleCounter());
    }

    public void registerMetricsForDirtyBytes(Counter counter) {
        this.dirtyBytes = this.registerCounter("dirtyBytes", counter);
    }

    public Counter getNumRecordsOut() {
        return this.numRecordsOut;
    }

    public Counter getNumBytesOut() {
        return this.numBytesOut;
    }

    public Counter getDirtyRecords() {
        return this.dirtyRecords;
    }

    public Counter getDirtyBytes() {
        return this.dirtyBytes;
    }

    public Meter getNumRecordsOutPerSecond() {
        return this.numRecordsOutPerSecond;
    }

    public Meter getNumBytesOutPerSecond() {
        return this.numBytesOutPerSecond;
    }

    @Override
    public MetricGroup getMetricGroup() {
        return this.metricGroup;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getStreamId() {
        return this.streamId;
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    public void invokeWithEstimate(Object o) {
        long size = o.toString().getBytes(StandardCharsets.UTF_8).length;
        this.getNumRecordsOut().inc();
        this.getNumBytesOut().inc(size);
        if (this.auditImp != null) {
            this.auditImp.add(Constants.AUDIT_SORT_OUTPUT, this.getGroupId(), this.getStreamId(), System.currentTimeMillis(), 1L, size);
        }
    }

    public void invoke(long rowCount, long rowSize) {
        this.getNumRecordsOut().inc(rowCount);
        this.getNumBytesOut().inc(rowSize);
        if (this.auditImp != null) {
            this.auditImp.add(Constants.AUDIT_SORT_OUTPUT, this.getGroupId(), this.getStreamId(), System.currentTimeMillis(), rowCount, rowSize);
        }
    }
}

