/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.send;

import org.apache.flink.hbase.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.hbase.shaded.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.inlong.audit.send.SenderManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderHandler
extends SimpleChannelInboundHandler<byte[]> {
    private static final Logger logger = LoggerFactory.getLogger(SenderHandler.class);
    private SenderManager manager;

    public SenderHandler(SenderManager manager) {
        this.manager = manager;
    }

    @Override
    public void channelRead0(ChannelHandlerContext ctx, byte[] e) {
        try {
            this.manager.onMessageReceived(ctx, e);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage());
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        try {
            this.manager.onExceptionCaught(ctx, e);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage());
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            super.channelInactive(ctx);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage());
        }
    }

    @Override
    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        try {
            super.channelUnregistered(ctx);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage());
        }
    }
}

