/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.inlong.audit.protocol.AuditApi;
import org.apache.inlong.audit.send.SenderManager;
import org.apache.inlong.audit.util.AuditConfig;
import org.apache.inlong.audit.util.Config;
import org.apache.inlong.audit.util.StatInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditImp {
    private static final Logger logger = LoggerFactory.getLogger(AuditImp.class);
    private static AuditImp auditImp = new AuditImp();
    private static final String FIELD_SEPARATORS = ":";
    private ConcurrentHashMap<String, StatInfo> countMap = new ConcurrentHashMap();
    private HashMap<String, StatInfo> threadSumMap = new HashMap();
    private ConcurrentHashMap<String, StatInfo> deleteCountMap = new ConcurrentHashMap();
    private List<String> deleteKeyList = new ArrayList<String>();
    private AuditConfig auditConfig = null;
    private Config config = new Config();
    private Long sdkTime;
    private int packageId = 1;
    private int dataId = 0;
    private static final int BATCH_NUM = 100;
    boolean inited = false;
    private SenderManager manager;
    private static ReentrantLock globalLock = new ReentrantLock();
    private static int PERIOD = 60000;
    private Timer timer = new Timer();
    private TimerTask timerTask = new TimerTask(){

        @Override
        public void run() {
            try {
                AuditImp.this.sendReport();
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
    };

    public static AuditImp getInstance() {
        return auditImp;
    }

    private void init() {
        if (this.inited) {
            return;
        }
        this.config.init();
        this.timer.schedule(this.timerTask, PERIOD, (long)PERIOD);
        if (this.auditConfig == null) {
            this.auditConfig = new AuditConfig();
        }
        this.manager = new SenderManager(this.auditConfig);
    }

    public void setAuditProxy(HashSet<String> ipPortList) {
        try {
            globalLock.lockInterruptibly();
            if (!this.inited) {
                this.init();
                this.inited = true;
            }
            this.manager.setAuditProxy(ipPortList);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage());
        }
        finally {
            globalLock.unlock();
        }
    }

    public void setAuditConfig(AuditConfig config) {
        this.auditConfig = config;
        this.manager.setAuditConfig(config);
    }

    public void add(int auditID, String inlongGroupID, String inlongStreamID, Long logTime, long count, long size) {
        long delayTime = System.currentTimeMillis() - logTime;
        String key = logTime / (long)PERIOD + FIELD_SEPARATORS + inlongGroupID + FIELD_SEPARATORS + inlongStreamID + FIELD_SEPARATORS + auditID;
        this.addByKey(key, count, size, delayTime);
    }

    private void addByKey(String key, long count, long size, long delayTime) {
        try {
            if (this.countMap.get(key) == null) {
                this.countMap.put(key, new StatInfo(0L, 0L, 0L));
            }
            this.countMap.get((Object)key).count.addAndGet(count);
            this.countMap.get((Object)key).size.addAndGet(size);
            this.countMap.get((Object)key).delay.addAndGet(delayTime * count);
        }
        catch (Exception e) {
            return;
        }
    }

    public synchronized void sendReport() {
        this.manager.clearBuffer();
        this.resetStat();
        for (Map.Entry<String, StatInfo> entry : this.deleteCountMap.entrySet()) {
            this.sumThreadGroup(entry.getKey(), entry.getValue());
        }
        this.deleteCountMap.clear();
        for (Map.Entry<String, StatInfo> entry : this.countMap.entrySet()) {
            String key = entry.getKey();
            StatInfo value = entry.getValue();
            if (value.count.get() == 0L) {
                this.deleteKeyList.add(key);
                continue;
            }
            this.sumThreadGroup(key, value);
        }
        for (String key : this.deleteKeyList) {
            StatInfo value = this.countMap.remove(key);
            this.deleteCountMap.put(key, value);
        }
        this.deleteKeyList.clear();
        this.sdkTime = Calendar.getInstance().getTimeInMillis();
        AuditApi.AuditMessageHeader mssageHeader = AuditApi.AuditMessageHeader.newBuilder().setIp(this.config.getLocalIP()).setDockerId(this.config.getDockerId()).setThreadId(String.valueOf(Thread.currentThread().getId())).setSdkTs(this.sdkTime).setPacketId(this.packageId).build();
        AuditApi.AuditRequest.Builder requestBulid = AuditApi.AuditRequest.newBuilder();
        requestBulid.setMsgHeader(mssageHeader).setRequestId(this.manager.nextRequestId());
        for (Map.Entry<String, StatInfo> entry : this.threadSumMap.entrySet()) {
            String[] keyArray = entry.getKey().split(FIELD_SEPARATORS);
            long logTime = Long.parseLong(keyArray[0]) * (long)PERIOD;
            String inlongGroupID = keyArray[1];
            String inlongStreamID = keyArray[2];
            String auditID = keyArray[3];
            StatInfo value = entry.getValue();
            AuditApi.AuditMessageBody mssageBody = AuditApi.AuditMessageBody.newBuilder().setLogTs(logTime).setInlongGroupId(inlongGroupID).setInlongStreamId(inlongStreamID).setAuditId(auditID).setCount(value.count.get()).setSize(value.size.get()).setDelay(value.delay.get()).build();
            requestBulid.addMsgBody(mssageBody);
            if (this.dataId++ < 100) continue;
            this.dataId = 0;
            ++this.packageId;
            this.sendByBaseCommand(this.sdkTime, requestBulid.build());
            requestBulid.clearMsgBody();
        }
        if (requestBulid.getMsgBodyCount() > 0) {
            this.sendByBaseCommand(this.sdkTime, requestBulid.build());
            requestBulid.clearMsgBody();
        }
        this.threadSumMap.clear();
        logger.info("finish send report.");
    }

    private void sendByBaseCommand(long sdkTime, AuditApi.AuditRequest auditRequest) {
        AuditApi.BaseCommand.Builder baseCommand = AuditApi.BaseCommand.newBuilder();
        baseCommand.setType(AuditApi.BaseCommand.Type.AUDITREQUEST).setAuditRequest(auditRequest).build();
        this.manager.send(sdkTime, baseCommand.build());
    }

    private void sumThreadGroup(String key, StatInfo statInfo) {
        long count = statInfo.count.getAndSet(0L);
        if (0L == count) {
            return;
        }
        if (this.threadSumMap.get(key) == null) {
            this.threadSumMap.put(key, new StatInfo(0L, 0L, 0L));
        }
        long size = statInfo.size.getAndSet(0L);
        long delay = statInfo.delay.getAndSet(0L);
        this.threadSumMap.get((Object)key).count.addAndGet(count);
        this.threadSumMap.get((Object)key).size.addAndGet(size);
        this.threadSumMap.get((Object)key).delay.addAndGet(delay);
    }

    private void resetStat() {
        this.dataId = 0;
        this.packageId = 1;
    }
}

