/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class ServerSideScanMetrics {
    private final Map<String, AtomicLong> counters = new HashMap<String, AtomicLong>();
    public static final String COUNT_OF_ROWS_SCANNED_KEY_METRIC_NAME = "ROWS_SCANNED";
    public static final String COUNT_OF_ROWS_FILTERED_KEY_METRIC_NAME = "ROWS_FILTERED";
    @Deprecated
    public static final String COUNT_OF_ROWS_SCANNED_KEY = "ROWS_SCANNED";
    @Deprecated
    public static final String COUNT_OF_ROWS_FILTERED_KEY = "ROWS_FILTERED";
    public final AtomicLong countOfRowsFiltered = this.createCounter("ROWS_FILTERED");
    public final AtomicLong countOfRowsScanned = this.createCounter("ROWS_SCANNED");

    protected AtomicLong createCounter(String counterName) {
        AtomicLong c = new AtomicLong(0L);
        this.counters.put(counterName, c);
        return c;
    }

    public void setCounter(String counterName, long value) {
        AtomicLong c = this.counters.get(counterName);
        if (c != null) {
            c.set(value);
        }
    }

    public boolean hasCounter(String counterName) {
        return this.counters.containsKey(counterName);
    }

    public AtomicLong getCounter(String counterName) {
        return this.counters.get(counterName);
    }

    public void addToCounter(String counterName, long delta) {
        AtomicLong c = this.counters.get(counterName);
        if (c != null) {
            c.addAndGet(delta);
        }
    }

    public Map<String, Long> getMetricsMap() {
        return this.getMetricsMap(true);
    }

    public Map<String, Long> getMetricsMap(boolean reset) {
        ImmutableMap.Builder<String, Long> builder = ImmutableMap.builder();
        for (Map.Entry<String, AtomicLong> e : this.counters.entrySet()) {
            long value = reset ? e.getValue().getAndSet(0L) : e.getValue().get();
            builder.put(e.getKey(), value);
        }
        return builder.build();
    }
}

