/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.HConstants;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.ClientServiceCallable;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Connection;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Table;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.Token;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class SecureBulkLoadClient {
    private Table table;
    private final RpcControllerFactory rpcControllerFactory;

    public SecureBulkLoadClient(Configuration conf, Table table) {
        this.table = table;
        this.rpcControllerFactory = new RpcControllerFactory(conf);
    }

    public String prepareBulkLoad(Connection conn) throws IOException {
        try {
            ClientServiceCallable<String> callable = new ClientServiceCallable<String>(conn, this.table.getName(), HConstants.EMPTY_START_ROW, (RpcController)this.rpcControllerFactory.newController(), -1){

                @Override
                protected String rpcCall() throws Exception {
                    byte[] regionName = this.getLocation().getRegionInfo().getRegionName();
                    HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
                    ClientProtos.PrepareBulkLoadRequest request = ClientProtos.PrepareBulkLoadRequest.newBuilder().setTableName(ProtobufUtil.toProtoTableName(SecureBulkLoadClient.this.table.getName())).setRegion(region).build();
                    ClientProtos.PrepareBulkLoadResponse response = ((ClientProtos.ClientService.BlockingInterface)this.getStub()).prepareBulkLoad(null, request);
                    return response.getBulkToken();
                }
            };
            return RpcRetryingCallerFactory.instantiate(conn.getConfiguration(), null).newCaller().callWithRetries(callable, Integer.MAX_VALUE);
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    public void cleanupBulkLoad(Connection conn, final String bulkToken) throws IOException {
        try {
            ClientServiceCallable<Void> callable = new ClientServiceCallable<Void>(conn, this.table.getName(), HConstants.EMPTY_START_ROW, (RpcController)this.rpcControllerFactory.newController(), -1){

                @Override
                protected Void rpcCall() throws Exception {
                    byte[] regionName = this.getLocation().getRegionInfo().getRegionName();
                    HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
                    ClientProtos.CleanupBulkLoadRequest request = ClientProtos.CleanupBulkLoadRequest.newBuilder().setRegion(region).setBulkToken(bulkToken).build();
                    ((ClientProtos.ClientService.BlockingInterface)this.getStub()).cleanupBulkLoad(null, request);
                    return null;
                }
            };
            RpcRetryingCallerFactory.instantiate(conn.getConfiguration(), null).newCaller().callWithRetries(callable, Integer.MAX_VALUE);
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    public boolean secureBulkLoadHFiles(ClientProtos.ClientService.BlockingInterface client, List<Pair<byte[], String>> familyPaths, byte[] regionName, boolean assignSeqNum, Token<?> userToken, String bulkToken) throws IOException {
        return this.secureBulkLoadHFiles(client, familyPaths, regionName, assignSeqNum, userToken, bulkToken, false, null, true);
    }

    public boolean secureBulkLoadHFiles(ClientProtos.ClientService.BlockingInterface client, List<Pair<byte[], String>> familyPaths, byte[] regionName, boolean assignSeqNum, Token<?> userToken, String bulkToken, boolean copyFiles) throws IOException {
        return this.secureBulkLoadHFiles(client, familyPaths, regionName, assignSeqNum, userToken, bulkToken, false, null, true);
    }

    public boolean secureBulkLoadHFiles(ClientProtos.ClientService.BlockingInterface client, List<Pair<byte[], String>> familyPaths, byte[] regionName, boolean assignSeqNum, Token<?> userToken, String bulkToken, boolean copyFiles, List<String> clusterIds, boolean replicate) throws IOException {
        ClientProtos.BulkLoadHFileRequest request = RequestConverter.buildBulkLoadHFileRequest(familyPaths, regionName, assignSeqNum, userToken, bulkToken, copyFiles, clusterIds, replicate);
        try {
            ClientProtos.BulkLoadHFileResponse response = client.bulkLoadHFile(null, request);
            return response.getLoaded();
        }
        catch (Exception se) {
            throw ProtobufUtil.handleRemoteException(se);
        }
    }
}

