/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.commons.crypto.stream;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import org.apache.flink.hbase.shaded.org.apache.commons.crypto.cipher.CryptoCipher;
import org.apache.flink.hbase.shaded.org.apache.commons.crypto.cipher.CryptoCipherFactory;
import org.apache.flink.hbase.shaded.org.apache.commons.crypto.stream.CryptoInputStream;
import org.apache.flink.hbase.shaded.org.apache.commons.crypto.stream.CtrCryptoInputStream;
import org.apache.flink.hbase.shaded.org.apache.commons.crypto.stream.input.Input;
import org.apache.flink.hbase.shaded.org.apache.commons.crypto.utils.IoUtils;
import org.apache.flink.hbase.shaded.org.apache.commons.crypto.utils.Utils;

public class PositionedCryptoInputStream
extends CtrCryptoInputStream {
    private final Queue<ByteBuffer> bufferPool = new ConcurrentLinkedQueue<ByteBuffer>();
    private final Queue<CipherState> cipherPool = new ConcurrentLinkedQueue<CipherState>();
    private final Properties props;

    public PositionedCryptoInputStream(Properties props, Input in, byte[] key, byte[] iv, long streamOffset) throws IOException {
        this(props, in, Utils.getCipherInstance("AES/CTR/NoPadding", props), CryptoInputStream.getBufferSize(props), key, iv, streamOffset);
    }

    protected PositionedCryptoInputStream(Properties props, Input input, CryptoCipher cipher, int bufferSize, byte[] key, byte[] iv, long streamOffset) throws IOException {
        super(input, cipher, bufferSize, key, iv, streamOffset);
        this.props = props;
    }

    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        this.checkStream();
        int n = this.input.read(position, buffer, offset, length);
        if (n > 0) {
            this.decrypt(position, buffer, offset, n);
        }
        return n;
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        this.checkStream();
        IoUtils.readFully(this.input, position, buffer, offset, length);
        if (length > 0) {
            this.decrypt(position, buffer, offset, length);
        }
    }

    public void readFully(long position, byte[] buffer) throws IOException {
        this.readFully(position, buffer, 0, buffer.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrypt(long position, byte[] buffer, int offset, int length) throws IOException {
        ByteBuffer inByteBuffer = this.getBuffer();
        ByteBuffer outByteBuffer = this.getBuffer();
        CipherState state = null;
        try {
            state = this.getCipherState();
            byte[] iv = (byte[])this.getInitIV().clone();
            this.resetCipher(state, position, iv);
            byte padding = this.getPadding(position);
            inByteBuffer.position(padding);
            int n = 0;
            while (n < length) {
                int toDecrypt = Math.min(length - n, inByteBuffer.remaining());
                inByteBuffer.put(buffer, offset + n, toDecrypt);
                this.decrypt(state, inByteBuffer, outByteBuffer, padding);
                outByteBuffer.get(buffer, offset + n, toDecrypt);
                padding = this.postDecryption(state, inByteBuffer, position + (long)(n += toDecrypt), iv);
            }
        }
        finally {
            this.returnBuffer(inByteBuffer);
            this.returnBuffer(outByteBuffer);
            this.returnCipherState(state);
        }
    }

    private void decrypt(CipherState state, ByteBuffer inByteBuffer, ByteBuffer outByteBuffer, byte padding) throws IOException {
        Utils.checkState(inByteBuffer.position() >= padding);
        if (inByteBuffer.position() == padding) {
            return;
        }
        inByteBuffer.flip();
        outByteBuffer.clear();
        this.decryptBuffer(state, inByteBuffer, outByteBuffer);
        inByteBuffer.clear();
        outByteBuffer.flip();
        if (padding > 0) {
            outByteBuffer.position(padding);
        }
    }

    private void decryptBuffer(CipherState state, ByteBuffer inByteBuffer, ByteBuffer outByteBuffer) throws IOException {
        int inputSize = inByteBuffer.remaining();
        try {
            int n = state.getCryptoCipher().update(inByteBuffer, outByteBuffer);
            if (n < inputSize) {
                state.getCryptoCipher().doFinal(inByteBuffer, outByteBuffer);
                state.reset(true);
            }
        }
        catch (ShortBufferException e) {
            throw new IOException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new IOException(e);
        }
        catch (BadPaddingException e) {
            throw new IOException(e);
        }
    }

    private byte postDecryption(CipherState state, ByteBuffer inByteBuffer, long position, byte[] iv) throws IOException {
        byte padding = 0;
        if (state.isReset()) {
            this.resetCipher(state, position, iv);
            padding = this.getPadding(position);
            inByteBuffer.position(padding);
        }
        return padding;
    }

    private void resetCipher(CipherState state, long position, byte[] iv) throws IOException {
        long counter = this.getCounter(position);
        CtrCryptoInputStream.calculateIV(this.getInitIV(), counter, iv);
        try {
            state.getCryptoCipher().init(2, this.key, new IvParameterSpec(iv));
        }
        catch (InvalidKeyException e) {
            throw new IOException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IOException(e);
        }
        state.reset(false);
    }

    private CipherState getCipherState() throws IOException {
        CipherState state = this.cipherPool.poll();
        if (state == null) {
            CryptoCipher cryptoCipher;
            try {
                cryptoCipher = CryptoCipherFactory.getCryptoCipher("AES/CTR/NoPadding", this.props);
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e);
            }
            state = new CipherState(cryptoCipher);
        }
        return state;
    }

    private void returnCipherState(CipherState state) {
        if (state != null) {
            this.cipherPool.add(state);
        }
    }

    private ByteBuffer getBuffer() {
        ByteBuffer buffer = this.bufferPool.poll();
        if (buffer == null) {
            buffer = ByteBuffer.allocateDirect(this.getBufferSize());
        }
        return buffer;
    }

    private void returnBuffer(ByteBuffer buf) {
        if (buf != null) {
            buf.clear();
            this.bufferPool.add(buf);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.isOpen()) {
            return;
        }
        this.cleanBufferPool();
        super.close();
    }

    private void cleanBufferPool() {
        ByteBuffer buf;
        while ((buf = this.bufferPool.poll()) != null) {
            CryptoInputStream.freeDirectBuffer(buf);
        }
    }

    private class CipherState {
        private CryptoCipher cryptoCipher;
        private boolean reset;

        public CipherState(CryptoCipher cipher) {
            this.cryptoCipher = cipher;
            this.reset = false;
        }

        public CryptoCipher getCryptoCipher() {
            return this.cryptoCipher;
        }

        public boolean isReset() {
            return this.reset;
        }

        public void reset(boolean reset) {
            this.reset = reset;
        }
    }
}

