/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase2.source;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.connector.hbase.util.HBaseReadWriteHelper;
import org.apache.flink.connector.hbase.util.HBaseTableSchema;
import org.apache.flink.connector.hbase2.source.AbstractTableInputFormat;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.TableName;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Result;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Scan;
import org.apache.flink.types.Row;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class HBaseRowInputFormat
extends AbstractTableInputFormat<Row>
implements ResultTypeQueryable<Row> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(HBaseRowInputFormat.class);
    private final String tableName;
    private final HBaseTableSchema schema;
    private transient HBaseReadWriteHelper readHelper;

    public HBaseRowInputFormat(Configuration conf, String tableName, HBaseTableSchema schema) {
        super(conf);
        this.tableName = tableName;
        this.schema = schema;
    }

    @Override
    public void initTable() throws IOException {
        this.readHelper = new HBaseReadWriteHelper(this.schema);
        if (this.table == null) {
            this.connectToTable();
        }
        if (this.table != null && this.scan == null) {
            this.scan = this.getScanner();
        }
    }

    @Override
    protected Scan getScanner() {
        return this.readHelper.createScan();
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    protected Row mapResultToOutType(Result res) {
        return this.readHelper.parseToRow(res);
    }

    private void connectToTable() throws IOException {
        try {
            if (this.connection == null) {
                this.connection = ConnectionFactory.createConnection(this.getHadoopConfiguration());
            }
            TableName name = TableName.valueOf(this.getTableName());
            this.table = this.connection.getTable(name);
            this.regionLocator = this.connection.getRegionLocator(name);
        }
        catch (TableNotFoundException tnfe) {
            LOG.error("The table " + this.tableName + " not found ", (Throwable)tnfe);
            throw new RuntimeException("HBase table '" + this.tableName + "' not found.", tnfe);
        }
    }

    public TypeInformation<Row> getProducedType() {
        String[] famNames = this.schema.getFamilyNames();
        TypeInformation[] typeInfos = new TypeInformation[famNames.length];
        int i = 0;
        for (String family : famNames) {
            typeInfos[i] = new RowTypeInfo(this.schema.getQualifierTypes(family), this.schema.getQualifierNames(family));
            ++i;
        }
        return new RowTypeInfo(typeInfos, famNames);
    }
}

