/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase2.sink;

import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.connector.hbase.options.HBaseWriteOptions;
import org.apache.flink.connector.hbase.sink.HBaseSinkFunction;
import org.apache.flink.connector.hbase.sink.LegacyMutationConverter;
import org.apache.flink.connector.hbase.util.HBaseTableSchema;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sinks.UpsertStreamTableSink;
import org.apache.flink.table.utils.TableConnectorUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;

@Internal
public class HBaseUpsertTableSink
implements UpsertStreamTableSink<Row> {
    private final HBaseTableSchema hbaseTableSchema;
    private final TableSchema tableSchema;
    private final Configuration hconf;
    private final HBaseWriteOptions writeOptions;
    private final String tableName;

    public HBaseUpsertTableSink(String tableName, HBaseTableSchema hbaseTableSchema, Configuration hconf, HBaseWriteOptions writeOptions) {
        Preconditions.checkArgument((boolean)hbaseTableSchema.getRowKeyName().isPresent(), (Object)"HBaseUpsertTableSink requires rowkey is set.");
        this.hbaseTableSchema = hbaseTableSchema;
        this.tableSchema = hbaseTableSchema.convertsToTableSchema();
        this.hconf = hconf;
        this.writeOptions = writeOptions;
        this.tableName = tableName;
    }

    public void setKeyFields(String[] keys) {
    }

    public void setIsAppendOnly(Boolean isAppendOnly) {
    }

    public TypeInformation<Row> getRecordType() {
        return this.tableSchema.toRowType();
    }

    public TableSchema getTableSchema() {
        return this.tableSchema;
    }

    public DataStreamSink<?> consumeDataStream(DataStream<Tuple2<Boolean, Row>> dataStream) {
        HBaseSinkFunction<Tuple2<Boolean, Row>> sinkFunction = new HBaseSinkFunction<Tuple2<Boolean, Row>>(this.tableName, this.hconf, new LegacyMutationConverter(this.hbaseTableSchema), this.writeOptions.getBufferFlushMaxSizeInBytes(), this.writeOptions.getBufferFlushMaxRows(), this.writeOptions.getBufferFlushIntervalMillis());
        return dataStream.addSink(sinkFunction).setParallelism(dataStream.getParallelism()).name(TableConnectorUtils.generateRuntimeName(this.getClass(), (String[])this.tableSchema.getFieldNames()));
    }

    public TableSink<Tuple2<Boolean, Row>> configure(String[] fieldNames, TypeInformation<?>[] fieldTypes) {
        if (!Arrays.equals(this.getFieldNames(), fieldNames) || !Arrays.equals(this.getFieldTypes(), fieldTypes)) {
            throw new ValidationException("Reconfiguration with different fields is not allowed. Expected: " + Arrays.toString(this.getFieldNames()) + " / " + Arrays.toString(this.getFieldTypes()) + ". But was: " + Arrays.toString(fieldNames) + " / " + Arrays.toString(fieldTypes));
        }
        return new HBaseUpsertTableSink(this.tableName, this.hbaseTableSchema, this.hconf, this.writeOptions);
    }

    @VisibleForTesting
    public HBaseTableSchema getHBaseTableSchema() {
        return this.hbaseTableSchema;
    }

    @VisibleForTesting
    public HBaseWriteOptions getWriteOptions() {
        return this.writeOptions;
    }
}

