/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase2;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.connector.hbase.options.HBaseWriteOptions;
import org.apache.flink.connector.hbase.util.HBaseConfigurationUtil;
import org.apache.flink.connector.hbase.util.HBaseTableSchema;
import org.apache.flink.connector.hbase2.HBaseValidator;
import org.apache.flink.connector.hbase2.sink.HBaseUpsertTableSink;
import org.apache.flink.connector.hbase2.source.HBaseTableSource;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.factories.StreamTableSinkFactory;
import org.apache.flink.table.factories.StreamTableSourceFactory;
import org.apache.flink.table.sinks.StreamTableSink;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.utils.TableSchemaUtils;
import org.apache.flink.types.Row;
import org.apache.hadoop.conf.Configuration;

@Internal
public class HBase2TableFactory
implements StreamTableSourceFactory<Row>,
StreamTableSinkFactory<Tuple2<Boolean, Row>> {
    public StreamTableSource<Row> createStreamTableSource(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = this.getValidatedProperties(properties);
        Configuration hbaseClientConf = HBase2TableFactory.getHBaseConf(descriptorProperties);
        String hTableName = descriptorProperties.getString("connector.table-name");
        TableSchema tableSchema = TableSchemaUtils.getPhysicalSchema((TableSchema)descriptorProperties.getTableSchema("schema"));
        HBaseTableSchema hbaseSchema = this.validateTableSchema(tableSchema);
        return new HBaseTableSource(hbaseClientConf, hTableName, hbaseSchema, null);
    }

    public StreamTableSink<Tuple2<Boolean, Row>> createStreamTableSink(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = this.getValidatedProperties(properties);
        TableSchema tableSchema = TableSchemaUtils.getPhysicalSchema((TableSchema)descriptorProperties.getTableSchema("schema"));
        HBaseTableSchema hbaseSchema = this.validateTableSchema(tableSchema);
        Configuration hbaseClientConf = HBase2TableFactory.getHBaseConf(descriptorProperties);
        HBaseWriteOptions.Builder writeBuilder = HBaseWriteOptions.builder();
        descriptorProperties.getOptionalInt("connector.write.buffer-flush.max-rows").ifPresent(writeBuilder::setBufferFlushMaxRows);
        descriptorProperties.getOptionalMemorySize("connector.write.buffer-flush.max-size").ifPresent(v -> writeBuilder.setBufferFlushMaxSizeInBytes(v.getBytes()));
        descriptorProperties.getOptionalDuration("connector.write.buffer-flush.interval").ifPresent(v -> writeBuilder.setBufferFlushIntervalMillis(v.toMillis()));
        return new HBaseUpsertTableSink(descriptorProperties.getString("connector.table-name"), hbaseSchema, hbaseClientConf, writeBuilder.build());
    }

    private HBaseTableSchema validateTableSchema(TableSchema schema) {
        HBaseTableSchema hbaseSchema = new HBaseTableSchema();
        String[] fieldNames = schema.getFieldNames();
        TypeInformation[] fieldTypes = schema.getFieldTypes();
        for (int i = 0; i < fieldNames.length; ++i) {
            String name = fieldNames[i];
            TypeInformation type = fieldTypes[i];
            if (type instanceof RowTypeInfo) {
                RowTypeInfo familyType = (RowTypeInfo)type;
                String[] qualifierNames = familyType.getFieldNames();
                TypeInformation[] qualifierTypes = familyType.getFieldTypes();
                for (int j = 0; j < familyType.getArity(); ++j) {
                    Class clazz = qualifierTypes[j].getTypeClass();
                    if (LocalDateTime.class.equals((Object)clazz)) {
                        clazz = Timestamp.class;
                    } else if (LocalDate.class.equals(clazz)) {
                        clazz = Date.class;
                    } else if (LocalTime.class.equals(clazz)) {
                        clazz = Time.class;
                    }
                    hbaseSchema.addColumn(name, qualifierNames[j], clazz);
                }
                continue;
            }
            hbaseSchema.setRowKey(name, type.getTypeClass());
        }
        return hbaseSchema;
    }

    private DescriptorProperties getValidatedProperties(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = new DescriptorProperties(true);
        descriptorProperties.putProperties(properties);
        new HBaseValidator().validate(descriptorProperties);
        return descriptorProperties;
    }

    public Map<String, String> requiredContext() {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("connector.type", "hbase");
        context.put("connector.version", this.hbaseVersion());
        context.put("connector.property-version", "1");
        return context;
    }

    public List<String> supportedProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("connector.version");
        properties.add("connector.table-name");
        properties.add("connector.zookeeper.quorum");
        properties.add("connector.zookeeper.znode.parent");
        properties.add("connector.write.buffer-flush.max-size");
        properties.add("connector.write.buffer-flush.max-rows");
        properties.add("connector.write.buffer-flush.interval");
        properties.add("schema.#.data-type");
        properties.add("schema.#.type");
        properties.add("schema.#.name");
        properties.add("schema.#.expr");
        properties.add("schema.watermark.#.rowtime");
        properties.add("schema.watermark.#.strategy.expr");
        properties.add("schema.watermark.#.strategy.data-type");
        properties.add("schema.primary-key.name");
        properties.add("schema.primary-key.columns");
        properties.add("comment");
        properties.add("connector.properties.*");
        return properties;
    }

    private String hbaseVersion() {
        return "2.2.3";
    }

    private static Configuration getHBaseConf(DescriptorProperties descriptorProperties) {
        Configuration hbaseClientConf = HBaseConfigurationUtil.createHBaseConf();
        descriptorProperties.getOptionalString("connector.zookeeper.quorum").ifPresent(zkQ -> hbaseClientConf.set("hbase.zookeeper.quorum", zkQ));
        descriptorProperties.getOptionalString("connector.zookeeper.znode.parent").ifPresent(v -> hbaseClientConf.set("zookeeper.znode.parent", v));
        descriptorProperties.getPropertiesWithPrefix("connector.properties").forEach((arg_0, arg_1) -> ((Configuration)hbaseClientConf).set(arg_0, arg_1));
        return hbaseClientConf;
    }
}

