/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.filesystem.stream;

import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.streaming.api.functions.sink.filesystem.Bucket;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketLifeCycleListener;
import org.apache.flink.streaming.api.functions.sink.filesystem.Buckets;
import org.apache.flink.streaming.api.functions.sink.filesystem.StreamingFileSink;
import org.apache.flink.streaming.api.functions.sink.filesystem.StreamingFileSinkHelper;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.metric.SinkMetricData;
import org.apache.inlong.sort.filesystem.shaded.org.apache.inlong.sort.base.metric.ThreadSafeCounter;

public abstract class AbstractStreamingWriter<IN, OUT>
extends AbstractStreamOperator<OUT>
implements OneInputStreamOperator<IN, OUT>,
BoundedOneInput {
    private static final long serialVersionUID = 1L;
    private final long bucketCheckInterval;
    private final StreamingFileSink.BucketsBuilder<IN, String, ? extends StreamingFileSink.BucketsBuilder<IN, String, ?>> bucketsBuilder;
    private String inlongMetric;
    private String inlongAudit;
    private transient Buckets<IN, String> buckets;
    private transient StreamingFileSinkHelper<IN> helper;
    private transient long currentWatermark;
    private SinkMetricData metricData;

    public AbstractStreamingWriter(long bucketCheckInterval, StreamingFileSink.BucketsBuilder<IN, String, ? extends StreamingFileSink.BucketsBuilder<IN, String, ?>> bucketsBuilder, String inlongMetric, String inlongAudit) {
        this.bucketCheckInterval = bucketCheckInterval;
        this.bucketsBuilder = bucketsBuilder;
        this.inlongMetric = inlongMetric;
        this.inlongAudit = inlongAudit;
        this.setChainingStrategy(ChainingStrategy.ALWAYS);
    }

    protected abstract void partitionCreated(String var1);

    protected abstract void partitionInactive(String var1);

    protected abstract void onPartFileOpened(String var1, Path var2);

    public void open() throws Exception {
        super.open();
        if (this.inlongMetric != null) {
            String[] inLongMetricArray = this.inlongMetric.split("&");
            String groupId = inLongMetricArray[0];
            String streamId = inLongMetricArray[1];
            String nodeId = inLongMetricArray[2];
            this.metricData = new SinkMetricData(groupId, streamId, nodeId, this.getRuntimeContext().getMetricGroup(), this.inlongAudit);
            this.metricData.registerMetricsForDirtyBytes(new ThreadSafeCounter());
            this.metricData.registerMetricsForDirtyRecords(new ThreadSafeCounter());
            this.metricData.registerMetricsForNumBytesOut(new ThreadSafeCounter());
            this.metricData.registerMetricsForNumRecordsOut(new ThreadSafeCounter());
            this.metricData.registerMetricsForNumBytesOutPerSecond();
            this.metricData.registerMetricsForNumRecordsOutPerSecond();
        }
    }

    protected void commitUpToCheckpoint(long checkpointId) throws Exception {
        this.helper.commitUpToCheckpoint(checkpointId);
    }

    public void initializeState(StateInitializationContext context) throws Exception {
        super.initializeState(context);
        this.buckets = this.bucketsBuilder.createBuckets(this.getRuntimeContext().getIndexOfThisSubtask());
        this.buckets.setBucketLifeCycleListener(new BucketLifeCycleListener<IN, String>(){

            public void bucketCreated(Bucket<IN, String> bucket) {
                AbstractStreamingWriter.this.partitionCreated((String)bucket.getBucketId());
            }

            public void bucketInactive(Bucket<IN, String> bucket) {
                AbstractStreamingWriter.this.partitionInactive((String)bucket.getBucketId());
            }
        });
        this.buckets.setFileLifeCycleListener(this::onPartFileOpened);
        this.helper = new StreamingFileSinkHelper(this.buckets, context.isRestored(), context.getOperatorStateStore(), this.getRuntimeContext().getProcessingTimeService(), this.bucketCheckInterval);
        this.currentWatermark = Long.MIN_VALUE;
    }

    public void snapshotState(StateSnapshotContext context) throws Exception {
        super.snapshotState(context);
        this.helper.snapshotState(context.getCheckpointId());
    }

    public void processWatermark(Watermark mark) throws Exception {
        super.processWatermark(mark);
        this.currentWatermark = mark.getTimestamp();
    }

    public void processElement(StreamRecord<IN> element) throws Exception {
        this.helper.onElement(element.getValue(), this.getProcessingTimeService().getCurrentProcessingTime(), element.hasTimestamp() ? Long.valueOf(element.getTimestamp()) : null, this.currentWatermark);
        if (this.metricData != null) {
            this.metricData.invokeWithEstimate(element.getValue());
        }
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
        super.notifyCheckpointComplete(checkpointId);
        this.commitUpToCheckpoint(checkpointId);
    }

    public void endInput() throws Exception {
        this.buckets.onProcessingTime(Long.MAX_VALUE);
        this.helper.snapshotState(Long.MAX_VALUE);
        this.output.emitWatermark(new Watermark(Long.MAX_VALUE));
        this.commitUpToCheckpoint(Long.MAX_VALUE);
    }

    public void dispose() throws Exception {
        super.dispose();
        if (this.helper != null) {
            this.helper.close();
        }
    }
}

