/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditConfig {
    private static final Logger logger = LoggerFactory.getLogger(AuditConfig.class);
    private static String FILE_PATH = "/data/inlong/audit/";
    private static final int FILE_SIZE = 524288000;
    private static final int MAX_CACHE_ROWS = 2000000;
    private static final int MIN_CACHE_ROWS = 100;
    private String filePath;
    private int maxCacheRow;
    private int maxFileSize = 524288000;
    private String disasterFileName = "disaster.data";

    public AuditConfig(String filePath, int maxCacheRow) {
        this.filePath = filePath == null || filePath.length() == 0 ? FILE_PATH : filePath;
        this.maxCacheRow = maxCacheRow < 100 ? 2000000 : maxCacheRow;
    }

    public AuditConfig() {
        this.filePath = FILE_PATH;
        this.maxCacheRow = 2000000;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setMaxCacheRow(int maxCacheRow) {
        this.maxCacheRow = maxCacheRow;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public int getMaxCacheRow() {
        return this.maxCacheRow;
    }

    public int getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(int maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public String getDisasterFile() {
        return this.filePath + "/" + this.disasterFileName;
    }
}

