/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.sqlserver.table;

import com.ververica.cdc.connectors.sqlserver.table.StartupOptions;
import com.ververica.cdc.debezium.table.DebeziumOptions;
import com.ververica.cdc.debezium.utils.ResolvedSchemaUtils;
import java.time.ZoneId;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.inlong.sort.base.Constants;
import org.apache.inlong.sort.cdc.sqlserver.table.SqlServerTableSource;

public class SqlServerTableFactory
implements DynamicTableSourceFactory {
    private static final String IDENTIFIER = "sqlserver-cdc-inlong";
    private static final ConfigOption<String> HOSTNAME = ConfigOptions.key((String)"hostname").stringType().noDefaultValue().withDescription("IP address or hostname of the SqlServer database server.");
    private static final ConfigOption<Integer> PORT = ConfigOptions.key((String)"port").intType().defaultValue((Object)1433).withDescription("Integer port number of the SqlServer database server.");
    private static final ConfigOption<String> USERNAME = ConfigOptions.key((String)"username").stringType().noDefaultValue().withDescription("Name of the SqlServer database to use when connecting to the SqlServer database server.");
    private static final ConfigOption<String> PASSWORD = ConfigOptions.key((String)"password").stringType().noDefaultValue().withDescription("Password to use when connecting to the SqlServer database server.");
    private static final ConfigOption<String> DATABASE_NAME = ConfigOptions.key((String)"database-name").stringType().noDefaultValue().withDescription("Database name of the SqlServer server to monitor.");
    private static final ConfigOption<String> SCHEMA_NAME = ConfigOptions.key((String)"schema-name").stringType().noDefaultValue().withDescription("Schema name of the SqlServer database to monitor.");
    private static final ConfigOption<String> TABLE_NAME = ConfigOptions.key((String)"table-name").stringType().noDefaultValue().withDescription("Table name of the SqlServer database to monitor.");
    public static final ConfigOption<String> SERVER_TIME_ZONE = ConfigOptions.key((String)"server-time-zone").stringType().defaultValue((Object)"UTC").withDescription("The session time zone in database server.");
    public static final ConfigOption<String> SCAN_STARTUP_MODE = ConfigOptions.key((String)"scan.startup.mode").stringType().defaultValue((Object)"initial").withDescription("Optional startup mode for SqlServer CDC consumer, valid enumerations are \"initial\", \"initial-only\", \"latest-offset\"");
    private static final String SCAN_STARTUP_MODE_VALUE_INITIAL = "initial";
    private static final String SCAN_STARTUP_MODE_VALUE_INITIAL_ONLY = "initial-only";
    private static final String SCAN_STARTUP_MODE_VALUE_LATEST = "latest-offset";

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        helper.validateExcept(new String[]{"debezium."});
        ReadableConfig config = helper.getOptions();
        String hostname = (String)config.get(HOSTNAME);
        String username = (String)config.get(USERNAME);
        String password = (String)config.get(PASSWORD);
        String schemaName = (String)config.get(SCHEMA_NAME);
        String databaseName = (String)config.get(DATABASE_NAME);
        String tableName = (String)config.get(TABLE_NAME);
        String inlongMetric = (String)config.get(Constants.INLONG_METRIC);
        String auditHostAndPorts = (String)config.get(Constants.INLONG_AUDIT);
        ZoneId serverTimeZone = ZoneId.of((String)config.get(SERVER_TIME_ZONE));
        int port = (Integer)config.get(PORT);
        StartupOptions startupOptions = SqlServerTableFactory.getStartupOptions(config);
        ResolvedSchema physicalSchema = ResolvedSchemaUtils.getPhysicalSchema(context.getCatalogTable().getResolvedSchema());
        return new SqlServerTableSource(physicalSchema, port, hostname, databaseName, schemaName, tableName, serverTimeZone, username, password, DebeziumOptions.getDebeziumProperties(context.getCatalogTable().getOptions()), startupOptions, inlongMetric, auditHostAndPorts);
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(HOSTNAME);
        options.add(USERNAME);
        options.add(PASSWORD);
        options.add(DATABASE_NAME);
        options.add(SCHEMA_NAME);
        options.add(TABLE_NAME);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(PORT);
        options.add(SERVER_TIME_ZONE);
        options.add(SCAN_STARTUP_MODE);
        options.add(Constants.INLONG_METRIC);
        options.add(Constants.INLONG_AUDIT);
        return options;
    }

    private static StartupOptions getStartupOptions(ReadableConfig config) {
        String modeString = (String)config.get(SCAN_STARTUP_MODE);
        switch (modeString.toLowerCase()) {
            case "initial": {
                return StartupOptions.initial();
            }
            case "initial-only": {
                return StartupOptions.initialOnly();
            }
            case "latest-offset": {
                return StartupOptions.latest();
            }
        }
        throw new ValidationException(String.format("Invalid value for option '%s'. Supported values are [%s, %s, %s], but was: %s", SCAN_STARTUP_MODE.key(), SCAN_STARTUP_MODE_VALUE_INITIAL, SCAN_STARTUP_MODE_VALUE_INITIAL_ONLY, SCAN_STARTUP_MODE_VALUE_LATEST, modeString));
    }
}

