/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.jdbc;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.ConnectException;
import io.debezium.DebeziumException;
import io.debezium.annotation.NotThreadSafe;
import io.debezium.annotation.ThreadSafe;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.util.BoundedConcurrentHashMap;
import io.debezium.util.Collect;
import io.debezium.util.Strings;
import java.lang.reflect.InvocationTargetException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class JdbcConnection
implements AutoCloseable {
    private static final int WAIT_FOR_CLOSE_SECONDS = 10;
    private static final char STATEMENT_DELIMITER = ';';
    private static final int STATEMENT_CACHE_CAPACITY = 10000;
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcConnection.class);
    private final Map<String, PreparedStatement> statementCache = new BoundedConcurrentHashMap<String, PreparedStatement>(10000, 16, BoundedConcurrentHashMap.Eviction.LIRS, new BoundedConcurrentHashMap.EvictionListener<String, PreparedStatement>(){

        @Override
        public void onEntryEviction(Map<String, PreparedStatement> evicted) {
        }

        @Override
        public void onEntryChosenForEviction(PreparedStatement statement) {
            JdbcConnection.this.cleanupPreparedStatement(statement);
        }
    });
    private final Configuration config;
    private final ConnectionFactory factory;
    private final Operations initialOps;
    private volatile Connection conn;

    public static ConnectionFactory patternBasedFactory(String urlPattern, Field ... variables) {
        return config -> {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Config: {}", (Object)JdbcConnection.propsWithMaskedPassword(config.asProperties()));
            }
            Properties props = config.asProperties();
            Field[] varsWithDefaults = JdbcConnection.combineVariables(variables, JdbcConfiguration.HOSTNAME, JdbcConfiguration.PORT, JdbcConfiguration.USER, JdbcConfiguration.PASSWORD, JdbcConfiguration.DATABASE);
            String url = JdbcConnection.findAndReplace(urlPattern, props, varsWithDefaults);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Props: {}", (Object)JdbcConnection.propsWithMaskedPassword(props));
            }
            LOGGER.trace("URL: {}", (Object)url);
            Connection conn = DriverManager.getConnection(url, props);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Connected to {} with {}", (Object)url, (Object)JdbcConnection.propsWithMaskedPassword(props));
            }
            return conn;
        };
    }

    public static ConnectionFactory patternBasedFactory(String urlPattern, String driverClassName, ClassLoader classloader, Field ... variables) {
        return config -> {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Config: {}", (Object)JdbcConnection.propsWithMaskedPassword(config.asProperties()));
            }
            Properties props = config.asProperties();
            Field[] varsWithDefaults = JdbcConnection.combineVariables(variables, JdbcConfiguration.HOSTNAME, JdbcConfiguration.PORT, JdbcConfiguration.USER, JdbcConfiguration.PASSWORD, JdbcConfiguration.DATABASE);
            String url = JdbcConnection.findAndReplace(urlPattern, props, varsWithDefaults);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Props: {}", (Object)JdbcConnection.propsWithMaskedPassword(props));
            }
            LOGGER.trace("URL: {}", (Object)url);
            Connection conn = null;
            try {
                ClassLoader driverClassLoader = classloader;
                if (driverClassLoader == null) {
                    driverClassLoader = JdbcConnection.class.getClassLoader();
                }
                Class<?> driverClazz = Class.forName(driverClassName, true, driverClassLoader);
                Driver driver = (Driver)driverClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                conn = driver.connect(url, props);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new SQLException(e);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Connected to {} with {}", (Object)url, (Object)JdbcConnection.propsWithMaskedPassword(props));
            }
            return conn;
        };
    }

    private static Properties propsWithMaskedPassword(Properties props) {
        Properties filtered = new Properties();
        filtered.putAll((Map<?, ?>)props);
        if (props.containsKey(JdbcConfiguration.PASSWORD.name())) {
            filtered.put(JdbcConfiguration.PASSWORD.name(), "***");
        }
        return filtered;
    }

    private static Field[] combineVariables(Field[] overriddenVariables, Field ... defaultVariables) {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        if (defaultVariables != null) {
            for (Field variable : defaultVariables) {
                fields.put(variable.name(), variable);
            }
        }
        if (overriddenVariables != null) {
            for (Field variable : overriddenVariables) {
                fields.put(variable.name(), variable);
            }
        }
        return fields.values().toArray(new Field[fields.size()]);
    }

    private static String findAndReplace(String url, Properties props, Field ... variables) {
        for (Field field : variables) {
            if (field == null) continue;
            url = JdbcConnection.findAndReplace(url, field.name(), props, field.defaultValueAsString());
        }
        for (Object e : new HashSet<Object>(props.keySet())) {
            if (e == null) continue;
            url = JdbcConnection.findAndReplace(url, e.toString(), props, null);
        }
        return url;
    }

    private static String findAndReplace(String url, String name, Properties props, String defaultValue) {
        if (name != null && url.contains("${" + name + "}")) {
            String value = props.getProperty(name);
            if (value != null) {
                props.remove(name);
            }
            if (value == null) {
                value = defaultValue;
            }
            if (value != null) {
                url = url.replaceAll("\\$\\{" + name + "\\}", value);
            }
        }
        return url;
    }

    public JdbcConnection(Configuration config, ConnectionFactory connectionFactory) {
        this(config, connectionFactory, (Operations)null);
    }

    public JdbcConnection(Configuration config, ConnectionFactory connectionFactory, Supplier<ClassLoader> classLoaderSupplier) {
        this(config, connectionFactory, null, null, classLoaderSupplier);
    }

    public JdbcConnection(Configuration config, ConnectionFactory connectionFactory, Operations initialOperations) {
        this(config, connectionFactory, initialOperations, null);
    }

    protected JdbcConnection(Configuration config, ConnectionFactory connectionFactory, Operations initialOperations, Consumer<Configuration.Builder> adapter) {
        this(config, connectionFactory, initialOperations, adapter, null);
    }

    protected JdbcConnection(Configuration config, ConnectionFactory connectionFactory, Operations initialOperations, Consumer<Configuration.Builder> adapter, Supplier<ClassLoader> classLoaderSupplier) {
        this.config = adapter == null ? config : ((Configuration.Builder)config.edit().apply((Consumer)adapter)).build();
        this.factory = classLoaderSupplier == null ? connectionFactory : new ConnectionFactoryDecorator(connectionFactory, classLoaderSupplier);
        this.initialOps = initialOperations;
        this.conn = null;
    }

    public JdbcConfiguration config() {
        return JdbcConfiguration.adapt(this.config);
    }

    public JdbcConnection setAutoCommit(boolean autoCommit) throws SQLException {
        this.connection().setAutoCommit(autoCommit);
        return this;
    }

    public JdbcConnection commit() throws SQLException {
        Connection conn = this.connection();
        if (!conn.getAutoCommit()) {
            conn.commit();
        }
        return this;
    }

    public synchronized JdbcConnection rollback() throws SQLException {
        if (!this.isConnected()) {
            return this;
        }
        Connection conn = this.connection();
        if (!conn.getAutoCommit()) {
            conn.rollback();
        }
        return this;
    }

    public JdbcConnection connect() throws SQLException {
        this.connection();
        return this;
    }

    public JdbcConnection execute(String ... sqlStatements) throws SQLException {
        return this.execute((Statement statement) -> {
            for (String sqlStatement : sqlStatements) {
                if (sqlStatement == null) continue;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("executing '{}'", (Object)sqlStatement);
                }
                statement.execute(sqlStatement);
            }
        });
    }

    public JdbcConnection execute(Operations operations) throws SQLException {
        Connection conn = this.connection();
        try (Statement statement = conn.createStatement();){
            operations.apply(statement);
            this.commit();
        }
        return this;
    }

    public JdbcConnection query(String query, ResultSetConsumer resultConsumer) throws SQLException {
        return this.query(query, Connection::createStatement, resultConsumer);
    }

    public <T> T queryAndMap(String query, ResultSetMapper<T> mapper) throws SQLException {
        return this.queryAndMap(query, Connection::createStatement, mapper);
    }

    public JdbcConnection call(String sql, CallPreparer callPreparer, ResultSetConsumer resultSetConsumer) throws SQLException {
        Connection conn = this.connection();
        try (CallableStatement callableStatement = conn.prepareCall(sql);){
            if (callPreparer != null) {
                callPreparer.accept(callableStatement);
            }
            try (ResultSet rs = callableStatement.executeQuery();){
                if (resultSetConsumer != null) {
                    resultSetConsumer.accept(rs);
                }
            }
        }
        return this;
    }

    public JdbcConnection query(String query, StatementFactory statementFactory, ResultSetConsumer resultConsumer) throws SQLException {
        Connection conn = this.connection();
        try (Statement statement = statementFactory.createStatement(conn);){
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("running '{}'", (Object)query);
            }
            try (ResultSet resultSet = statement.executeQuery(query);){
                if (resultConsumer != null) {
                    resultConsumer.accept(resultSet);
                }
            }
        }
        return this;
    }

    public JdbcConnection prepareQuery(String[] multiQuery, StatementPreparer preparer, BlockingMultiResultSetConsumer resultConsumer) throws SQLException, InterruptedException {
        Object[] preparers = new StatementPreparer[multiQuery.length];
        Arrays.fill(preparers, preparer);
        return this.prepareQuery(multiQuery, (StatementPreparer[])preparers, resultConsumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcConnection prepareQuery(String[] multiQuery, StatementPreparer[] preparers, BlockingMultiResultSetConsumer resultConsumer) throws SQLException, InterruptedException {
        ResultSet[] resultSets = new ResultSet[multiQuery.length];
        PreparedStatement[] preparedStatements = new PreparedStatement[multiQuery.length];
        try {
            for (int i = 0; i < multiQuery.length; ++i) {
                PreparedStatement statement;
                String query = multiQuery[i];
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("running '{}'", (Object)query);
                }
                preparedStatements[i] = statement = this.createPreparedStatement(query);
                preparers[i].accept(statement);
                resultSets[i] = statement.executeQuery();
            }
            if (resultConsumer != null) {
                resultConsumer.accept(resultSets);
            }
        }
        finally {
            for (ResultSet rs : resultSets) {
                if (rs == null) continue;
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
        }
        return this;
    }

    /*
     * Exception decompiling
     */
    public <T> T queryAndMap(String query, StatementFactory statementFactory, ResultSetMapper<T> mapper) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public JdbcConnection queryWithBlockingConsumer(String query, StatementFactory statementFactory, BlockingResultSetConsumer resultConsumer) throws SQLException, InterruptedException {
        Connection conn = this.connection();
        try (Statement statement = statementFactory.createStatement(conn);){
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("running '{}'", (Object)query);
            }
            try (ResultSet resultSet = statement.executeQuery(query);){
                if (resultConsumer != null) {
                    resultConsumer.accept(resultSet);
                }
            }
        }
        return this;
    }

    public JdbcConnection prepareQueryWithBlockingConsumer(String preparedQueryString, StatementPreparer preparer, BlockingResultSetConsumer resultConsumer) throws SQLException, InterruptedException {
        PreparedStatement statement = this.createPreparedStatement(preparedQueryString);
        preparer.accept(statement);
        try (ResultSet resultSet = statement.executeQuery();){
            if (resultConsumer != null) {
                resultConsumer.accept(resultSet);
            }
        }
        return this;
    }

    public JdbcConnection prepareQuery(String preparedQueryString, StatementPreparer preparer, ResultSetConsumer resultConsumer) throws SQLException {
        PreparedStatement statement = this.createPreparedStatement(preparedQueryString);
        preparer.accept(statement);
        try (ResultSet resultSet = statement.executeQuery();){
            if (resultConsumer != null) {
                resultConsumer.accept(resultSet);
            }
        }
        return this;
    }

    public <T> T prepareQueryAndMap(String preparedQueryString, StatementPreparer preparer, ResultSetMapper<T> mapper) throws SQLException {
        Objects.requireNonNull(mapper, "Mapper must be provided");
        PreparedStatement statement = this.createPreparedStatement(preparedQueryString);
        preparer.accept(statement);
        try (ResultSet resultSet = statement.executeQuery();){
            T t = mapper.apply(resultSet);
            return t;
        }
    }

    public JdbcConnection prepareUpdate(String stmt, StatementPreparer preparer) throws SQLException {
        PreparedStatement statement = this.createPreparedStatement(stmt);
        if (preparer != null) {
            preparer.accept(statement);
        }
        statement.execute();
        return this;
    }

    public JdbcConnection prepareQuery(String preparedQueryString, List<?> parameters, ParameterResultSetConsumer resultConsumer) throws SQLException {
        PreparedStatement statement = this.createPreparedStatement(preparedQueryString);
        int index = 1;
        for (Object parameter : parameters) {
            statement.setObject(index++, parameter);
        }
        try (ResultSet resultSet = statement.executeQuery();){
            if (resultConsumer != null) {
                resultConsumer.accept(parameters, resultSet);
            }
        }
        return this;
    }

    public void print(ResultSet resultSet) {
        this.print(resultSet, System.out::println);
    }

    public void print(ResultSet resultSet, Consumer<String> lines) {
        try {
            int i;
            ResultSetMetaData rsmd = resultSet.getMetaData();
            int columnCount = rsmd.getColumnCount();
            int[] columnSizes = this.findMaxLength(resultSet);
            lines.accept(this.delimiter(columnCount, columnSizes));
            StringBuilder sb = new StringBuilder();
            for (i = 1; i <= columnCount; ++i) {
                if (i > 1) {
                    sb.append(" | ");
                }
                sb.append(Strings.setLength(rsmd.getColumnLabel(i), columnSizes[i], ' '));
            }
            lines.accept(sb.toString());
            sb.setLength(0);
            lines.accept(this.delimiter(columnCount, columnSizes));
            while (resultSet.next()) {
                sb.setLength(0);
                for (i = 1; i <= columnCount; ++i) {
                    if (i > 1) {
                        sb.append(" | ");
                    }
                    sb.append(Strings.setLength(resultSet.getString(i), columnSizes[i], ' '));
                }
                lines.accept(sb.toString());
                sb.setLength(0);
            }
            lines.accept(this.delimiter(columnCount, columnSizes));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private String delimiter(int columnCount, int[] columnSizes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= columnCount; ++i) {
            if (i > 1) {
                sb.append("---");
            }
            sb.append(Strings.createString('-', columnSizes[i]));
        }
        return sb.toString();
    }

    private int[] findMaxLength(ResultSet resultSet) throws SQLException {
        int i;
        ResultSetMetaData rsmd = resultSet.getMetaData();
        int columnCount = rsmd.getColumnCount();
        int[] columnSizes = new int[columnCount + 1];
        for (i = 1; i <= columnCount; ++i) {
            columnSizes[i] = Math.max(columnSizes[i], rsmd.getColumnLabel(i).length());
        }
        while (resultSet.next()) {
            for (i = 1; i <= columnCount; ++i) {
                String value = resultSet.getString(i);
                if (value == null) continue;
                columnSizes[i] = Math.max(columnSizes[i], value.length());
            }
        }
        resultSet.beforeFirst();
        return columnSizes;
    }

    public synchronized boolean isConnected() throws SQLException {
        if (this.conn == null) {
            return false;
        }
        return !this.conn.isClosed();
    }

    public synchronized Connection connection() throws SQLException {
        return this.connection(true);
    }

    public synchronized Connection connection(boolean executeOnConnect) throws SQLException {
        if (!this.isConnected()) {
            String statements;
            this.conn = this.factory.connect(JdbcConfiguration.adapt(this.config));
            if (!this.isConnected()) {
                throw new SQLException("Unable to obtain a JDBC connection");
            }
            if (this.initialOps != null) {
                this.execute(this.initialOps);
            }
            if ((statements = this.config.getString(JdbcConfiguration.ON_CONNECT_STATEMENTS)) != null && executeOnConnect) {
                List<String> splitStatements = this.parseSqlStatementString(statements);
                this.execute(splitStatements.toArray(new String[splitStatements.size()]));
            }
        }
        return this.conn;
    }

    protected List<String> parseSqlStatementString(String statements) {
        ArrayList<String> splitStatements = new ArrayList<String>();
        char[] statementsChars = statements.toCharArray();
        StringBuilder activeStatement = new StringBuilder();
        for (int i = 0; i < statementsChars.length; ++i) {
            if (statementsChars[i] == ';') {
                if (i == statementsChars.length - 1) continue;
                if (statementsChars[i + 1] == ';') {
                    activeStatement.append(';');
                    ++i;
                    continue;
                }
                String trimmedStatement = activeStatement.toString().trim();
                if (!trimmedStatement.isEmpty()) {
                    splitStatements.add(trimmedStatement);
                }
                activeStatement = new StringBuilder();
                continue;
            }
            activeStatement.append(statementsChars[i]);
        }
        String trimmedStatement = activeStatement.toString().trim();
        if (!trimmedStatement.isEmpty()) {
            splitStatements.add(trimmedStatement);
        }
        return splitStatements;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.conn != null) {
            try {
                this.statementCache.values().forEach(this::cleanupPreparedStatement);
                this.statementCache.clear();
                LOGGER.trace("Closing database connection");
                this.doClose();
            }
            finally {
                this.conn = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose() throws SQLException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Object> futureClose = executor.submit(() -> {
            this.conn.close();
            LOGGER.info("Connection gracefully closed");
            return null;
        });
        try {
            futureClose.get(10L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new DebeziumException(e.getCause());
        }
        catch (InterruptedException | TimeoutException e) {
            LOGGER.warn("Failed to close database connection by calling close(), attempting abort()");
            this.conn.abort(Runnable::run);
        }
        finally {
            executor.shutdownNow();
        }
    }

    public Set<String> readAllCatalogNames() throws SQLException {
        HashSet<String> catalogs = new HashSet<String>();
        DatabaseMetaData metadata = this.connection().getMetaData();
        try (ResultSet rs = metadata.getCatalogs();){
            while (rs.next()) {
                String catalogName = rs.getString(1);
                catalogs.add(catalogName);
            }
        }
        return catalogs;
    }

    public Set<String> readAllSchemaNames(Predicate<String> filter) throws SQLException {
        HashSet<String> schemas = new HashSet<String>();
        DatabaseMetaData metadata = this.connection().getMetaData();
        try (ResultSet rs = metadata.getSchemas();){
            while (rs.next()) {
                String schema = rs.getString(1);
                if (filter == null || !filter.test(schema)) continue;
                schemas.add(schema);
            }
        }
        return schemas;
    }

    public String[] tableTypes() throws SQLException {
        ArrayList<String> types = new ArrayList<String>();
        DatabaseMetaData metadata = this.connection().getMetaData();
        try (ResultSet rs = metadata.getTableTypes();){
            while (rs.next()) {
                String tableType = rs.getString(1);
                if (tableType == null) continue;
                types.add(tableType);
            }
        }
        return types.toArray(new String[types.size()]);
    }

    public Set<TableId> readAllTableNames(String[] tableTypes) throws SQLException {
        return this.readTableNames(null, null, null, tableTypes);
    }

    public Set<TableId> readTableNames(String databaseCatalog, String schemaNamePattern, String tableNamePattern, String[] tableTypes) throws SQLException {
        if (tableNamePattern == null) {
            tableNamePattern = "%";
        }
        HashSet<TableId> tableIds = new HashSet<TableId>();
        DatabaseMetaData metadata = this.connection().getMetaData();
        try (ResultSet rs = metadata.getTables(databaseCatalog, schemaNamePattern, tableNamePattern, tableTypes);){
            while (rs.next()) {
                String catalogName = rs.getString(1);
                String schemaName = rs.getString(2);
                String tableName = rs.getString(3);
                TableId tableId = new TableId(catalogName, schemaName, tableName);
                tableIds.add(tableId);
            }
        }
        return tableIds;
    }

    public String connectionString(String urlPattern) {
        Properties props = this.config.asProperties();
        return JdbcConnection.findAndReplace(urlPattern, props, JdbcConfiguration.DATABASE, JdbcConfiguration.HOSTNAME, JdbcConfiguration.PORT, JdbcConfiguration.USER, JdbcConfiguration.PASSWORD);
    }

    public String username() {
        return this.config.getString(JdbcConfiguration.USER);
    }

    public String database() {
        return this.config.getString(JdbcConfiguration.DATABASE);
    }

    protected int resolveNativeType(String typeName) {
        return -1;
    }

    protected int resolveJdbcType(int metadataJdbcType, int nativeType) {
        return metadataJdbcType;
    }

    public void readSchema(Tables tables, String databaseCatalog, String schemaNamePattern, Tables.TableFilter tableFilter, Tables.ColumnNameFilter columnFilter, boolean removeTablesNotFoundInJdbc) throws SQLException {
        HashSet<TableId> tableIdsBefore = new HashSet<TableId>(tables.tableIds());
        DatabaseMetaData metadata = this.connection().getMetaData();
        HashSet<TableId> viewIds = new HashSet<TableId>();
        HashSet<TableId> tableIds = new HashSet<TableId>();
        int totalTables = 0;
        ResultSet rs = metadata.getTables(databaseCatalog, schemaNamePattern, null, new String[]{"VIEW", "MATERIALIZED VIEW", "TABLE"});
        Iterator<Map.Entry<Object, Object>> iterator = null;
        try {
            while (rs.next()) {
                TableId tableId;
                String catalogName = rs.getString(1);
                String schemaName = rs.getString(2);
                String tableName = rs.getString(3);
                String tableType = rs.getString(4);
                if ("TABLE".equals(tableType)) {
                    ++totalTables;
                    tableId = new TableId(catalogName, schemaName, tableName);
                    if (tableFilter != null && !tableFilter.isIncluded(tableId)) continue;
                    tableIds.add(tableId);
                    continue;
                }
                tableId = new TableId(catalogName, schemaName, tableName);
                viewIds.add(tableId);
            }
        }
        catch (Throwable catalogName) {
            iterator = catalogName;
            throw catalogName;
        }
        finally {
            if (rs != null) {
                if (iterator != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable catalogName) {
                        ((Throwable)((Object)iterator)).addSuppressed(catalogName);
                    }
                } else {
                    rs.close();
                }
            }
        }
        Map<Object, Object> columnsByTable = new HashMap();
        if (totalTables == tableIds.size() || this.config.getBoolean(RelationalDatabaseConnectorConfig.SNAPSHOT_FULL_COLUMN_SCAN_FORCE)) {
            columnsByTable = this.getColumnsDetails(databaseCatalog, schemaNamePattern, null, tableFilter, columnFilter, metadata, viewIds);
        } else {
            for (TableId includeTable : tableIds) {
                Map<TableId, List<Column>> cols = this.getColumnsDetails(databaseCatalog, schemaNamePattern, includeTable.table(), tableFilter, columnFilter, metadata, viewIds);
                columnsByTable.putAll(cols);
            }
        }
        for (Map.Entry<Object, Object> tableEntry : columnsByTable.entrySet()) {
            List<String> pkColumnNames = this.readPrimaryKeyOrUniqueIndexNames(metadata, (TableId)tableEntry.getKey());
            List columns = (List)tableEntry.getValue();
            Collections.sort(columns);
            String defaultCharsetName = null;
            tables.overwriteTable((TableId)tableEntry.getKey(), columns, pkColumnNames, defaultCharsetName);
        }
        if (removeTablesNotFoundInJdbc) {
            tableIdsBefore.removeAll(columnsByTable.keySet());
            tableIdsBefore.forEach(tables::removeTable);
        }
    }

    private Map<TableId, List<Column>> getColumnsDetails(String databaseCatalog, String schemaNamePattern, String tableName, Tables.TableFilter tableFilter, Tables.ColumnNameFilter columnFilter, DatabaseMetaData metadata, Set<TableId> viewIds) throws SQLException {
        HashMap<TableId, List<Column>> columnsByTable = new HashMap<TableId, List<Column>>();
        try (ResultSet columnMetadata = metadata.getColumns(databaseCatalog, schemaNamePattern, tableName, null);){
            while (columnMetadata.next()) {
                String metaTableName;
                String schemaName;
                String catalogName = columnMetadata.getString(1);
                TableId tableId = new TableId(catalogName, schemaName = columnMetadata.getString(2), metaTableName = columnMetadata.getString(3));
                if (viewIds.contains(tableId) || tableFilter != null && !tableFilter.isIncluded(tableId)) continue;
                this.readTableColumn(columnMetadata, tableId, columnFilter).ifPresent(column -> columnsByTable.computeIfAbsent(tableId, t -> new ArrayList()).add(column.create()));
            }
        }
        return columnsByTable;
    }

    protected Optional<ColumnEditor> readTableColumn(ResultSet columnMetadata, TableId tableId, Tables.ColumnNameFilter columnFilter) throws SQLException {
        String defaultValue = columnMetadata.getString(13);
        String columnName = columnMetadata.getString(4);
        if (columnFilter == null || columnFilter.matches(tableId.catalog(), tableId.schema(), tableId.table(), columnName)) {
            ColumnEditor column = Column.editor().name(columnName);
            column.type(columnMetadata.getString(6));
            column.length(columnMetadata.getInt(7));
            if (columnMetadata.getObject(9) != null) {
                column.scale(columnMetadata.getInt(9));
            }
            column.optional(JdbcConnection.isNullable(columnMetadata.getInt(11)));
            column.position(columnMetadata.getInt(17));
            column.autoIncremented("YES".equalsIgnoreCase(columnMetadata.getString(23)));
            String autogenerated = null;
            try {
                autogenerated = columnMetadata.getString(24);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            column.generated("YES".equalsIgnoreCase(autogenerated));
            column.nativeType(this.resolveNativeType(column.typeName()));
            column.jdbcType(this.resolveJdbcType(columnMetadata.getInt(5), column.nativeType()));
            if (defaultValue != null) {
                this.getDefaultValue(column.create(), defaultValue).ifPresent(column::defaultValue);
            }
            return Optional.of(column);
        }
        return Optional.empty();
    }

    protected Optional<Object> getDefaultValue(Column column, String defaultValue) {
        return Optional.empty();
    }

    public List<String> readPrimaryKeyNames(DatabaseMetaData metadata, TableId id) throws SQLException {
        ArrayList<String> pkColumnNames = new ArrayList<String>();
        try (ResultSet rs = metadata.getPrimaryKeys(id.catalog(), id.schema(), id.table());){
            while (rs.next()) {
                String columnName = rs.getString(4);
                int columnIndex = rs.getInt(5);
                Collect.set(pkColumnNames, columnIndex - 1, columnName, null);
            }
        }
        return pkColumnNames;
    }

    public List<String> readTableUniqueIndices(DatabaseMetaData metadata, TableId id) throws SQLException {
        ArrayList<String> uniqueIndexColumnNames = new ArrayList<String>();
        try (ResultSet rs = metadata.getIndexInfo(id.catalog(), id.schema(), id.table(), true, true);){
            String firstIndexName = null;
            while (rs.next()) {
                String indexName = rs.getString(6);
                String columnName = rs.getString(9);
                int columnIndex = rs.getInt(8);
                if (firstIndexName == null) {
                    firstIndexName = indexName;
                }
                if (!this.isTableUniqueIndexIncluded(indexName, columnName)) continue;
                if (indexName != null && !indexName.equals(firstIndexName)) {
                    ArrayList<String> arrayList = uniqueIndexColumnNames;
                    return arrayList;
                }
                if (columnName == null) continue;
                Collect.set(uniqueIndexColumnNames, columnIndex - 1, columnName, null);
            }
        }
        return uniqueIndexColumnNames;
    }

    protected List<String> readPrimaryKeyOrUniqueIndexNames(DatabaseMetaData metadata, TableId id) throws SQLException {
        List<String> pkColumnNames = this.readPrimaryKeyNames(metadata, id);
        return pkColumnNames.isEmpty() ? this.readTableUniqueIndices(metadata, id) : pkColumnNames;
    }

    protected boolean isTableUniqueIndexIncluded(String indexName, String columnName) {
        return true;
    }

    private void cleanupPreparedStatement(PreparedStatement statement) {
        LOGGER.trace("Closing prepared statement '{}' removed from cache", (Object)statement);
        try {
            statement.close();
        }
        catch (Exception e) {
            LOGGER.info("Exception while closing a prepared statement removed from cache", (Throwable)e);
        }
    }

    private PreparedStatement createPreparedStatement(String preparedQueryString) {
        return this.statementCache.computeIfAbsent(preparedQueryString, query -> {
            try {
                LOGGER.trace("Inserting prepared statement '{}' removed from the cache", query);
                return this.connection().prepareStatement((String)query);
            }
            catch (SQLException e) {
                throw new ConnectException(e);
            }
        });
    }

    public JdbcConnection executeWithoutCommitting(String ... statements) throws SQLException {
        Connection conn = this.connection();
        try (Statement statement = conn.createStatement();){
            for (String stmt : statements) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Executing statement {}", (Object)stmt);
                }
                statement.execute(stmt);
            }
        }
        return this;
    }

    protected static boolean isNullable(int jdbcNullable) {
        return jdbcNullable == 1 || jdbcNullable == 2;
    }

    public <T> ResultSetMapper<T> singleResultMapper(ResultSetExtractor<T> extractor, String error) throws SQLException {
        return rs -> {
            if (rs.next()) {
                Object ret = extractor.apply(rs);
                if (!rs.next()) {
                    return ret;
                }
            }
            throw new IllegalStateException(error);
        };
    }

    public static <T> T querySingleValue(Connection connection, String queryString, StatementPreparer preparer, ResultSetExtractor<T> extractor) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(queryString);
        preparer.accept(preparedStatement);
        Throwable throwable = null;
        try (ResultSet resultSet = preparedStatement.executeQuery();){
            if (resultSet.next()) {
                T result = extractor.apply(resultSet);
                if (!resultSet.next()) {
                    T t = result;
                    return t;
                }
            }
            try {
                throw new IllegalStateException("Exactly one result expected.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @FunctionalInterface
    public static interface StatementFactory {
        public Statement createStatement(Connection var1) throws SQLException;
    }

    @FunctionalInterface
    public static interface CallPreparer {
        public void accept(CallableStatement var1) throws SQLException;
    }

    public static interface StatementPreparer {
        public void accept(PreparedStatement var1) throws SQLException;
    }

    public static interface BlockingMultiResultSetConsumer {
        public void accept(ResultSet[] var1) throws SQLException, InterruptedException;
    }

    public static interface MultiResultSetConsumer {
        public void accept(ResultSet[] var1) throws SQLException;
    }

    public static interface ParameterResultSetConsumer {
        public void accept(List<?> var1, ResultSet var2) throws SQLException;
    }

    public static interface BlockingResultSetConsumer {
        public void accept(ResultSet var1) throws SQLException, InterruptedException;
    }

    public static interface ResultSetMapper<T> {
        public T apply(ResultSet var1) throws SQLException;
    }

    public static interface ResultSetConsumer {
        public void accept(ResultSet var1) throws SQLException;
    }

    @FunctionalInterface
    public static interface ResultSetExtractor<T> {
        public T apply(ResultSet var1) throws SQLException;
    }

    @FunctionalInterface
    public static interface Operations {
        public void apply(Statement var1) throws SQLException;
    }

    private class ConnectionFactoryDecorator
    implements ConnectionFactory {
        private final ConnectionFactory defaultConnectionFactory;
        private final Supplier<ClassLoader> classLoaderSupplier;
        private ConnectionFactory customConnectionFactory;

        private ConnectionFactoryDecorator(ConnectionFactory connectionFactory, Supplier<ClassLoader> classLoaderSupplier) {
            this.defaultConnectionFactory = connectionFactory;
            this.classLoaderSupplier = classLoaderSupplier;
        }

        @Override
        public Connection connect(JdbcConfiguration config) throws SQLException {
            if (Strings.isNullOrEmpty(config.getConnectionFactoryClassName())) {
                return this.defaultConnectionFactory.connect(config);
            }
            if (this.customConnectionFactory == null) {
                this.customConnectionFactory = config.getInstance(JdbcConfiguration.CONNECTION_FACTORY_CLASS, ConnectionFactory.class, this.classLoaderSupplier);
            }
            return this.customConnectionFactory.connect(config);
        }
    }

    @FunctionalInterface
    @ThreadSafe
    public static interface ConnectionFactory {
        public Connection connect(JdbcConfiguration var1) throws SQLException;
    }
}

