/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.workload;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.workload.PayloadGenerator;

public class ConstantPayloadGenerator
implements PayloadGenerator {
    private final int size;
    private final byte[] value;

    @JsonCreator
    public ConstantPayloadGenerator(@JsonProperty(value="size") int size, @JsonProperty(value="value") byte[] value) {
        this.size = size;
        this.value = value == null || value.length == 0 ? new byte[size] : value;
    }

    @JsonProperty
    public int size() {
        return this.size;
    }

    @JsonProperty
    public byte[] value() {
        return this.value;
    }

    @Override
    public byte[] generate(long position) {
        byte[] next = new byte[this.size];
        for (int i = 0; i < next.length; i += this.value.length) {
            System.arraycopy(this.value, 0, next, i, Math.min(next.length - i, this.value.length));
        }
        return next;
    }
}

