/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corebase.utils;

import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadUtils {
    private static final Logger logger = LoggerFactory.getLogger(ThreadUtils.class);
    private static final AtomicInteger poolNumber = new AtomicInteger(1);

    public static Thread setDaemonThreadRunning(Thread t) {
        return ThreadUtils.setDaemonThreadRunning(t, t.getName());
    }

    public static Thread setDaemonThreadRunning(Thread t, String name) {
        return ThreadUtils.setDaemonThreadRunning(t, name, null);
    }

    public static Thread setDaemonThreadRunning(Thread t, String name, Thread.UncaughtExceptionHandler handler) {
        t.setName(name);
        if (handler != null) {
            t.setUncaughtExceptionHandler(handler);
        }
        t.setDaemon(true);
        t.start();
        return t;
    }

    public static void shutdown(Thread t) {
        ThreadUtils.shutdown(t, 0L);
    }

    public static void shutdown(Thread t, long joinwait) {
        if (t == null) {
            return;
        }
        while (t.isAlive()) {
            try {
                t.join(joinwait);
            }
            catch (InterruptedException e) {
                logger.warn(t.getName() + "; joinwait=" + joinwait, e);
            }
        }
    }

    public static void threadDumpingIsAlive(Thread t) throws InterruptedException {
        if (t == null) {
            return;
        }
        while (t.isAlive()) {
            t.join(60000L);
            if (!t.isAlive()) continue;
            logger.info("Automatic Stack Trace every 60 seconds waiting on " + t.getName());
        }
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

