/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corebase.utils;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.inlong.tubemq.corebase.Message;
import org.apache.inlong.tubemq.corebase.utils.DateTimeConvertUtils;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.corebase.utils.ThreadUtils;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;

public class MixedUtils {
    private static String javaVersion = "";

    public static String getJavaVersion() {
        if (TStringUtils.isEmpty(javaVersion)) {
            return "";
        }
        int maxLen = Math.min(javaVersion.length(), 100);
        return javaVersion.substring(0, maxLen);
    }

    public static Map<String, TreeSet<String>> parseTopicParam(String topicParam) {
        String[] topicFilterStrs;
        HashMap<String, TreeSet<String>> topicAndFiltersMap = new HashMap<String, TreeSet<String>>();
        if (TStringUtils.isBlank(topicParam)) {
            return topicAndFiltersMap;
        }
        for (String topicFilterStr : topicFilterStrs = topicParam.split(",")) {
            String[] topicFilters;
            if (TStringUtils.isBlank(topicFilterStr) || TStringUtils.isBlank((topicFilters = topicFilterStr.split(":"))[0])) continue;
            TreeSet<String> filterSet = new TreeSet<String>();
            if (topicFilters.length > 1 && TStringUtils.isNotBlank(topicFilters[1])) {
                String[] filterItems;
                for (String filterItem : filterItems = topicFilters[1].split(";")) {
                    if (TStringUtils.isBlank(filterItem)) continue;
                    filterSet.add(filterItem.trim());
                }
            }
            topicAndFiltersMap.put(topicFilters[0].trim(), filterSet);
        }
        return topicAndFiltersMap;
    }

    public static List<Tuple2<String, String>> buildTopicFilterTupleList(Map<String, TreeSet<String>> topicAndFiltersMap) {
        ArrayList<Tuple2<String, String>> topicFilterTuples = new ArrayList<Tuple2<String, String>>();
        for (Map.Entry<String, TreeSet<String>> entry : topicAndFiltersMap.entrySet()) {
            if (entry.getValue().isEmpty()) {
                topicFilterTuples.add(new Tuple2(entry.getKey()));
                continue;
            }
            for (String filter : entry.getValue()) {
                topicFilterTuples.add(new Tuple2<String, String>(entry.getKey(), filter));
            }
        }
        return topicFilterTuples;
    }

    public static byte[] buildTestData(int bodySize) {
        byte[] transmitData = StringUtils.getBytesUtf8("This is a test data!");
        ByteBuffer dataBuffer = ByteBuffer.allocate(bodySize);
        while (dataBuffer.hasRemaining()) {
            int offset = dataBuffer.arrayOffset();
            dataBuffer.put(transmitData, offset, Math.min(dataBuffer.remaining(), transmitData.length));
        }
        dataBuffer.flip();
        return dataBuffer.array();
    }

    public static Message buildMessage(String topicName, String filterItem, byte[] bodyData, long serialId) {
        Message message = new Message(topicName, bodyData);
        long currTimeMillis = System.currentTimeMillis();
        message.setAttrKeyVal("serialId", String.valueOf(serialId));
        message.setAttrKeyVal("dataTime", String.valueOf(currTimeMillis));
        message.putSystemHeader(filterItem, DateTimeConvertUtils.ms2yyyyMMddHHmm(currTimeMillis));
        return message;
    }

    public static void coolSending(long msgSentCount) {
        if (msgSentCount % 5000L == 0L) {
            ThreadUtils.sleep(3000L);
        } else if (msgSentCount % 4000L == 0L) {
            ThreadUtils.sleep(2000L);
        } else if (msgSentCount % 2000L == 0L) {
            ThreadUtils.sleep(800L);
        } else if (msgSentCount % 1000L == 0L) {
            ThreadUtils.sleep(400L);
        }
    }

    public static int mid(int data, int min2, int max) {
        return Math.max(min2, Math.min(max, data));
    }

    public static long mid(long data, long min2, long max) {
        return Math.max(min2, Math.min(max, data));
    }

    static {
        javaVersion = System.getProperty("java.version");
    }
}

