/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corebase.metric.impl;

import java.util.Map;
import org.apache.inlong.tubemq.corebase.metric.Histogram;
import org.apache.inlong.tubemq.corebase.metric.impl.BaseMetric;
import org.apache.inlong.tubemq.corebase.metric.impl.LongMaxGauge;
import org.apache.inlong.tubemq.corebase.metric.impl.LongMinGauge;
import org.apache.inlong.tubemq.corebase.metric.impl.LongStatsCounter;

public class ESTHistogram
extends BaseMetric
implements Histogram {
    private static final int NUM_BUCKETS = 18;
    private static final int MAX_BUCKET_INDEX = 17;
    private static final long POWER_2_17 = 131072L;
    private static final double LOG2_VALUE = Math.log(2.0);
    private final LongStatsCounter count;
    private final LongMinGauge min;
    private final LongMaxGauge max;
    private final LongStatsCounter[] buckets = new LongStatsCounter[18];

    public ESTHistogram(String metricName, String prefix) {
        super(metricName, prefix);
        this.count = new LongStatsCounter("count", this.getFullName());
        this.min = new LongMinGauge("min", this.getFullName());
        this.max = new LongMaxGauge("max", this.getFullName());
        StringBuilder strBuff = new StringBuilder(512);
        for (int i = 0; i < 18; ++i) {
            strBuff.append("cell_");
            if (i == 0) {
                strBuff.append(0).append("t").append((int)Math.pow(2.0, i + 1));
            } else if (i == 17) {
                strBuff.append((int)Math.pow(2.0, i)).append("tMax");
            } else {
                strBuff.append((int)Math.pow(2.0, i)).append("t").append((int)Math.pow(2.0, i + 1));
            }
            this.buckets[i] = new LongStatsCounter(strBuff.toString(), this.getFullName());
            strBuff.delete(0, strBuff.length());
        }
    }

    @Override
    public void update(long newValue) {
        this.count.incValue();
        this.min.update(newValue);
        this.max.update(newValue);
        int index = newValue <= 0L ? 0 : (newValue >= 131072L ? 17 : (int)(Math.log(newValue) / LOG2_VALUE));
        this.buckets[index].incValue();
    }

    @Override
    public void getValue(Map<String, Long> keyValMap, boolean includeZero) {
        keyValMap.put(this.count.getFullName(), this.count.getValue());
        keyValMap.put(this.min.getFullName(), this.min.getValue());
        keyValMap.put(this.max.getFullName(), this.max.getValue());
        if (includeZero) {
            for (int i = 0; i < 18; ++i) {
                keyValMap.put(this.buckets[i].getFullName(), this.buckets[i].getValue());
            }
        } else {
            for (int i = 0; i < 18; ++i) {
                long tmpValue = this.buckets[i].getValue();
                if (tmpValue <= 0L) continue;
                keyValMap.put(this.buckets[i].getFullName(), tmpValue);
            }
        }
    }

    @Override
    public void getValue(StringBuilder strBuff, boolean includeZero) {
        strBuff.append("\"").append(this.getFullName()).append("\":").append("{\"").append(this.count.getShortName()).append("\":").append(this.count.getValue()).append(",\"").append(this.min.getShortName()).append("\":").append(this.min.getValue()).append(",\"").append(this.max.getShortName()).append("\":").append(this.max.getValue()).append(",\"cells\":{");
        int count = 0;
        if (includeZero) {
            for (int i = 0; i < 18; ++i) {
                if (count++ > 0) {
                    strBuff.append(",");
                }
                strBuff.append("\"").append(this.buckets[i].getShortName()).append("\":").append(this.buckets[i].getValue());
            }
        } else {
            for (int i = 0; i < 18; ++i) {
                long tmpValue = this.buckets[i].getValue();
                if (tmpValue <= 0L) continue;
                if (count++ > 0) {
                    strBuff.append(",");
                }
                strBuff.append("\"").append(this.buckets[i].getShortName()).append("\":").append(tmpValue);
            }
        }
        strBuff.append("}}");
    }

    @Override
    public void snapShort(Map<String, Long> keyValMap, boolean includeZero) {
        keyValMap.put(this.count.getFullName(), this.count.getAndResetValue());
        keyValMap.put(this.min.getFullName(), this.min.getAndResetValue());
        keyValMap.put(this.max.getFullName(), this.max.getAndResetValue());
        if (includeZero) {
            for (int i = 0; i < 18; ++i) {
                keyValMap.put(this.buckets[i].getFullName(), this.buckets[i].getAndResetValue());
            }
        } else {
            for (int i = 0; i < 18; ++i) {
                long tmpValue = this.buckets[i].getAndResetValue();
                if (tmpValue <= 0L) continue;
                keyValMap.put(this.buckets[i].getFullName(), tmpValue);
            }
        }
    }

    @Override
    public void snapShort(StringBuilder strBuff, boolean includeZero) {
        strBuff.append("\"").append(this.getFullName()).append("\":").append("{\"").append(this.count.getShortName()).append("\":").append(this.count.getAndResetValue()).append(",\"").append(this.min.getShortName()).append("\":").append(this.min.getAndResetValue()).append(",\"").append(this.max.getShortName()).append("\":").append(this.max.getAndResetValue()).append(",\"cells\":{");
        int count = 0;
        if (includeZero) {
            for (int i = 0; i < 18; ++i) {
                if (count++ > 0) {
                    strBuff.append(",");
                }
                strBuff.append("\"").append(this.buckets[i].getShortName()).append("\":").append(this.buckets[i].getAndResetValue());
            }
        } else {
            for (int i = 0; i < 18; ++i) {
                long tmpValue = this.buckets[i].getAndResetValue();
                if (tmpValue <= 0L) continue;
                if (count++ > 0) {
                    strBuff.append(",");
                }
                strBuff.append("\"").append(this.buckets[i].getShortName()).append("\":").append(tmpValue);
            }
        }
        strBuff.append("}}");
    }

    @Override
    public void clear() {
        this.count.clear();
        this.min.clear();
        this.max.clear();
        for (int i = 0; i < 18; ++i) {
            this.buckets[i].clear();
        }
    }
}

